/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;

public class ListItemTransferHandler
extends TransferHandler {
    private static final Logger logger = Logger.getLogger(ListItemTransferHandler.class.toString());
    private static DataFlavor dataFlavor;
    private int[] indices;
    private int addIndex = -1;
    private int addCount;

    public ListItemTransferHandler() {
        try {
            dataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=\"" + Object[].class.getName() + "\"");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        JList jList = (JList)jComponent;
        this.indices = jList.getSelectedIndices();
        Object[] objectArray = jList.getSelectedValuesList().toArray();
        return new ObjectSelection(objectArray);
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        return transferSupport.isDrop() && transferSupport.isDataFlavorSupported(dataFlavor);
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 2;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        if (!this.canImport(transferSupport)) {
            return false;
        }
        JList jList = (JList)transferSupport.getComponent();
        JList.DropLocation dropLocation = (JList.DropLocation)transferSupport.getDropLocation();
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        int n = dropLocation.getIndex();
        int n2 = defaultListModel.getSize();
        if (n < 0 || n > n2) {
            n = n2;
        }
        this.addIndex = n;
        try {
            Object[] objectArray = (Object[])transferSupport.getTransferable().getTransferData(dataFlavor);
            this.addCount = objectArray.length;
            for (Object object : objectArray) {
                int n3 = n++;
                defaultListModel.add(n3, object);
                jList.addSelectionInterval(n3, n3);
            }
            return true;
        }
        catch (UnsupportedFlavorException | IOException exception) {
            logger.log(Level.WARNING, "Requested data flavor is not supported or unavailable.", exception);
            return false;
        }
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        this.cleanup(jComponent, n == 2);
    }

    private void cleanup(JComponent jComponent, boolean bl) {
        if (bl && this.indices != null) {
            int n;
            JList jList = (JList)jComponent;
            DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
            if (this.addCount > 0) {
                for (n = 0; n < this.indices.length; ++n) {
                    if (this.indices[n] < this.addIndex) continue;
                    int n2 = n;
                    this.indices[n2] = this.indices[n2] + this.addCount;
                }
            }
            for (n = this.indices.length - 1; n >= 0; --n) {
                defaultListModel.remove(this.indices[n]);
            }
        }
        this.indices = null;
        this.addCount = 0;
        this.addIndex = -1;
    }

    static class ObjectSelection
    implements Transferable {
        private final Object[] data;

        ObjectSelection(Object[] objectArray) {
            this.data = objectArray;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{dataFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return ListItemTransferHandler.dataFlavor.equals(dataFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!ListItemTransferHandler.dataFlavor.equals(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.data;
        }
    }
}

