/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.icepdf.ri.common.CurrentPageChanger;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.Controller;

public class KeyListenerPageColumnChanger
extends KeyAdapter {
    private final Controller controller;
    private final JScrollPane scroll;
    private final AbstractDocumentView documentView;
    private final CurrentPageChanger currentPageChanger;
    private boolean changingPage;

    public static KeyListenerPageColumnChanger install(Controller controller, JScrollPane jScrollPane, AbstractDocumentView abstractDocumentView, CurrentPageChanger currentPageChanger) {
        KeyListenerPageColumnChanger keyListenerPageColumnChanger = null;
        if (controller != null && jScrollPane != null) {
            keyListenerPageColumnChanger = new KeyListenerPageColumnChanger(controller, jScrollPane, abstractDocumentView, currentPageChanger);
            jScrollPane.addKeyListener(keyListenerPageColumnChanger);
        }
        return keyListenerPageColumnChanger;
    }

    public void uninstall() {
        if (this.scroll != null) {
            this.scroll.removeKeyListener(this);
        }
    }

    protected KeyListenerPageColumnChanger(Controller controller, JScrollPane jScrollPane, AbstractDocumentView abstractDocumentView, CurrentPageChanger currentPageChanger) {
        this.controller = controller;
        this.scroll = jScrollPane;
        this.documentView = abstractDocumentView;
        this.changingPage = false;
        this.currentPageChanger = currentPageChanger;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.changingPage) {
            return;
        }
        int n = 0;
        int n2 = keyEvent.getKeyCode();
        if (n2 == 34) {
            n = this.documentView.getPreviousPageIncrement();
        } else if (n2 == 33) {
            n = -this.documentView.getNextPageIncrement();
        } else if (n2 == 36) {
            n = -this.controller.getCurrentPageNumber();
        } else if (n2 == 35) {
            n = this.controller.getDocument().getNumberOfPages() - this.controller.getCurrentPageNumber() - 1;
        }
        if (n == 0) {
            return;
        }
        int n3 = this.controller.getCurrentPageNumber() + n;
        if (this.controller.getDocument() == null) {
            return;
        }
        if (n3 < 0) {
            n = -this.controller.getCurrentPageNumber();
        }
        if (n3 >= this.controller.getDocument().getNumberOfPages()) {
            n = this.controller.getDocument().getNumberOfPages() - this.controller.getCurrentPageNumber() - 1;
        }
        this.changingPage = true;
        int n4 = n;
        SwingUtilities.invokeLater(() -> {
            this.changingPage = false;
            this.controller.goToDeltaPage(n4);
        });
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        block3: {
            block2: {
                int n = keyEvent.getKeyCode();
                if (n == 38) break block2;
                if (n != 40) break block3;
            }
            SwingUtilities.invokeLater(this.currentPageChanger::calculateCurrentPage);
        }
    }
}

