/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.Toolkit;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class FloatTextFieldInputVerifier
extends InputVerifier {
    private int maxLength = 6;

    public FloatTextFieldInputVerifier() {
    }

    public FloatTextFieldInputVerifier(int n) {
        this.maxLength = n;
    }

    @Override
    public boolean verify(JComponent jComponent) {
        boolean bl = true;
        JTextField jTextField = (JTextField)jComponent;
        String string = jTextField.getText();
        if (string.length() != 0 && string.length() < this.maxLength) {
            try {
                Float.parseFloat(jTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        } else if (string.length() > 0) {
            jTextField.setText(string.substring(0, this.maxLength));
        } else {
            jTextField.setText("");
        }
        return bl;
    }

    @Override
    public boolean shouldYieldFocus(JComponent jComponent) {
        boolean bl = super.shouldYieldFocus(jComponent);
        if (!bl) {
            Toolkit.getDefaultToolkit().beep();
        }
        return bl;
    }
}

