/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.viewer;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.SystemProperties;
import org.icepdf.ri.common.ViewModel;
import org.icepdf.ri.util.FontPropertiesManager;
import org.icepdf.ri.util.URLAccess;
import org.icepdf.ri.util.ViewerPropertiesManager;
import org.icepdf.ri.viewer.WindowManager;

public class Launcher {
    private static final Logger logger = Logger.getLogger(Launcher.class.toString());
    public static final String APPLICATION_LOOK_AND_FEEL = "application.lookandfeel";
    private static ViewerPropertiesManager propertiesManager;

    public static void main(String[] stringArray) {
        boolean bl = false;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = null;
        block14: for (int i = 0; i < stringArray.length; ++i) {
            String string6;
            if (i == stringArray.length - 1) {
                bl = true;
                break;
            }
            switch (string6 = stringArray[i]) {
                case "-loadfile": {
                    string2 = stringArray[++i].trim();
                    continue block14;
                }
                case "-loadurl": {
                    string = stringArray[++i].trim();
                    continue block14;
                }
                case "-pkcs11path": {
                    string3 = stringArray[++i].trim();
                    continue block14;
                }
                case "-pkcs12path": {
                    string4 = stringArray[++i].trim();
                    continue block14;
                }
                case "-print": {
                    string5 = stringArray[++i].trim();
                    continue block14;
                }
                default: {
                    bl = true;
                }
            }
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.icepdf.ri.resources.MessageBundle");
        if (bl) {
            System.out.println(resourceBundle.getString("viewer.commandLin.error"));
            System.exit(1);
        }
        Launcher.run(string2, string, string5, string3, string4, resourceBundle);
    }

    private static void run(String string, String string2, String string3, String string4, String string5, ResourceBundle resourceBundle) {
        propertiesManager = ViewerPropertiesManager.getInstance();
        FontPropertiesManager.getInstance().loadOrReadSystemFonts();
        Launcher.setupLookAndFeel(resourceBundle);
        ViewModel.setDefaultFilePath(propertiesManager.getPreferences().get("application.default.filepath", null));
        ViewModel.setDefaultURL(propertiesManager.getPreferences().get("application.default.url", null));
        if (string5 != null && !string5.isEmpty()) {
            propertiesManager.getPreferences().put("org.icepdf.core.signatures.keystore.pkcs12.config.path", string5);
            propertiesManager.getPreferences().put("org.icepdf.core.signatures.keystore.type", "PKCS#12");
        } else if (string4 != null && !string4.isEmpty()) {
            propertiesManager.getPreferences().put("org.icepdf.core.signatures.keystore.pkcs11.config.path", string4);
            propertiesManager.getPreferences().put("org.icepdf.core.signatures.keystore.type", "PKCS#11");
        }
        WindowManager windowManager = WindowManager.createInstance(propertiesManager, resourceBundle);
        if (string != null && !string.isEmpty()) {
            if (string3 != null) {
                windowManager.newWindow(string, string3);
            } else {
                windowManager.newWindow(string);
            }
            ViewModel.setDefaultFilePath(string);
        }
        if (string2 != null && !string2.isEmpty()) {
            URLAccess uRLAccess = URLAccess.doURLAccess(string2);
            uRLAccess.closeConnection();
            if (uRLAccess.errorMessage != null) {
                Object[] objectArray = new Object[]{uRLAccess.errorMessage, uRLAccess.urlLocation};
                MessageFormat messageFormat = new MessageFormat(resourceBundle.getString("viewer.launcher.URLError.dialog.message"));
                JOptionPane.showMessageDialog(null, messageFormat.format(objectArray), resourceBundle.getString("viewer.launcher.URLError.dialog.title"), 1);
            } else if (string3 != null) {
                windowManager.newWindow(uRLAccess.url, string3);
            } else {
                windowManager.newWindow(uRLAccess.url);
            }
            ViewModel.setDefaultURL(uRLAccess.urlLocation);
            uRLAccess.dispose();
        }
        if ((string == null || string.isEmpty()) && (string2 == null || string2.isEmpty()) || windowManager.getNumberOfWindows() == 0L) {
            windowManager.newWindow("");
        }
    }

    private static void setupLookAndFeel(ResourceBundle resourceBundle) {
        Object object;
        if (SystemProperties.OS_NAME.contains("OS X")) {
            Defs.setSystemProperty((String)"apple.laf.useScreenMenuBar", (String)"true");
            object = resourceBundle.getString("viewer.window.title.default");
            Defs.setSystemProperty((String)"com.apple.mrj.application.apple.menu.about.name", (String)object);
        }
        object = propertiesManager.getPreferences();
        String string = propertiesManager.getLookAndFeel(APPLICATION_LOOK_AND_FEEL, null, resourceBundle);
        if (string != null) {
            try {
                UIManager.setLookAndFeel(string);
                return;
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{((Preferences)object).get(APPLICATION_LOOK_AND_FEEL, null)};
                MessageFormat messageFormat = new MessageFormat(resourceBundle.getString("viewer.launcher.URLError.dialog.message"));
                JOptionPane.showMessageDialog(null, messageFormat.format(objectArray), resourceBundle.getString("viewer.launcher.lookAndFeel.error.message"), 0);
            }
        }
        try {
            String string2 = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(string2);
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Error setting Swing Look and Feel.", exception);
        }
    }
}

