/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.util;

import java.util.ResourceBundle;
import javax.swing.UIManager;
import org.icepdf.ri.util.Resources;

final class Parse {
    private static final String[] booleanNames = new String[]{"yes", "no", "true", "false"};
    private static final boolean[] booleans = new boolean[]{true, false, true, false};

    Parse() {
    }

    public static Integer parseInteger(String string, ResourceBundle resourceBundle) {
        string = string.trim();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (resourceBundle != null) {
                Resources.showMessageDialog(null, 1, resourceBundle, "parse.title", "parse.integer", string);
            }
            return null;
        }
    }

    public static Long parseLong(String string, ResourceBundle resourceBundle) {
        string = string.trim();
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (resourceBundle != null) {
                Resources.showMessageDialog(null, 1, resourceBundle, "parse.title", "parse.float", string);
            }
            return null;
        }
    }

    public static Float parseFloat(String string, ResourceBundle resourceBundle) {
        string = string.trim();
        try {
            return Float.valueOf(Float.parseFloat(string));
        }
        catch (NumberFormatException numberFormatException) {
            if (resourceBundle != null) {
                Resources.showMessageDialog(null, 1, resourceBundle, "parse.title", "parse.float", string);
            }
            return null;
        }
    }

    public static Double parseDouble(String string, ResourceBundle resourceBundle) {
        string = string.trim();
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (resourceBundle != null) {
                Resources.showMessageDialog(null, 1, resourceBundle, "parse.title", "parse.double", string);
            }
            return null;
        }
    }

    public static Boolean parseBoolean(String string, ResourceBundle resourceBundle) {
        string = string.trim();
        for (int i = 0; i < booleanNames.length; ++i) {
            if (!string.equalsIgnoreCase(booleanNames[i])) continue;
            return booleans[i] ? Boolean.TRUE : Boolean.FALSE;
        }
        if (resourceBundle != null) {
            Resources.showMessageDialog(null, 1, resourceBundle, "parse.title", "parse.choice", string);
        }
        return null;
    }

    public static String parseLookAndFeel(String string, ResourceBundle resourceBundle) {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray;
        string = string.trim();
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels()) {
            if (!string.equalsIgnoreCase(lookAndFeelInfo.getName())) continue;
            return lookAndFeelInfo.getClassName();
        }
        if (resourceBundle != null) {
            Resources.showMessageDialog(null, 1, resourceBundle, "parse.title", "parse.laf", string);
        }
        return null;
    }
}

