/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.util;

import java.util.Map;
import java.util.Objects;
import org.icepdf.ri.util.ImmutablePair;

public abstract class Pair<L, R>
implements Map.Entry<L, R> {
    public static <L, R> Pair<L, R> of(L l, R r) {
        return new ImmutablePair<L, R>(l, r);
    }

    public abstract L getLeft();

    public abstract R getRight();

    @Override
    public final L getKey() {
        return this.getLeft();
    }

    @Override
    public R getValue() {
        return this.getRight();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)object;
            return Objects.equals(this.getKey(), entry.getKey()) && Objects.equals(this.getValue(), entry.getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
    }

    public String toString() {
        return "(" + String.valueOf(this.getLeft()) + "," + String.valueOf(this.getRight()) + ")";
    }

    public String toString(String string) {
        return String.format(string, this.getLeft(), this.getRight());
    }
}

