/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.util;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.icepdf.core.pobjects.fonts.FontManager;
import org.icepdf.ri.util.font.FontCache;

public class FontPropertiesManager {
    private static final Logger logger = Logger.getLogger(FontPropertiesManager.class.toString());
    private static final Preferences prefs = Preferences.userNodeForPackage(FontCache.class);
    private static FontPropertiesManager fontPropertiesManager;
    private static final FontManager fontManager;

    private FontPropertiesManager() {
    }

    public static FontPropertiesManager getInstance() {
        if (fontPropertiesManager == null) {
            fontPropertiesManager = new FontPropertiesManager();
        }
        return fontPropertiesManager;
    }

    public void loadOrReadSystemFonts() {
        if (this.isFontPropertiesEmpty()) {
            this.readDefaultFontProperties(new String[0]);
            this.saveProperties();
        } else {
            this.loadProperties();
        }
    }

    public void readDefaultFontProperties(String ... stringArray) {
        block2: {
            try {
                fontManager.readSystemFonts(stringArray);
            }
            catch (Exception exception) {
                if (!logger.isLoggable(Level.FINE)) break block2;
                logger.log(Level.FINE, "Error reading system fonts path: ", exception);
            }
        }
    }

    public void readFontProperties(String ... stringArray) {
        block2: {
            try {
                fontManager.readFonts(stringArray);
            }
            catch (Exception exception) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.log(Level.WARNING, "Error reading system paths:", exception);
            }
        }
    }

    public void loadProperties() {
        fontManager.setFontProperties(prefs);
    }

    public void clearProperties() {
        block2: {
            try {
                prefs.clear();
                fontManager.clearFontList();
            }
            catch (BackingStoreException backingStoreException) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.log(Level.WARNING, "Error reading system paths:", backingStoreException);
            }
        }
    }

    public void saveProperties() {
        Properties properties = fontManager.getFontProperties();
        for (Object object : properties.keySet()) {
            prefs.put((String)object, properties.getProperty((String)object));
        }
    }

    public boolean isFontPropertiesEmpty() {
        try {
            return prefs.keys().length == 0;
        }
        catch (BackingStoreException backingStoreException) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Error writing system fonts to backing store: ", backingStoreException);
            }
            return false;
        }
    }

    public static FontManager getFontManager() {
        return fontManager;
    }

    static {
        fontManager = FontManager.getInstance();
    }
}

