/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.widgets.annotations;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.widgets.annotations.AnnotationColorToggleButton;
import org.icepdf.ri.images.IconPack;
import org.icepdf.ri.images.Images;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class IconAnnotationColorToggleButton
extends AnnotationColorToggleButton {
    private final BufferedImage baseImage;
    private final float alpha;

    public IconAnnotationColorToggleButton(Controller controller, ResourceBundle resourceBundle, String string, String string2, String string3, String string4, Images.IconSize iconSize, Font font, float f) {
        this(controller, resourceBundle, string, string2, string3, string4, iconSize, font, f, Color.YELLOW);
    }

    public IconAnnotationColorToggleButton(Controller controller, ResourceBundle resourceBundle, String string, String string2, String string3, String string4, Images.IconSize iconSize, Font font, float f, Color color) {
        super(controller, resourceBundle, string, string2, string3, string4, iconSize, font);
        this.alpha = f;
        Icon icon = Images.getSingleIcon(string4, IconPack.Variant.NORMAL, iconSize);
        this.baseImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D graphics2D = this.baseImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        this.setupLayout();
        Color color2 = new Color(ViewerPropertiesManager.getInstance().checkAndStoreIntProperty(string3, color.getRGB()));
        this.setColor(color2, false);
    }

    @Override
    public void setColor(Color color, boolean bl) {
        BufferedImage bufferedImage = new BufferedImage(this.baseImage.getWidth(), this.baseImage.getHeight(), 2);
        for (int i = 0; i < this.baseImage.getWidth(); ++i) {
            for (int j = 0; j < this.baseImage.getHeight(); ++j) {
                Color color2 = new Color(this.baseImage.getRGB(i, j), true);
                if (color2.getRed() == 255 && color2.getGreen() == 255 && color2.getBlue() == 255) {
                    bufferedImage.setRGB(i, j, this.multiply(color2, color).getRGB());
                    continue;
                }
                bufferedImage.setRGB(i, j, color2.getRGB());
            }
        }
        this.colorButton.setIcon(new ImageIcon(bufferedImage));
        super.setColor(color, bl);
    }

    private Color multiply(Color color, Color color2) {
        float[] fArray = color.getRGBComponents(null);
        float[] fArray2 = color2.getRGBColorComponents(null);
        float[] fArray3 = new float[3];
        for (int i = 0; i < 3; ++i) {
            fArray3[i] = fArray[i] * fArray2[i];
        }
        return new Color(fArray3[0], fArray3[1], fArray3[2], this.alpha);
    }
}

