/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations.acroform;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.acroform.TextFieldDictionary;
import org.icepdf.core.pobjects.acroform.VariableTextFieldDictionary;
import org.icepdf.core.pobjects.annotations.Appearance;
import org.icepdf.core.pobjects.annotations.AppearanceState;
import org.icepdf.core.pobjects.annotations.TextWidgetAnnotation;
import org.icepdf.core.pobjects.graphics.text.LineText;
import org.icepdf.core.pobjects.graphics.text.WordText;
import org.icepdf.core.util.SystemProperties;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.ScalableField;
import org.icepdf.ri.common.views.annotations.ScalablePasswordField;
import org.icepdf.ri.common.views.annotations.ScalableTextArea;
import org.icepdf.ri.common.views.annotations.ScalableTextField;
import org.icepdf.ri.common.views.annotations.SpellCheckLoader;

public class TextWidgetComponent
extends AbstractAnnotationComponent<TextWidgetAnnotation>
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(TextWidgetComponent.class.toString());
    private boolean textContentChange;
    private JTextComponent textWidgetComponent;

    public TextWidgetComponent(TextWidgetAnnotation textWidgetAnnotation, DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(textWidgetAnnotation, documentViewController, abstractPageViewComponent);
        Serializable serializable;
        if (!textWidgetAnnotation.allowScreenOrPrintRenderingOrInteraction()) {
            return;
        }
        this.setFocusable(true);
        this.isRollover = false;
        this.isShowInvisibleBorder = true;
        this.isResizable = true;
        this.isMovable = true;
        if (!textWidgetAnnotation.allowScreenOrPrintRenderingOrInteraction()) {
            this.isEditable = false;
            this.isRollover = false;
            this.isMovable = false;
            this.isResizable = false;
            this.isShowInvisibleBorder = false;
        }
        TextFieldDictionary textFieldDictionary = textWidgetAnnotation.getFieldDictionary();
        TextFieldDictionary.TextFieldType textFieldType = textFieldDictionary.getTextFieldType();
        DocumentViewModel documentViewModel = documentViewController.getDocumentViewModel();
        if (textFieldType == TextFieldDictionary.TextFieldType.TEXT_INPUT) {
            this.textWidgetComponent = new ScalableTextField(documentViewModel);
            serializable = textFieldDictionary.getQuadding();
            if (serializable == VariableTextFieldDictionary.Quadding.CENTERED) {
                ((ScalableTextField)this.textWidgetComponent).setHorizontalAlignment(0);
            } else if (serializable == VariableTextFieldDictionary.Quadding.RIGHT_JUSTIFIED) {
                ((ScalableTextField)this.textWidgetComponent).setHorizontalAlignment(4);
            }
            SpellCheckLoader.addSpellChecker(this.textWidgetComponent);
        } else if (textFieldType == TextFieldDictionary.TextFieldType.TEXT_AREA) {
            serializable = new ScalableTextArea(documentViewModel);
            this.textWidgetComponent = serializable;
            serializable.setLineWrap(false);
            SpellCheckLoader.addSpellChecker(this.textWidgetComponent);
        } else if (textFieldType == TextFieldDictionary.TextFieldType.TEXT_PASSWORD) {
            this.textWidgetComponent = new ScalablePasswordField(documentViewModel);
        }
        if (this.textWidgetComponent == null) {
            logger.warning("Could not valid text widget component of type: " + String.valueOf(textFieldType));
            return;
        }
        if (textWidgetAnnotation.getFieldDictionary().getMaxLength() > 0) {
            this.textWidgetComponent.setDocument(new JTextFieldLimit(textWidgetAnnotation.getFieldDictionary().getMaxLength()));
        }
        this.textWidgetComponent.setFont(new Font("Helvetica", 0, 10));
        this.textWidgetComponent.setMargin(new Insets(0, 0, 0, 0));
        this.textWidgetComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                TextWidgetComponent.this.textContentChange = true;
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                TextWidgetComponent.this.textContentChange = true;
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                TextWidgetComponent.this.textContentChange = true;
            }
        });
        this.textWidgetComponent.setEditable(false);
        this.textWidgetComponent.setBorder(BorderFactory.createEtchedBorder(1));
        serializable = new GridLayout(1, 1, 0, 0);
        this.setLayout((LayoutManager)((Object)serializable));
        this.add(this.textWidgetComponent);
        if (SystemProperties.INTERACTIVE_ANNOTATIONS && textWidgetAnnotation.allowScreenOrPrintRenderingOrInteraction()) {
            this.textWidgetComponent.setFocusable(true);
            this.textWidgetComponent.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    super.focusGained(focusEvent);
                    if (TextWidgetComponent.this.textWidgetComponent.getText().length() > 0) {
                        TextWidgetComponent.this.textWidgetComponent.setSelectionStart(0);
                        TextWidgetComponent.this.textWidgetComponent.setSelectionEnd(TextWidgetComponent.this.textWidgetComponent.getText().length());
                    }
                }
            });
        } else {
            this.textWidgetComponent.setFocusable(false);
        }
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.textWidgetComponent.setOpaque(false);
        this.assignTextValue();
        this.textWidgetComponent.addKeyListener(new TabKeyListener());
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addPropertyChangeListener(this);
        ((TextWidgetAnnotation)this.annotation).addPropertyChangeListener((PropertyChangeListener)this);
        this.revalidate();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        this.documentViewController.assignSelectedAnnotation(this);
        this.textWidgetComponent.requestFocus();
    }

    private void assignTextValue() {
        String string = (String)((TextWidgetAnnotation)this.annotation).getFieldDictionary().getFieldValue();
        if ((string == null || string.equals("")) && ((TextWidgetAnnotation)this.annotation).getFieldDictionary().getParent() != null) {
            string = (String)((TextWidgetAnnotation)this.annotation).getFieldDictionary().getParent().getFieldValue();
        }
        if (string != null && this.textWidgetComponent != null) {
            string = string.replace('\r', '\n');
            this.textWidgetComponent.setText(string);
        } else {
            Appearance appearance = (Appearance)((TextWidgetAnnotation)this.annotation).getAppearances().get(TextWidgetAnnotation.APPEARANCE_STREAM_NORMAL_KEY);
            AppearanceState appearanceState = appearance.getSelectedAppearanceState();
            if (appearanceState.getShapes() != null && appearanceState.getShapes().getPageText() != null) {
                this.textWidgetComponent.setText(this.pageLinesToString(appearanceState.getShapes().getPageText().getPageLines()));
            }
        }
    }

    public void setAppearanceStream() {
        this.assignTextValue();
        this.textWidgetComponent.setOpaque(false);
        ((TextWidgetAnnotation)this.annotation).getFieldDictionary().setFieldValue((Object)this.textWidgetComponent.getText(), ((TextWidgetAnnotation)this.annotation).getPObjectReference());
        this.textWidgetComponent.revalidate();
    }

    @Override
    public void dispose() {
        super.dispose();
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        ScalableField scalableField;
        boolean bl;
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        Object object2 = propertyChangeEvent.getOldValue();
        boolean bl2 = bl = !((TextWidgetAnnotation)this.annotation).getFieldDictionary().isReadOnly();
        if ("valueFieldReset".equals(string)) {
            this.assignTextValue();
            this.resetAppearanceShapes();
        } else if ("focusOwner".equals(string) && object2 instanceof ScalableField) {
            ScalableField scalableField2 = (ScalableField)object2;
            if (scalableField2.equals(this.textWidgetComponent)) {
                scalableField2.setEditable(false);
                if (this.textContentChange && bl) {
                    this.textContentChange = false;
                    TextFieldDictionary textFieldDictionary = ((TextWidgetAnnotation)this.annotation).getFieldDictionary();
                    textFieldDictionary.setFieldValue((Object)this.textWidgetComponent.getText(), ((TextWidgetAnnotation)this.annotation).getPObjectReference());
                    this.resetAppearanceShapes();
                }
                scalableField2.setActive(false);
            }
        } else if ("focusOwner".equals(string) && object instanceof ScalableField && (scalableField = (ScalableField)object).equals(this.textWidgetComponent) && bl) {
            scalableField.setEditable(true);
            scalableField.setActive(true);
        }
        this.getParent().validate();
        this.getParent().repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.isShowInvisibleBorder = false;
    }

    @Override
    public void resetAppearanceShapes() {
        this.setAppearanceStream();
        ((TextWidgetAnnotation)this.annotation).resetAppearanceStream(this.getToPageSpaceTransform());
    }

    @Override
    public void validate() {
        if (this.textWidgetComponent != null) {
            TextFieldDictionary textFieldDictionary = ((TextWidgetAnnotation)this.annotation).getFieldDictionary();
            if (((TextWidgetAnnotation)this.annotation).getFieldDictionary().getDefaultAppearance() == null) {
                Appearance appearance = (Appearance)((TextWidgetAnnotation)this.annotation).getAppearances().get(((TextWidgetAnnotation)this.annotation).getCurrentAppearance());
                AppearanceState appearanceState = appearance.getSelectedAppearanceState();
                Resources resources = appearanceState.getResources();
                String string = appearanceState.getOriginalContentStream();
                ((TextWidgetAnnotation)this.annotation).generateDefaultAppearance(string, resources, (VariableTextFieldDictionary)textFieldDictionary);
            }
            this.textWidgetComponent.setFont(new Font(textFieldDictionary.getFontName().toString(), 0, (int)(textFieldDictionary.getSize() * this.documentViewController.getDocumentViewModel().getViewZoom())));
        }
        super.validate();
    }

    @Override
    public boolean isActive() {
        return this.textWidgetComponent != null && ((ScalableField)((Object)this.textWidgetComponent)).isActive();
    }

    public void setActive(boolean bl) {
        if (this.textWidgetComponent != null) {
            ((ScalableField)((Object)this.textWidgetComponent)).setActive(bl);
        }
    }

    public void setEditable(boolean bl) {
        if (this.textWidgetComponent != null) {
            this.textWidgetComponent.setEditable(bl);
        }
    }

    @Override
    public String toString() {
        if (((TextWidgetAnnotation)this.annotation).getEntries() != null) {
            return ((TextWidgetAnnotation)this.annotation).getEntries().toString();
        }
        return super.toString();
    }

    private String pageLinesToString(ArrayList<LineText> arrayList) {
        if (arrayList != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (LineText lineText : arrayList) {
                for (WordText wordText : lineText.getWords()) {
                    stringBuilder.append(wordText.toString()).append(" ");
                }
            }
            return stringBuilder.toString();
        }
        return "";
    }

    private static class JTextFieldLimit
    extends PlainDocument {
        private final int limit;

        JTextFieldLimit(int n) {
            this.limit = n;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            if (this.getLength() + string.length() <= this.limit) {
                super.insertString(n, string, attributeSet);
            }
            if (this.getLength() == this.limit) {
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                keyboardFocusManager.focusNextComponent();
            }
        }
    }

    private static class TabKeyListener
    extends KeyAdapter {
        private TabKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 9) {
                keyEvent.consume();
                if (keyEvent.isShiftDown()) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                } else {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
            }
        }
    }
}

