/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations.acroform;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.icepdf.core.pobjects.acroform.SignatureFieldDictionary;
import org.icepdf.core.pobjects.acroform.SignatureHandler;
import org.icepdf.core.pobjects.acroform.signature.SignatureValidator;
import org.icepdf.core.pobjects.acroform.signature.exceptions.SignatureIntegrityException;
import org.icepdf.core.pobjects.annotations.SignatureWidgetAnnotation;
import org.icepdf.core.util.Library;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.signatures.CertificatePropertiesDialog;
import org.icepdf.ri.common.views.annotations.signatures.SignaturePropertiesDialog;
import org.icepdf.ri.common.views.annotations.signing.SignatureCreationDialog;

public class SignatureComponent
extends AbstractAnnotationComponent<SignatureWidgetAnnotation> {
    private static final Logger logger = Logger.getLogger(SignatureComponent.class.toString());
    protected final JMenuItem validationMenu;
    protected final JMenuItem signaturePropertiesMenu;
    protected final JMenuItem addSignatureMenu;
    protected final JMenuItem deleteSignatureMenu;
    protected final Controller controller;

    public SignatureComponent(SignatureWidgetAnnotation signatureWidgetAnnotation, DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(signatureWidgetAnnotation, documentViewController, abstractPageViewComponent);
        this.controller = documentViewController.getParentController();
        this.isShowInvisibleBorder = true;
        this.isResizable = true;
        this.isMovable = true;
        if (!signatureWidgetAnnotation.allowScreenOrPrintRenderingOrInteraction()) {
            this.isEditable = false;
            this.isRollover = false;
            this.isMovable = false;
            this.isResizable = false;
            this.isShowInvisibleBorder = false;
        }
        this.contextMenu = new JPopupMenu();
        this.validationMenu = new JMenuItem(this.messageBundle.getString("viewer.annotation.signature.menu.showCertificates.label"));
        this.validationMenu.addActionListener(new CertificatePropertiesActionListener());
        this.signaturePropertiesMenu = new JMenuItem(this.messageBundle.getString("viewer.annotation.signature.menu.signatureProperties.label"));
        this.signaturePropertiesMenu.addActionListener(new SignerPropertiesActionListener());
        this.addSignatureMenu = new JMenuItem(this.messageBundle.getString("viewer.annotation.signature.menu.addSignature.label"));
        this.addSignatureMenu.addActionListener(new NewSignatureActionListener(this));
        this.deleteSignatureMenu = new JMenuItem(this.messageBundle.getString("viewer.annotation.signature.menu.deleteSignature.label"));
        this.deleteSignatureMenu.addActionListener(new DeleteSignatureActionListener(this));
        this.updateContextMenu();
    }

    protected void updateContextMenu() {
        SignatureFieldDictionary signatureFieldDictionary = ((SignatureWidgetAnnotation)this.annotation).getFieldDictionary();
        if (signatureFieldDictionary != null) {
            SignatureValidator signatureValidator = ((SignatureWidgetAnnotation)this.annotation).getSignatureValidator();
            this.contextMenu.removeAll();
            if (signatureValidator != null) {
                this.contextMenu.add(this.validationMenu);
                this.contextMenu.add(this.signaturePropertiesMenu);
            } else if (((SignatureWidgetAnnotation)this.annotation).hasSignatureDictionary()) {
                this.contextMenu.add(this.deleteSignatureMenu);
            } else {
                this.contextMenu.add(this.addSignatureMenu);
                this.contextMenu.add(this.deleteSignatureMenu);
            }
        }
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public void resetAppearanceShapes() {
    }

    @Override
    public void paintComponent(Graphics graphics) {
    }

    protected void showSignatureWidgetPropertiesDialog() {
        SignatureValidator signatureValidator;
        SignatureFieldDictionary signatureFieldDictionary = ((SignatureWidgetAnnotation)this.annotation).getFieldDictionary();
        if (signatureFieldDictionary != null && (signatureValidator = ((SignatureWidgetAnnotation)this.annotation).getSignatureValidator()) != null) {
            try {
                signatureValidator.validate();
                new SignaturePropertiesDialog(this.controller.getViewerFrame(), this.messageBundle, (SignatureWidgetAnnotation)this.annotation).setVisible(true);
            }
            catch (SignatureIntegrityException signatureIntegrityException) {
                logger.fine("Error validating annotation " + ((SignatureWidgetAnnotation)this.annotation).toString());
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        if (mouseEvent.getClickCount() == 2) {
            this.showSignatureWidgetPropertiesDialog();
        } else if (mouseEvent.getButton() == 3 || mouseEvent.getButton() == 2) {
            this.updateContextMenu();
            this.contextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private SignatureWidgetAnnotation getSignatureWidgetAnnotation() {
        SignatureWidgetAnnotation signatureWidgetAnnotation = null;
        if (this.annotation instanceof SignatureWidgetAnnotation) {
            signatureWidgetAnnotation = (SignatureWidgetAnnotation)this.annotation;
        } else {
            try {
                signatureWidgetAnnotation = new SignatureWidgetAnnotation(null);
                signatureWidgetAnnotation.init();
                this.annotation = signatureWidgetAnnotation;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                logger.fine("Signature component annotation instance creation was interrupted");
            }
        }
        return signatureWidgetAnnotation;
    }

    class DeleteSignatureActionListener
    implements ActionListener {
        private final SignatureComponent signatureComponent;

        public DeleteSignatureActionListener(SignatureComponent signatureComponent2) {
            this.signatureComponent = signatureComponent2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SignatureComponent.this.controller.getDocumentViewController().deleteAnnotation(this.signatureComponent);
        }
    }

    class NewSignatureActionListener
    implements ActionListener {
        private final SignatureComponent signatureComponent;

        public NewSignatureActionListener(SignatureComponent signatureComponent2) {
            this.signatureComponent = signatureComponent2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                new SignatureCreationDialog(SignatureComponent.this.controller, SignatureComponent.this.messageBundle, this.signatureComponent).setVisible(true);
            }
            catch (IllegalStateException illegalStateException) {
                logger.log(Level.WARNING, "Keystore has not been configured, set in signature preferences panel", illegalStateException);
                JOptionPane.showMessageDialog(this.signatureComponent, SignatureComponent.this.messageBundle.getString("viewer.annotation.signature.keystore.failure.dialog.certify.error.msg"), SignatureComponent.this.messageBundle.getString("viewer.annotation.signature.keystore.failure.dialog.certify.error.title"), 2);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "failed to authenticate keystore", exception);
                JOptionPane.showMessageDialog(this.signatureComponent, SignatureComponent.this.messageBundle.getString("viewer.annotation.signature.authentication.failure.dialog.certify.error.msg"), SignatureComponent.this.messageBundle.getString("viewer.annotation.signature.authentication.failure.dialog.certify.error.title"), 2);
            }
        }
    }

    class SignerPropertiesActionListener
    implements ActionListener {
        SignerPropertiesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SignatureComponent.this.showSignatureWidgetPropertiesDialog();
        }
    }

    class CertificatePropertiesActionListener
    implements ActionListener {
        CertificatePropertiesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Library library;
            SignatureHandler signatureHandler;
            SignatureValidator signatureValidator;
            SignatureFieldDictionary signatureFieldDictionary = ((SignatureWidgetAnnotation)SignatureComponent.this.annotation).getFieldDictionary();
            if (signatureFieldDictionary != null && (signatureValidator = (signatureHandler = (library = ((SignatureWidgetAnnotation)SignatureComponent.this.annotation).getLibrary()).getSignatureHandler()).validateSignature(signatureFieldDictionary)) != null) {
                try {
                    signatureValidator.validate();
                    new CertificatePropertiesDialog(SignatureComponent.this.controller.getViewerFrame(), SignatureComponent.this.messageBundle, (Collection<? extends Certificate>)signatureValidator.getCertificateChain()).setVisible(true);
                }
                catch (SignatureIntegrityException signatureIntegrityException) {
                    logger.fine("Error validating annotation " + ((SignatureWidgetAnnotation)SignatureComponent.this.annotation).toString());
                }
            }
        }
    }
}

