/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations.acroform;

import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.acroform.ChoiceFieldDictionary;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.ChoiceWidgetAnnotation;
import org.icepdf.core.util.SystemProperties;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.ScalableField;
import org.icepdf.ri.common.views.annotations.ScalableJComboBox;
import org.icepdf.ri.common.views.annotations.acroform.AbstractChoiceComponent;

public class ChoiceComboComponent
extends AbstractChoiceComponent
implements FocusListener,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(ChoiceComboComponent.class.toString());
    private ScalableJComboBox comboBoxList;

    public ChoiceComboComponent(ChoiceWidgetAnnotation choiceWidgetAnnotation, DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(choiceWidgetAnnotation, documentViewController, abstractPageViewComponent);
        if (SystemProperties.INTERACTIVE_ANNOTATIONS && choiceWidgetAnnotation.allowScreenOrPrintRenderingOrInteraction()) {
            Object object2;
            DocumentViewModel documentViewModel = documentViewController.getDocumentViewModel();
            ChoiceFieldDictionary choiceFieldDictionary = choiceWidgetAnnotation.getFieldDictionary();
            ArrayList arrayList = choiceFieldDictionary.getOptions();
            if (arrayList == null) {
                arrayList = choiceWidgetAnnotation.generateChoices();
            }
            Vector<ChoiceFieldDictionary.ChoiceOption> vector = new Vector<ChoiceFieldDictionary.ChoiceOption>(arrayList.size());
            for (Object object2 : arrayList) {
                vector.addElement((ChoiceFieldDictionary.ChoiceOption)object2);
            }
            this.comboBoxList = new ScalableJComboBox(vector, documentViewModel);
            if (choiceFieldDictionary.getFieldValue() != null && choiceFieldDictionary.getIndexes() != null && choiceFieldDictionary.getIndexes().size() == 1) {
                this.comboBoxList.setSelectedIndex((Integer)choiceFieldDictionary.getIndexes().get(0));
            }
            this.comboBoxList.setOpaque(false);
            ChoiceWidgetAnnotation choiceWidgetAnnotation2 = choiceWidgetAnnotation;
            this.comboBoxList.addItemListener(arg_0 -> ChoiceComboComponent.lambda$new$0(choiceFieldDictionary, (Annotation)choiceWidgetAnnotation2, arg_0));
            object2 = "Helvetica";
            if (choiceFieldDictionary.getFontName() != null) {
                object2 = choiceFieldDictionary.getFontName().toString();
            }
            this.comboBoxList.setFont(new Font((String)object2, 0, (int)choiceFieldDictionary.getSize()));
            this.comboBoxList.setFocusable(true);
            GridLayout gridLayout = new GridLayout(1, 1, 0, 0);
            this.setLayout(gridLayout);
            this.add(this.comboBoxList);
            this.revalidate();
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        this.comboBoxList.requestFocus();
    }

    @Override
    public void validate() {
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        ChoiceFieldDictionary choiceFieldDictionary = ((ChoiceWidgetAnnotation)this.annotation).getFieldDictionary();
        String string = "Helvetica";
        if (choiceFieldDictionary.getFontName() != null) {
            string = choiceFieldDictionary.getFontName().toString();
        }
        this.comboBoxList.setFont(new Font(string, 0, (int)(choiceFieldDictionary.getSize() * documentViewModel.getViewZoom())));
        super.validate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        Object object2 = propertyChangeEvent.getOldValue();
        if ("focusOwner".equals(string) && object2 instanceof ScalableField) {
            ScalableField scalableField = (ScalableField)object2;
            if (scalableField.equals(this.comboBoxList)) {
                this.resetAppearanceShapes();
                this.getParent().validate();
                scalableField.setActive(false);
                this.getParent().validate();
                this.getParent().repaint();
            }
        } else if ("focusOwner".equals(string) && object instanceof ScalableField) {
            boolean bl;
            ScalableField scalableField = (ScalableField)object;
            boolean bl2 = bl = !((ChoiceWidgetAnnotation)this.annotation).getFieldDictionary().isReadOnly();
            if (bl && scalableField.equals(this.comboBoxList)) {
                scalableField.setActive(true);
                this.getParent().validate();
                this.getParent().repaint();
            }
        } else if ("valueFieldReset".equals(string)) {
            ChoiceFieldDictionary choiceFieldDictionary = ((ChoiceWidgetAnnotation)this.annotation).getFieldDictionary();
            choiceFieldDictionary.setFieldValue(choiceFieldDictionary.getFieldValue(), ((ChoiceWidgetAnnotation)this.annotation).getPObjectReference());
            this.resetAppearanceShapes();
        }
    }

    @Override
    public boolean isActive() {
        return this.comboBoxList != null && this.comboBoxList.isActive();
    }

    private static /* synthetic */ void lambda$new$0(ChoiceFieldDictionary choiceFieldDictionary, Annotation annotation, ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            ChoiceFieldDictionary.ChoiceOption choiceOption = (ChoiceFieldDictionary.ChoiceOption)itemEvent.getItem();
            choiceFieldDictionary.setFieldValue((Object)choiceOption.getValue(), annotation.getPObjectReference());
        }
    }
}

