/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Arrays;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.PageViewDecorator;
import org.icepdf.ri.common.views.TwoPageViewLayout;

public class TwoColumnPageViewLayout
extends TwoPageViewLayout {
    public TwoColumnPageViewLayout(int n, DocumentViewModel documentViewModel) {
        super(n, documentViewModel);
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getWidth() - (insets.left + insets.right);
        int n2 = container.getHeight() - (insets.top + insets.bottom);
        int n3 = 0;
        int n4 = 0;
        if (this.sizeUnknown) {
            this.setSizes(container);
        }
        PageViewDecorator[] pageViewDecoratorArray = (PageViewDecorator[])Arrays.stream(container.getComponents()).filter(component -> component instanceof PageViewDecorator && component.isVisible()).toArray(PageViewDecorator[]::new);
        int n5 = 0;
        Dimension dimension = new Dimension();
        for (PageViewDecorator pageViewDecorator : pageViewDecoratorArray) {
            int n6 = pageViewDecorator.getPageViewComponent().getPageIndex();
            Dimension dimension2 = pageViewDecorator.getPreferredSize();
            if (this.viewType == 1 && n6 == 0 && pageViewDecoratorArray.length != 2) {
                n3 = (n - this.preferredWidth) / 2 + dimension2.width + 2 + insets.left;
                if (this.preferredHeight < n2) {
                    n4 = (n2 - this.preferredHeight) / 2;
                }
                n3 += insets.left;
            } else if (n5 == 0) {
                n3 = (n - this.preferredWidth) / 2;
                n3 += insets.left;
                n4 += dimension.height + 2;
                if (this.preferredHeight < n2) {
                    n4 = (n2 - this.preferredHeight) / 2;
                    n4 += 2;
                }
                ++n5;
            } else {
                n5 = 0;
                n3 += dimension.width + 2;
            }
            dimension = dimension2;
            pageViewDecorator.setBounds(n3, n4, dimension2.width, dimension2.height);
            this.updatePopupAnnotationComponents(pageViewDecorator);
        }
    }

    @Override
    protected void setSizes(Container container) {
        this.preferredWidth = 0;
        this.preferredHeight = 0;
        this.minWidth = 0;
        this.minHeight = 0;
        PageViewDecorator[] pageViewDecoratorArray = (PageViewDecorator[])Arrays.stream(container.getComponents()).filter(component -> component instanceof PageViewDecorator && component.isVisible()).toArray(PageViewDecorator[]::new);
        int n = pageViewDecoratorArray.length;
        for (int i = 0; i < n; i += 2) {
            PageViewDecorator pageViewDecorator = pageViewDecoratorArray[i];
            Dimension dimension = ((Component)pageViewDecorator).getPreferredSize();
            this.preferredWidth = Math.max(dimension.width * 2 + 2, this.preferredWidth);
            this.preferredHeight += dimension.height + 2;
            this.minWidth = Math.max(((Component)pageViewDecorator).getMinimumSize().width * 2, this.minWidth);
            this.minHeight += this.preferredHeight;
        }
        if (pageViewDecoratorArray.length > 2 && pageViewDecoratorArray.length % 2 == 0) {
            this.preferredHeight += pageViewDecoratorArray[0].getPreferredSize().height + 2;
            this.minHeight += this.preferredHeight;
        }
    }
}

