/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.signatures;

import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.acroform.SignatureDictionary;
import org.icepdf.core.pobjects.acroform.SignatureFieldDictionary;
import org.icepdf.core.pobjects.acroform.signature.SignatureValidator;
import org.icepdf.core.pobjects.acroform.signature.exceptions.SignatureIntegrityException;
import org.icepdf.core.pobjects.acroform.signature.utils.SignatureUtilities;
import org.icepdf.core.pobjects.annotations.SignatureWidgetAnnotation;
import org.icepdf.ri.common.utility.signatures.SigPropertyTreeNode;
import org.icepdf.ri.common.utility.signatures.SignatureCertTreeNode;
import org.icepdf.ri.images.IconPack;
import org.icepdf.ri.images.Images;

public class SignatureTreeNode
extends DefaultMutableTreeNode {
    private static final Logger logger = Logger.getLogger(SignatureTreeNode.class.toString());
    private final ResourceBundle messageBundle;
    private final SignatureWidgetAnnotation signatureWidgetAnnotation;
    private SignatureValidator signatureValidator;
    private boolean verifyingSignature;
    private String location = null;
    private String reason = null;
    private String commonName = null;
    private String emailAddress = null;

    public SignatureTreeNode(SignatureWidgetAnnotation signatureWidgetAnnotation, ResourceBundle resourceBundle) {
        this.signatureWidgetAnnotation = signatureWidgetAnnotation;
        this.messageBundle = resourceBundle;
        try {
            this.validateSignatureNode();
        }
        catch (SignatureIntegrityException signatureIntegrityException) {
            logger.warning("There was an issue creating a node for the signature: " + signatureWidgetAnnotation.toString());
            MessageFormat messageFormat = new MessageFormat(resourceBundle.getString("viewer.utilityPane.signatures.tab.certTree.error.label"));
            this.setUserObject(messageFormat.format(new Object[]{this.commonName != null ? this.commonName + " " : " ", this.emailAddress != null ? "<" + this.emailAddress + ">" : ""}));
        }
    }

    public void validateSignatureNode() throws SignatureIntegrityException {
        SignatureFieldDictionary signatureFieldDictionary = this.signatureWidgetAnnotation.getFieldDictionary();
        SignatureDictionary signatureDictionary = this.signatureWidgetAnnotation.getSignatureDictionary();
        if (signatureFieldDictionary != null) {
            String string = signatureDictionary.getName();
            this.location = signatureDictionary.getLocation();
            this.reason = signatureDictionary.getReason();
            String string2 = signatureDictionary.getContactInfo();
            String string3 = signatureDictionary.getDate();
            this.signatureValidator = this.signatureWidgetAnnotation.getSignatureValidator();
            X509Certificate x509Certificate = this.signatureValidator.getSignerCertificate();
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            X500Name x500Name = new X500Name(x500Principal.getName());
            if (x500Name.getRDNs() != null) {
                this.commonName = SignatureUtilities.parseRelativeDistinguishedName((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.CN);
                String string4 = SignatureUtilities.parseRelativeDistinguishedName((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.O);
                this.emailAddress = SignatureUtilities.parseRelativeDistinguishedName((X500Name)x500Name, (ASN1ObjectIdentifier)BCStyle.EmailAddress);
            }
            this.setVerifyingSignature(true);
            this.signatureValidator.validate();
            this.setVerifyingSignature(true);
        }
    }

    public synchronized void refreshSignerNode() {
        if (this.isVerifyingSignature()) {
            MessageFormat messageFormat = new MessageFormat(this.messageBundle.getString("viewer.utilityPane.signatures.tab.certTree.rootSigned.label"));
            this.setUserObject(messageFormat.format(new Object[]{this.commonName != null ? this.commonName + " " : " ", this.emailAddress != null ? "<" + this.emailAddress + ">" : ""}));
            this.removeAllChildren();
            this.buildSignatureValidity(this);
            this.buildSignatureDetails(this);
            this.buildVerifiedDateAndFieldLink(this);
        } else {
            MessageFormat messageFormat = new MessageFormat(this.messageBundle.getString("viewer.utilityPane.signatures.tab.certTree.rootValidating.label"));
            this.setUserObject(messageFormat.format(new Object[]{this.commonName != null ? this.commonName + " " : " ", this.emailAddress != null ? "<" + this.emailAddress + ">" : ""}));
        }
    }

    protected Icon getRootNodeValidityIcon() {
        if (!this.signatureValidator.isSignedDataModified() && this.signatureValidator.isCertificateChainTrusted() && this.signatureValidator.isSignaturesCoverDocumentLength()) {
            return Images.getSingleIcon("signature_valid", IconPack.Variant.NONE, Images.IconSize.MINI);
        }
        if (!this.signatureValidator.isSignedDataModified() && this.signatureValidator.isSignaturesCoverDocumentLength()) {
            return Images.getSingleIcon("signature_caution", IconPack.Variant.NONE, Images.IconSize.MINI);
        }
        return Images.getSingleIcon("signature_invalid", IconPack.Variant.NONE, Images.IconSize.MINI);
    }

    private void buildSignatureValidity(DefaultMutableTreeNode defaultMutableTreeNode) {
        String string = "viewer.utilityPane.signatures.tab.certTree.cert.invalid.label";
        if (!this.signatureValidator.isSignedDataModified() && this.signatureValidator.isCertificateChainTrusted()) {
            string = "viewer.utilityPane.signatures.tab.certTree.cert.unknown.label";
        } else if (!this.signatureValidator.isSignedDataModified() && !this.signatureValidator.isCertificateChainTrusted()) {
            string = "viewer.utilityPane.signatures.tab.certTree.cert.valid.label";
        }
        SigPropertyTreeNode sigPropertyTreeNode = new SigPropertyTreeNode(this.messageBundle.getString(string));
        String string2 = "viewer.utilityPane.signatures.tab.certTree.doc.modified.label";
        if (!this.signatureValidator.isSignedDataModified() && !this.signatureValidator.isDocumentDataModified()) {
            string2 = "viewer.utilityPane.signatures.tab.certTree.doc.unmodified.label";
        } else if (!this.signatureValidator.isSignedDataModified() && this.signatureValidator.isDocumentDataModified() && this.signatureValidator.isSignaturesCoverDocumentLength()) {
            string2 = "viewer.utilityPane.signatures.tab.certTree.doc.modified.label";
        } else if (!this.signatureValidator.isSignaturesCoverDocumentLength()) {
            string2 = "viewer.utilityPane.signatures.tab.certTree.doc.major.label";
        }
        sigPropertyTreeNode.add(new SigPropertyTreeNode(this.messageBundle.getString(string2)));
        String string3 = "viewer.utilityPane.signatures.tab.certTree.signature.identity.unknown.label";
        if (this.signatureValidator.isCertificateChainTrusted()) {
            string3 = this.signatureValidator.isRevocation() ? "viewer.utilityPane.signatures.tab.certTree.signature.identity.unchecked.label" : "viewer.utilityPane.signatures.tab.certTree.signature.identity.valid.label";
        }
        sigPropertyTreeNode.add(new SigPropertyTreeNode(this.messageBundle.getString(string3)));
        String string4 = "viewer.utilityPane.signatures.tab.certTree.signature.time.local.label";
        if (this.signatureValidator.isEmbeddedTimeStamp()) {
            string4 = "viewer.utilityPane.signatures.tab.certTree.signature.time.embedded.label";
        }
        sigPropertyTreeNode.add(new SigPropertyTreeNode(this.messageBundle.getString(string4)));
        defaultMutableTreeNode.add(sigPropertyTreeNode);
    }

    private void buildSignatureDetails(DefaultMutableTreeNode defaultMutableTreeNode) {
        MessageFormat messageFormat;
        SigPropertyTreeNode sigPropertyTreeNode = new SigPropertyTreeNode(this.messageBundle.getString("viewer.utilityPane.signatures.tab.certTree.signature.details.label"));
        if (this.reason != null && this.reason.length() > 0) {
            messageFormat = new MessageFormat(this.messageBundle.getString("viewer.utilityPane.signatures.tab.certTree.signature.details.reason.label"));
            sigPropertyTreeNode.add(new SigPropertyTreeNode(messageFormat.format(new Object[]{this.reason})));
        }
        if (this.location != null && this.location.length() > 0) {
            messageFormat = new MessageFormat(this.messageBundle.getString("viewer.utilityPane.signatures.tab.certTree.signature.details.location.label"));
            sigPropertyTreeNode.add(new SigPropertyTreeNode(messageFormat.format(new Object[]{this.location})));
        }
        sigPropertyTreeNode.add(new SignatureCertTreeNode(this.messageBundle.getString("viewer.utilityPane.signatures.tab.certTree.signature.details.full.label"), this.signatureValidator.getCertificateChain(), this.getRootNodeValidityIcon()));
        defaultMutableTreeNode.add(sigPropertyTreeNode);
    }

    private void buildVerifiedDateAndFieldLink(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.signatureValidator != null && this.signatureValidator.getLastValidated() != null) {
            MessageFormat messageFormat = new MessageFormat(this.messageBundle.getString("viewer.utilityPane.signatures.tab.certTree.signature.lastChecked.label"));
            SigPropertyTreeNode sigPropertyTreeNode = new SigPropertyTreeNode(messageFormat.format(new Object[]{new PDate(this.signatureWidgetAnnotation.getLibrary().getSecurityManager(), PDate.formatDateTime((Date)this.signatureValidator.getLastValidated())).toString()}));
            sigPropertyTreeNode.setAllowsChildren(false);
            defaultMutableTreeNode.add(sigPropertyTreeNode);
        }
    }

    public synchronized boolean isVerifyingSignature() {
        return this.verifyingSignature;
    }

    public void setVerifyingSignature(boolean bl) {
        this.verifyingSignature = bl;
    }

    public SignatureWidgetAnnotation getOutlineItem() {
        return this.signatureWidgetAnnotation;
    }
}

