/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.outline;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.icepdf.core.pobjects.Destination;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.OutlineItem;
import org.icepdf.core.pobjects.Outlines;
import org.icepdf.core.pobjects.actions.Action;
import org.icepdf.core.pobjects.actions.URIAction;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.utility.outline.OutlineItemTreeNode;
import org.icepdf.ri.common.utility.outline.OutlinesPopupMenu;
import org.icepdf.ri.common.utility.outline.TreeTransferHandler;
import org.icepdf.ri.util.BareBonesBrowserLaunch;

public class OutlinesController
extends MouseAdapter
implements TreeModelListener,
TreeSelectionListener,
TreeExpansionListener {
    private final ResourceBundle messageBundle;
    private final SwingController controller;
    private final JTree outlinesTree;
    private boolean editable = true;
    private static boolean outlineEditingEnabled = Defs.booleanProperty((String)"org.icepdf.viewer.outlineEdit.enabled", (boolean)false);

    public OutlinesController(SwingController swingController, JTree jTree) {
        this.controller = swingController;
        this.outlinesTree = jTree;
        this.messageBundle = this.controller.getMessageBundle();
        jTree.addMouseListener(this);
        jTree.addTreeSelectionListener(this);
        jTree.addTreeExpansionListener(this);
    }

    public void insertNewOutline() throws InterruptedException {
        Document document = this.controller.getDocument();
        OutlineItem outlineItem = Outlines.createNewOutlineItem((Library)document.getCatalog().getLibrary());
        outlineItem.setTitle(this.messageBundle.getString("viewer.utilityPane.outline.contextMenu.new.label"));
        document.getCatalog().createOutlines(outlineItem);
    }

    public void updateOutlineItemState(OutlineItemTreeNode outlineItemTreeNode) {
        if (this.editable) {
            this.updateParentCount(outlineItemTreeNode);
            this.updateParentFirstAndLast(outlineItemTreeNode);
            this.updateChildNextAndPrevious(outlineItemTreeNode);
        }
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        this.outlinesTree.setEditable(bl);
        if (bl) {
            this.outlinesTree.setTransferHandler(new TreeTransferHandler());
        } else {
            this.outlinesTree.setTransferHandler(null);
        }
    }

    public static boolean isOutlineEditingEnabled() {
        return outlineEditingEnabled;
    }

    private void updateParentCount(OutlineItemTreeNode outlineItemTreeNode) {
        int n = outlineItemTreeNode.getChildCount();
        OutlineItem outlineItem = outlineItemTreeNode.getOutlineItem();
        outlineItem.setCount(n);
    }

    private void updateParentFirstAndLast(OutlineItemTreeNode outlineItemTreeNode) {
        int n = outlineItemTreeNode.getChildCount();
        if (n > 0) {
            OutlineItemTreeNode outlineItemTreeNode2 = (OutlineItemTreeNode)outlineItemTreeNode.getChildAt(0);
            OutlineItemTreeNode outlineItemTreeNode3 = (OutlineItemTreeNode)outlineItemTreeNode.getChildAt(n - 1);
            OutlineItem outlineItem = outlineItemTreeNode.getOutlineItem();
            outlineItem.setFirst(outlineItemTreeNode2.getOutlineItem().getPObjectReference());
            outlineItem.setLast(outlineItemTreeNode3.getOutlineItem().getPObjectReference());
        }
    }

    private void updateChildNextAndPrevious(OutlineItemTreeNode outlineItemTreeNode) {
        int n = outlineItemTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            OutlineItemTreeNode outlineItemTreeNode2;
            OutlineItemTreeNode outlineItemTreeNode3 = (OutlineItemTreeNode)outlineItemTreeNode.getChildAt(i);
            OutlineItem outlineItem = outlineItemTreeNode3.getOutlineItem();
            if (i == 0) {
                outlineItem.setPrev(null);
            } else {
                outlineItemTreeNode2 = (OutlineItemTreeNode)outlineItemTreeNode.getChildAt(i - 1);
                outlineItem.setPrev(outlineItemTreeNode2.getOutlineItem().getPObjectReference());
            }
            if (i == n - 1) {
                outlineItem.setNext(null);
            } else {
                outlineItemTreeNode2 = (OutlineItemTreeNode)outlineItemTreeNode.getChildAt(i + 1);
                outlineItem.setNext(outlineItemTreeNode2.getOutlineItem().getPObjectReference());
            }
            outlineItem.setParent(outlineItemTreeNode.getOutlineItem().getPObjectReference());
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        int n2;
        int n3;
        TreePath treePath;
        if (this.editable && (mouseEvent.getButton() == 3 || mouseEvent.getButton() == 2) && (treePath = this.outlinesTree.getPathForRow(n3 = this.outlinesTree.getRowForLocation(n2 = mouseEvent.getX(), n = mouseEvent.getY()))) != null) {
            OutlineItemTreeNode outlineItemTreeNode = (OutlineItemTreeNode)treePath.getLastPathComponent();
            OutlinesPopupMenu outlinesPopupMenu = new OutlinesPopupMenu(this.controller, this.outlinesTree, outlineItemTreeNode);
            outlinesPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        if (this.editable) {
            TreePath treePath = treeExpansionEvent.getPath();
            OutlineItemTreeNode outlineItemTreeNode = (OutlineItemTreeNode)treePath.getLastPathComponent();
            OutlineItem outlineItem = outlineItemTreeNode.getOutlineItem();
            outlineItem.setCount(outlineItemTreeNode.getChildCount());
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        if (this.editable) {
            TreePath treePath = treeExpansionEvent.getPath();
            OutlineItemTreeNode outlineItemTreeNode = (OutlineItemTreeNode)treePath.getLastPathComponent();
            OutlineItem outlineItem = outlineItemTreeNode.getOutlineItem();
            outlineItem.setCount(-1);
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        TreePath treePath = treeModelEvent.getTreePath();
        OutlineItemTreeNode outlineItemTreeNode = (OutlineItemTreeNode)treePath.getLastPathComponent();
        this.updateOutlineItemState(outlineItemTreeNode);
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        TreePath treePath = treeModelEvent.getTreePath();
        OutlineItemTreeNode outlineItemTreeNode = (OutlineItemTreeNode)treePath.getLastPathComponent();
        this.updateOutlineItemState(outlineItemTreeNode);
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        Object[] objectArray;
        for (Object object : objectArray = treeModelEvent.getChildren()) {
            OutlineItemTreeNode outlineItemTreeNode = (OutlineItemTreeNode)object;
            OutlineItem outlineItem = outlineItemTreeNode.getOutlineItem();
            outlineItem.setTitle(outlineItemTreeNode.getUserObject().toString());
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
    }

    public void followOutlineItem(OutlineItemTreeNode outlineItemTreeNode) {
        OutlineItem outlineItem = outlineItemTreeNode.getOutlineItem();
        this.followOutlineItem(outlineItem);
    }

    public void dispose() {
        if (this.outlinesTree.getModel() != null) {
            this.outlinesTree.getModel().removeTreeModelListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void followOutlineItem(OutlineItem outlineItem) {
        if (outlineItem == null) {
            return;
        }
        int n = this.controller.getDocumentViewToolMode();
        try {
            Action action;
            this.outlinesTree.setCursor(Cursor.getPredefinedCursor(3));
            this.controller.setDisplayTool(51);
            Destination destination = outlineItem.getDest();
            if (destination == null && outlineItem.getAction() != null && (action = outlineItem.getAction()) instanceof URIAction) {
                BareBonesBrowserLaunch.openURL(((URIAction)action).getURI());
            }
            if (destination != null) {
                this.controller.getDocumentViewController().setDestinationTarget(destination);
            }
        }
        finally {
            this.controller.setDisplayTool(n);
            this.outlinesTree.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.outlinesTree == null) {
            return;
        }
        TreePath treePath = this.outlinesTree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        OutlineItemTreeNode outlineItemTreeNode = (OutlineItemTreeNode)treePath.getLastPathComponent();
        this.followOutlineItem(outlineItemTreeNode);
    }
}

