/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation.properties;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.annotations.TextMarkupAnnotation;
import org.icepdf.ri.common.utility.annotation.properties.AnnotationPanelAdapter;
import org.icepdf.ri.common.utility.annotation.properties.ValueLabelItem;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.widgets.RgbColorChooser;

public class TextMarkupAnnotationPanel
extends AnnotationPanelAdapter
implements ItemListener,
ActionListener,
ChangeListener {
    private static final int DEFAULT_TEXT_MARKUP_TYPE = 0;
    private static final Color DEFAULT_BORDER_COLOR = Color.BLACK;
    private static ValueLabelItem[] TEXT_MARKUP_TYPE_LIST;
    private JComboBox<ValueLabelItem> textMarkupTypes;
    private JButton colorButton;
    private JSlider transparencySlider;
    private TextMarkupAnnotation annotation;

    public TextMarkupAnnotationPanel(Controller controller) {
        super(controller);
        this.setLayout(new GridBagLayout());
        this.setFocusable(true);
        this.createGUI();
        this.setEnabled(false);
        this.revalidate();
    }

    @Override
    public void setAnnotationComponent(AnnotationComponent annotationComponent) {
        if (annotationComponent == null || annotationComponent.getAnnotation() == null) {
            this.setEnabled(false);
            return;
        }
        this.currentAnnotationComponent = annotationComponent;
        this.annotation = (TextMarkupAnnotation)this.currentAnnotationComponent.getAnnotation();
        this.applySelectedValue(this.textMarkupTypes, this.annotation.getSubType());
        this.setButtonBackgroundColor(this.colorButton, this.annotation.getColor());
        this.transparencySlider.setValue(Math.round(this.annotation.getOpacity() * 255.0f));
        this.safeEnable(this.textMarkupTypes, true);
        this.safeEnable(this.colorButton, true);
        this.safeEnable(this.transparencySlider, true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        ValueLabelItem valueLabelItem = (ValueLabelItem)itemEvent.getItem();
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getSource() == this.textMarkupTypes) {
                this.annotation.setSubtype((Name)valueLabelItem.getValue());
            }
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.resetAppearanceShapes();
            this.currentAnnotationComponent.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Color color;
        if (actionEvent.getSource() == this.colorButton && (color = RgbColorChooser.showDialog(this.colorButton, this.messageBundle.getString("viewer.utilityPane.annotation.textMarkup.colorChooserTitle"), this.colorButton.getBackground())) != null) {
            this.colorButton.setBackground(color);
            this.annotation.setColor(color);
            Name name = this.annotation.getSubType();
            String string = "application.viewer.preference.annotation.highlight.color";
            if (name.equals(TextMarkupAnnotation.SUBTYPE_UNDERLINE)) {
                string = "application.viewer.preference.annotation.underline.color";
            } else if (name.equals(TextMarkupAnnotation.SUBTYPE_STRIKE_OUT)) {
                string = "application.viewer.preference.annotation.strikeout.color";
            } else if (name.equals(TextMarkupAnnotation.SUBTYPE_SQUIGGLY)) {
                string = "application.viewer.preference.annotation.squiggly.color";
            }
            this.preferences.putInt(string, color.getRGB());
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.resetAppearanceShapes();
            this.currentAnnotationComponent.repaint();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Name name = this.annotation.getSubType();
        String string = "application.viewer.preference.annotation.highlight.opacity";
        if (name.equals(TextMarkupAnnotation.SUBTYPE_UNDERLINE)) {
            string = "application.viewer.preference.annotation.underline.opacity";
        } else if (name.equals(TextMarkupAnnotation.SUBTYPE_STRIKE_OUT)) {
            string = "application.viewer.preference.annotation.strikeout.opacity";
        } else if (name.equals(TextMarkupAnnotation.SUBTYPE_SQUIGGLY)) {
            string = "application.viewer.preference.annotation.squiggly.opacity";
        }
        this.alphaSliderChange(changeEvent, (MarkupAnnotation)this.annotation, string);
    }

    private void createGUI() {
        if (TEXT_MARKUP_TYPE_LIST == null) {
            TEXT_MARKUP_TYPE_LIST = new ValueLabelItem[]{new ValueLabelItem(TextMarkupAnnotation.SUBTYPE_HIGHLIGHT, "Highlight"), new ValueLabelItem(TextMarkupAnnotation.SUBTYPE_STRIKE_OUT, "Strikeout"), new ValueLabelItem(TextMarkupAnnotation.SUBTYPE_UNDERLINE, "Underline")};
        }
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(1, 2, 1, 2);
        this.setBorder(new TitledBorder(new EtchedBorder(1), this.messageBundle.getString("viewer.utilityPane.annotation.textMarkup.appearance.title"), 1, 0));
        this.textMarkupTypes = new JComboBox<ValueLabelItem>(TEXT_MARKUP_TYPE_LIST);
        this.textMarkupTypes.setSelectedIndex(0);
        this.textMarkupTypes.addItemListener(this);
        JLabel jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.textMarkup.highlightType"));
        this.addGB(this, jLabel, 0, 0, 1, 1);
        this.addGB(this, this.textMarkupTypes, 1, 0, 1, 1);
        this.colorButton = new JButton(" ");
        this.colorButton.addActionListener(this);
        this.colorButton.setOpaque(true);
        this.colorButton.setBackground(DEFAULT_BORDER_COLOR);
        jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.textMarkup.colorLabel"));
        this.addGB(this, jLabel, 0, 2, 1, 1);
        this.addGB(this, this.colorButton, 1, 2, 1, 1);
        this.transparencySlider = this.buildAlphaSlider();
        this.transparencySlider.setMajorTickSpacing(255);
        this.transparencySlider.setPaintLabels(true);
        this.transparencySlider.addChangeListener(this);
        jLabel = new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.textMarkup.transparencyLabel"));
        this.addGB(this, jLabel, 0, 3, 1, 1);
        this.addGB(this, this.transparencySlider, 1, 3, 1, 1);
        this.constraints.weighty = 1.0;
        this.addGB(this, new Label(" "), 0, 4, 1, 1);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.safeEnable(this.textMarkupTypes, bl);
        this.safeEnable(this.colorButton, bl);
        this.safeEnable(this.transparencySlider, bl);
    }

    protected boolean safeEnable(JComponent jComponent, boolean bl) {
        if (jComponent != null) {
            jComponent.setEnabled(bl);
            return true;
        }
        return false;
    }

    private void applySelectedValue(JComboBox jComboBox, Object object) {
        jComboBox.removeItemListener(this);
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            ValueLabelItem valueLabelItem = (ValueLabelItem)jComboBox.getItemAt(i);
            if (!valueLabelItem.getValue().equals(object)) continue;
            jComboBox.setSelectedIndex(i);
            break;
        }
        jComboBox.addItemListener(this);
    }
}

