/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.icepdf.ri.common.EscapeJDialog;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.utility.annotation.properties.ActionsPanel;
import org.icepdf.ri.common.utility.annotation.properties.AnnotationPanel;
import org.icepdf.ri.common.utility.annotation.properties.AnnotationPanelAdapter;
import org.icepdf.ri.common.utility.annotation.properties.AnnotationProperties;
import org.icepdf.ri.common.utility.annotation.properties.BorderPanel;
import org.icepdf.ri.common.utility.annotation.properties.CircleAnnotationPanel;
import org.icepdf.ri.common.utility.annotation.properties.FlagsPanel;
import org.icepdf.ri.common.utility.annotation.properties.FreeTextAnnotationPanel;
import org.icepdf.ri.common.utility.annotation.properties.InkAnnotationPanel;
import org.icepdf.ri.common.utility.annotation.properties.LineAnnotationPanel;
import org.icepdf.ri.common.utility.annotation.properties.SquareAnnotationPanel;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class AnnotationPropertiesDialog
extends EscapeJDialog
implements AnnotationProperties {
    private final GridBagConstraints constraints;
    private final JTabbedPane propertiesTabbedPane;
    private final Controller controller;
    private final ResourceBundle messageBundle;

    public AnnotationPropertiesDialog(Frame frame, SwingController swingController, ResourceBundle resourceBundle) {
        super(frame, true);
        this.controller = swingController;
        this.messageBundle = resourceBundle;
        this.setTitle(resourceBundle.getString("viewer.dialog.annotationProperties.tab.title"));
        JButton jButton = new JButton(resourceBundle.getString("viewer.button.ok.label"));
        jButton.setMnemonic(resourceBundle.getString("viewer.button.ok.mnemonic").charAt(0));
        jButton.addActionListener(actionEvent -> {
            if (actionEvent.getSource() == jButton) {
                this.setVisible(false);
                this.dispose();
            }
        });
        this.propertiesTabbedPane = new JTabbedPane();
        this.propertiesTabbedPane.setAlignmentY(0.0f);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.constraints.anchor = 11;
        this.addGB(jPanel, this.propertiesTabbedPane, 0, 0, 1, 1);
        this.constraints.fill = 0;
        this.addGB(jPanel, jButton, 0, 1, 1, 1);
        this.setLayout(new BorderLayout(15, 15));
        this.add((Component)jPanel, "North");
        this.setSize(375, 415);
        this.setLocationRelativeTo(frame);
    }

    @Override
    public void setAnnotationComponent(AnnotationComponent annotationComponent) {
        AnnotationPanelAdapter annotationPanelAdapter = AnnotationPanel.buildAnnotationPropertyPanel(annotationComponent, this.controller);
        if (annotationPanelAdapter != null) {
            annotationPanelAdapter.setAnnotationComponent(annotationComponent);
            annotationPanelAdapter.setEnabled(true);
            this.propertiesTabbedPane.addTab(this.messageBundle.getString("viewer.dialog.annotationProperties.tab.default.title"), annotationPanelAdapter);
        }
        ActionsPanel actionsPanel = new ActionsPanel(this.controller);
        BorderPanel borderPanel = new BorderPanel(this.controller);
        FlagsPanel flagsPanel = null;
        ViewerPropertiesManager viewerPropertiesManager = ViewerPropertiesManager.getInstance();
        if (viewerPropertiesManager == null || viewerPropertiesManager.checkAndStoreBooleanProperty("application.utilitypane.show.annotation.flags")) {
            flagsPanel = new FlagsPanel(this.controller);
        }
        if (!(annotationPanelAdapter instanceof LineAnnotationPanel || annotationPanelAdapter instanceof SquareAnnotationPanel || annotationPanelAdapter instanceof CircleAnnotationPanel || annotationPanelAdapter instanceof InkAnnotationPanel || annotationPanelAdapter instanceof FreeTextAnnotationPanel || annotationComponent instanceof PopupAnnotationComponent)) {
            borderPanel.setEnabled(true);
            borderPanel.setAnnotationComponent(annotationComponent);
            this.propertiesTabbedPane.addTab(this.messageBundle.getString("viewer.dialog.annotationProperties.tab.border.title"), borderPanel);
        }
        this.propertiesTabbedPane.addTab(this.messageBundle.getString("viewer.dialog.annotationProperties.tab.action.title"), actionsPanel);
        actionsPanel.setEnabled(true);
        actionsPanel.setAnnotationComponent(annotationComponent);
        if (flagsPanel != null) {
            flagsPanel.setEnabled(true);
            flagsPanel.setAnnotationComponent(annotationComponent);
            this.propertiesTabbedPane.addTab(this.messageBundle.getString("viewer.dialog.annotationProperties.tab.flags.title"), flagsPanel);
        }
        if (annotationComponent.getAnnotation().getFlagReadOnly()) {
            if (annotationPanelAdapter != null) {
                annotationPanelAdapter.setEnabled(false);
            }
            actionsPanel.setEnabled(false);
            borderPanel.setEnabled(false);
            if (flagsPanel != null) {
                flagsPanel.setEnabled(false);
            }
        }
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }
}

