/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import org.icepdf.core.pobjects.annotations.BorderStyle;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.ri.common.utility.annotation.properties.AnnotationProperties;
import org.icepdf.ri.common.utility.annotation.properties.ValueLabelItem;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.util.ViewerPropertiesManager;

public abstract class AnnotationPanelAdapter
extends JPanel
implements AnnotationProperties {
    protected GridBagConstraints constraints;
    protected AnnotationComponent currentAnnotationComponent;
    protected final DocumentViewController documentViewController;
    protected final Controller controller;
    protected final ResourceBundle messageBundle;
    protected static ValueLabelItem[] VISIBLE_TYPE_LIST;
    protected static ValueLabelItem[] LINE_THICKNESS_LIST;
    protected static ValueLabelItem[] LINE_STYLE_LIST;
    protected static final int TRANSPARENCY_MIN = 0;
    protected static final int TRANSPARENCY_MAX = 255;
    protected static final int TRANSPARENCY_INIT = 255;
    protected final Preferences preferences;

    protected AnnotationPanelAdapter(Controller controller) {
        this.setDoubleBuffered(true);
        this.controller = controller;
        this.documentViewController = controller.getDocumentViewController();
        this.messageBundle = controller.getMessageBundle();
        ViewerPropertiesManager viewerPropertiesManager = ViewerPropertiesManager.getInstance();
        this.preferences = viewerPropertiesManager.getPreferences();
        if (LINE_THICKNESS_LIST == null) {
            LINE_THICKNESS_LIST = new ValueLabelItem[]{new ValueLabelItem(Float.valueOf(1.0f), this.messageBundle.getString("viewer.common.number.one")), new ValueLabelItem(Float.valueOf(2.0f), this.messageBundle.getString("viewer.common.number.two")), new ValueLabelItem(Float.valueOf(3.0f), this.messageBundle.getString("viewer.common.number.three")), new ValueLabelItem(Float.valueOf(4.0f), this.messageBundle.getString("viewer.common.number.four")), new ValueLabelItem(Float.valueOf(5.0f), this.messageBundle.getString("viewer.common.number.five")), new ValueLabelItem(Float.valueOf(10.0f), this.messageBundle.getString("viewer.common.number.ten")), new ValueLabelItem(Float.valueOf(15.0f), this.messageBundle.getString("viewer.common.number.fifteen"))};
        }
        if (VISIBLE_TYPE_LIST == null) {
            VISIBLE_TYPE_LIST = new ValueLabelItem[]{new ValueLabelItem(true, this.messageBundle.getString("viewer.utilityPane.annotation.border.borderType.visibleRectangle")), new ValueLabelItem(false, this.messageBundle.getString("viewer.utilityPane.annotation.border.borderType.invisibleRectangle"))};
        }
        if (LINE_STYLE_LIST == null) {
            LINE_STYLE_LIST = new ValueLabelItem[]{new ValueLabelItem(BorderStyle.BORDER_STYLE_SOLID, this.messageBundle.getString("viewer.utilityPane.annotation.border.solid")), new ValueLabelItem(BorderStyle.BORDER_STYLE_DASHED, this.messageBundle.getString("viewer.utilityPane.annotation.border.dashed"))};
        }
    }

    protected void updateCurrentAnnotation() {
        this.documentViewController.updateAnnotation(this.currentAnnotationComponent);
    }

    protected JSlider buildAlphaSlider() {
        return new JSlider(0, 0, 255, 255);
    }

    protected void alphaSliderChange(ChangeEvent changeEvent, MarkupAnnotation markupAnnotation, String string) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        int n = jSlider.getValue();
        if (!jSlider.getValueIsAdjusting() && n != markupAnnotation.getOpacityNormalized()) {
            markupAnnotation.setOpacity(n);
            this.preferences.putInt(string, n);
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.resetAppearanceShapes();
            this.currentAnnotationComponent.repaint();
        }
    }

    protected void setButtonBackgroundColor(JButton jButton, Color color) {
        if (color != null) {
            if (color.getAlpha() < 255) {
                color = new Color(color.getRGB());
            }
            jButton.setBackground(color);
            jButton.setContentAreaFilled(false);
            jButton.setOpaque(true);
        }
    }

    protected void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }
}

