/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation.markup;

import java.awt.Color;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.SystemProperties;
import org.icepdf.ri.common.AbstractTask;
import org.icepdf.ri.common.utility.annotation.markup.MarkupAnnotationHandlerPanel;
import org.icepdf.ri.common.utility.annotation.markup.MarkupAnnotationPanel;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.PageComponentSelector;
import org.icepdf.ri.common.widgets.DragDropColorList;

public class FindMarkupAnnotationTask
extends AbstractTask<Void, Object> {
    private static final Logger logger = Logger.getLogger(FindMarkupAnnotationTask.class.toString());
    private static ArrayList<DragDropColorList.ColorLabel> colorLabels;
    private final MessageFormat loadingMessage;
    private final MessageFormat completeMessage;
    private final MessageFormat completeFilteredMessage;
    private final MessageFormat pageLabelFormat;
    private final MessageFormat authorLabelFormat;
    private final MessageFormat dateLabelFormat;
    private final MessageFormat colorLabelFormat;
    private Pattern searchPattern;
    private MarkupAnnotationPanel.SortColumn sortType;
    private MarkupAnnotationPanel.FilterSubTypeColumn filterType;
    private MarkupAnnotationPanel.FilterAuthorColumn filterAuthor;
    private MarkupAnnotationPanel.FilterVisibilityColumn filterVisibility;
    private Color filterColor;
    private boolean isRegex;
    private boolean isCaseSensitive;

    private FindMarkupAnnotationTask(MarkupAnnotationHandlerPanel markupAnnotationHandlerPanel, Controller controller, ResourceBundle resourceBundle) {
        super(controller, markupAnnotationHandlerPanel, resourceBundle);
        this.loadingMessage = new MessageFormat(resourceBundle.getString("viewer.utilityPane.markupAnnotation.view.loadingAnnotations.label"));
        this.completeMessage = new MessageFormat(resourceBundle.getString("viewer.utilityPane.markupAnnotation.view.loadingComplete.label"));
        this.completeFilteredMessage = new MessageFormat(resourceBundle.getString("viewer.utilityPane.markupAnnotation.view.summaryFiltered.label"));
        this.pageLabelFormat = new MessageFormat(resourceBundle.getString("viewer.utilityPane.markupAnnotation.view.tree.page.label"));
        this.authorLabelFormat = new MessageFormat(resourceBundle.getString("viewer.utilityPane.markupAnnotation.view.tree.author.label"));
        this.dateLabelFormat = new MessageFormat(resourceBundle.getString("viewer.utilityPane.markupAnnotation.view.tree.date.label"));
        this.colorLabelFormat = new MessageFormat(resourceBundle.getString("viewer.utilityPane.markupAnnotation.view.tree.color.label"));
    }

    private FindMarkupAnnotationTask(Builder builder) {
        this(builder.markupAnnotationHandlerPanel, builder.controller, builder.messageBundle);
        this.searchPattern = builder.searchPattern;
        this.sortType = builder.sortType;
        this.filterType = builder.filterType;
        this.filterAuthor = builder.filterAuthor;
        this.filterColor = builder.filterColor;
        this.filterVisibility = builder.filterVisibility;
        this.isRegex = builder.isRegex;
        this.isCaseSensitive = builder.isCaseSensitive;
        this.lengthOfTask = this.controller.getDocument().getNumberOfPages();
        this.workerPanel.startProgressControls(this.lengthOfTask);
    }

    @Override
    protected Void doInBackground() {
        colorLabels = DragDropColorList.retrieveColorLabels();
        int n = 0;
        int n2 = 0;
        try {
            Document document = this.controller.getDocument();
            if (document != null) {
                Library library = document.getCatalog().getLibrary();
                int n3 = document.getPageTree().getNumberOfPages();
                ArrayList<MarkupAnnotation> arrayList = new ArrayList<MarkupAnnotation>();
                block2: for (int i = 0; i < n3 && !this.isCancelled(); ++i) {
                    List list;
                    this.taskStatusMessage = this.loadingMessage.format(new Object[]{i + 1, n3});
                    this.taskProgress = i;
                    String string = SystemProperties.USER_NAME;
                    MarkupAnnotation markupAnnotation2 = document.getPageTree().getPage(i);
                    if (markupAnnotation2 == null || (list = markupAnnotation2.getAnnotationReferences()) == null || list.size() <= 0) continue;
                    for (Object e : list) {
                        Object object;
                        MarkupAnnotation markupAnnotation3;
                        if (this.isCancelled()) continue block2;
                        Object object2 = library.getObject(e);
                        if (!(object2 instanceof MarkupAnnotation) || (markupAnnotation3 = (MarkupAnnotation)object2).isDeleted()) continue;
                        ++n;
                        boolean bl = false;
                        if (this.filterAuthor == MarkupAnnotationPanel.FilterAuthorColumn.AUTHOR_OTHER) {
                            if (markupAnnotation3.getTitleText() == null || markupAnnotation3.getTitleText().equalsIgnoreCase(string)) {
                                bl = markupAnnotation3.getReplyingAnnotations(true).stream().noneMatch(markupAnnotation -> markupAnnotation.getTitleText() != null && !markupAnnotation.getTitleText().equalsIgnoreCase(string));
                            }
                        } else if (!(this.filterAuthor != MarkupAnnotationPanel.FilterAuthorColumn.AUTHOR_CURRENT || markupAnnotation3.getTitleText() != null && markupAnnotation3.getTitleText().equalsIgnoreCase(string))) {
                            bl = markupAnnotation3.getReplyingAnnotations(true).stream().noneMatch(markupAnnotation -> markupAnnotation.getTitleText() != null && markupAnnotation.getTitleText().equalsIgnoreCase(string));
                        }
                        if (this.filterColor != null && (markupAnnotation3.getColor() == null || markupAnnotation3.getColor().getRGB() != this.filterColor.getRGB())) {
                            bl = true;
                        }
                        if (this.filterType != MarkupAnnotationPanel.FilterSubTypeColumn.ALL) {
                            if (markupAnnotation3.getSubType() != null) {
                                object = markupAnnotation3.getSubType().toString();
                                if (!((String)object).equalsIgnoreCase(this.filterType.toString())) {
                                    bl = true;
                                }
                            } else {
                                bl = true;
                            }
                        }
                        if (SystemProperties.PRIVATE_PROPERTY_ENABLED && this.filterVisibility != MarkupAnnotationPanel.FilterVisibilityColumn.ALL && (markupAnnotation3.getFlagPrivateContents() && this.filterVisibility == MarkupAnnotationPanel.FilterVisibilityColumn.PUBLIC || !markupAnnotation3.getFlagPrivateContents() && this.filterVisibility == MarkupAnnotationPanel.FilterVisibilityColumn.PRIVATE)) {
                            bl = true;
                        }
                        if (this.isRegex && this.searchPattern != null) {
                            object = this.searchPattern.matcher(((MarkupAnnotation)object2).getContents());
                            bl = !((Matcher)object).find();
                        } else if (this.searchPattern != null) {
                            object = ((MarkupAnnotation)object2).getContents();
                            if (this.isCaseSensitive && object != null) {
                                bl = !((String)object).contains(this.searchPattern.pattern());
                            } else if (object != null) {
                                boolean bl2 = bl = !((String)object).toLowerCase().contains(this.searchPattern.pattern().toLowerCase());
                            }
                        }
                        if (bl) continue;
                        arrayList.add(markupAnnotation3);
                    }
                }
                arrayList.sort(new AnnotationComparator(this.sortType));
                n2 = arrayList.size();
                MarkupAnnotation markupAnnotation4 = null;
                for (MarkupAnnotation markupAnnotation2 : arrayList) {
                    if (markupAnnotation2.isInReplyTo()) continue;
                    if (this.isCancelled()) break;
                    this.checkGroupLabelChange(this.sortType, markupAnnotation4, markupAnnotation2);
                    markupAnnotation4 = markupAnnotation2;
                    this.publish(markupAnnotation2);
                }
            }
            this.taskStatusMessage = !this.filterAuthor.equals((Object)MarkupAnnotationPanel.FilterAuthorColumn.ALL) || !this.filterType.equals((Object)MarkupAnnotationPanel.FilterSubTypeColumn.ALL) || this.filterColor != null ? this.completeFilteredMessage.format(new Object[]{n2, n}) : this.completeMessage.format(new Object[]{n, n});
        }
        catch (Exception exception) {
            logger.log(Level.FINER, "Error loading annotations.", exception);
        }
        return null;
    }

    @Override
    protected void process(List<Object> list) {
        for (Object object : list) {
            if (object instanceof MarkupAnnotation) {
                ((MarkupAnnotationHandlerPanel)this.workerPanel).addAnnotation((Annotation)((MarkupAnnotation)object), this.searchPattern);
            } else if (object instanceof String) {
                ((MarkupAnnotationHandlerPanel)this.workerPanel).addPageGroup((String)object);
            }
            this.workerPanel.updateProgressControls(this.taskProgress);
            this.workerPanel.repaint();
        }
    }

    @Override
    protected void done() {
        this.workerPanel.endProgressControls();
        this.workerPanel.validate();
    }

    private void checkGroupLabelChange(MarkupAnnotationPanel.SortColumn sortColumn, MarkupAnnotation markupAnnotation, MarkupAnnotation markupAnnotation2) {
        String string = null;
        if (MarkupAnnotationPanel.SortColumn.PAGE.equals((Object)sortColumn)) {
            if (markupAnnotation == null || markupAnnotation.getPageIndex() != markupAnnotation2.getPageIndex()) {
                if (markupAnnotation2.getPageIndex() < 0) {
                    PageComponentSelector.AssignAnnotationPage(this.controller, (Annotation)markupAnnotation2);
                }
                string = this.pageLabelFormat.format(new Object[]{markupAnnotation2.getPageIndex() + 1});
            }
        } else if (MarkupAnnotationPanel.SortColumn.AUTHOR.equals((Object)sortColumn)) {
            String string2;
            String string3;
            String string4 = string3 = markupAnnotation2.getTitleText() != null ? markupAnnotation2.getTitleText() : "";
            String string5 = markupAnnotation != null ? (markupAnnotation.getTitleText() != null ? markupAnnotation.getTitleText() : "") : (string2 = "");
            if (markupAnnotation == null || !string3.equals(string2)) {
                string = this.authorLabelFormat.format(new Object[]{string3});
            }
        } else if (MarkupAnnotationPanel.SortColumn.DATE.equals((Object)sortColumn)) {
            PDate pDate = markupAnnotation2.getCreationDate();
            if (markupAnnotation == null || !pDate.equalsDay(markupAnnotation.getCreationDate())) {
                LocalDateTime localDateTime = pDate.asLocalDateTime();
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(Locale.getDefault());
                string = this.dateLabelFormat.format(new Object[]{localDateTime.format(dateTimeFormatter)});
            }
        } else if (MarkupAnnotationPanel.SortColumn.TYPE.equals((Object)sortColumn)) {
            if (markupAnnotation == null || !markupAnnotation.getSubType().equals(markupAnnotation2.getSubType())) {
                string = this.messageBundle.getString("viewer.utilityPane.markupAnnotation.view.tree.type.label");
            }
        } else if (MarkupAnnotationPanel.SortColumn.COLOR.equals((Object)sortColumn) && (markupAnnotation == null || markupAnnotation.getColor() != null && !markupAnnotation.getColor().equals(markupAnnotation2.getColor()))) {
            string = this.colorLabelFormat.format(new Object[]{markupAnnotation2.getColor() != null ? this.findColor(markupAnnotation2.getColor()) : ""});
        }
        if (string != null) {
            this.publish(string);
        }
    }

    private String findColor(Color color) {
        if (colorLabels != null) {
            for (DragDropColorList.ColorLabel colorLabel : colorLabels) {
                if (!color.equals(colorLabel.getColor())) continue;
                return colorLabel.getLabel();
            }
        }
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    public static class Builder {
        private final Controller controller;
        final ResourceBundle messageBundle;
        private final MarkupAnnotationHandlerPanel markupAnnotationHandlerPanel;
        private Pattern searchPattern;
        private MarkupAnnotationPanel.SortColumn sortType;
        private MarkupAnnotationPanel.FilterSubTypeColumn filterType;
        private MarkupAnnotationPanel.FilterAuthorColumn filterAuthor;
        private MarkupAnnotationPanel.FilterVisibilityColumn filterVisibility;
        private Color filterColor;
        private boolean isRegex;
        private boolean isCaseSensitive;

        Builder(MarkupAnnotationHandlerPanel markupAnnotationHandlerPanel, Controller controller, ResourceBundle resourceBundle) {
            this.controller = controller;
            this.messageBundle = resourceBundle;
            this.markupAnnotationHandlerPanel = markupAnnotationHandlerPanel;
        }

        Builder setSearchPattern(Pattern pattern) {
            this.searchPattern = pattern;
            return this;
        }

        Builder setSortType(MarkupAnnotationPanel.SortColumn sortColumn) {
            this.sortType = sortColumn;
            return this;
        }

        Builder setFilterType(MarkupAnnotationPanel.FilterSubTypeColumn filterSubTypeColumn) {
            this.filterType = filterSubTypeColumn;
            return this;
        }

        Builder setFilterAuthor(MarkupAnnotationPanel.FilterAuthorColumn filterAuthorColumn) {
            this.filterAuthor = filterAuthorColumn;
            return this;
        }

        Builder setFilterVisibility(MarkupAnnotationPanel.FilterVisibilityColumn filterVisibilityColumn) {
            this.filterVisibility = filterVisibilityColumn;
            return this;
        }

        Builder setFilterColor(Color color) {
            this.filterColor = color;
            return this;
        }

        Builder setRegex(boolean bl) {
            this.isRegex = bl;
            return this;
        }

        Builder setCaseSensitive(boolean bl) {
            this.isCaseSensitive = bl;
            return this;
        }

        public FindMarkupAnnotationTask build() {
            return new FindMarkupAnnotationTask(this);
        }
    }

    static class AnnotationComparator
    implements Comparator<MarkupAnnotation> {
        private final MarkupAnnotationPanel.SortColumn sortColumn;

        AnnotationComparator(MarkupAnnotationPanel.SortColumn sortColumn) {
            this.sortColumn = sortColumn;
        }

        @Override
        public int compare(MarkupAnnotation markupAnnotation, MarkupAnnotation markupAnnotation2) {
            if (MarkupAnnotationPanel.SortColumn.PAGE.equals((Object)this.sortColumn)) {
                return Integer.compare(markupAnnotation.getPageIndex(), markupAnnotation2.getPageIndex());
            }
            if (MarkupAnnotationPanel.SortColumn.AUTHOR.equals((Object)this.sortColumn)) {
                String string = markupAnnotation.getTitleText();
                String string2 = markupAnnotation2.getTitleText();
                if (string != null && string2 != null) {
                    return string.compareToIgnoreCase(string2);
                }
                return 0;
            }
            if (MarkupAnnotationPanel.SortColumn.DATE.equals((Object)this.sortColumn)) {
                PDate pDate = markupAnnotation.getCreationDate();
                PDate pDate2 = markupAnnotation2.getCreationDate();
                LocalDateTime localDateTime = pDate.asLocalDateTime();
                LocalDateTime localDateTime2 = pDate2.asLocalDateTime();
                if (localDateTime != null && localDateTime2 != null) {
                    return localDateTime.compareTo(localDateTime2);
                }
                return 0;
            }
            if (MarkupAnnotationPanel.SortColumn.TYPE.equals((Object)this.sortColumn)) {
                String string = markupAnnotation.getSubType().toString();
                String string3 = markupAnnotation2.getSubType().toString();
                return string.compareToIgnoreCase(string3);
            }
            if (MarkupAnnotationPanel.SortColumn.COLOR.equals((Object)this.sortColumn)) {
                Color color = markupAnnotation.getColor();
                Color color2 = markupAnnotation2.getColor();
                if (color != null && color2 != null) {
                    int n = color.getRGB();
                    int n2 = color2.getRGB();
                    return Integer.compare(n2, n);
                }
                return 0;
            }
            return 0;
        }
    }
}

