/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class SigningPreferencesPanel
extends JPanel {
    public static final String PKCS_11_TYPE = "PKCS#11";
    public static final String PKCS_12_TYPE = "PKCS#12";
    private static final short PKCS11 = 0;
    private static final short PKCS12 = 1;
    private final GridBagConstraints constraints;
    private final JComboBox<KeystoreTypeItem> keystoreTypeComboBox;
    private final JLabel pkcsPathLabel;
    private final JTextField pkcsPathTextField;
    private final ResourceBundle messageBundle;
    private final Preferences preferences;

    public SigningPreferencesPanel(SwingController swingController, ViewerPropertiesManager viewerPropertiesManager, ResourceBundle resourceBundle) {
        super(new GridBagLayout());
        this.setAlignmentY(0.0f);
        this.preferences = viewerPropertiesManager.getPreferences();
        this.messageBundle = resourceBundle;
        KeystoreTypeItem[] keystoreTypeItemArray = new KeystoreTypeItem[]{new KeystoreTypeItem(resourceBundle.getString("viewer.dialog.viewerPreferences.section.signatures.pkcs.11.label"), PKCS_11_TYPE), new KeystoreTypeItem(resourceBundle.getString("viewer.dialog.viewerPreferences.section.signatures.pkcs.12.label"), PKCS_12_TYPE)};
        this.keystoreTypeComboBox = new JComboBox<KeystoreTypeItem>(keystoreTypeItemArray);
        this.keystoreTypeComboBox.setSelectedItem(new KeystoreTypeItem("", this.preferences.get("org.icepdf.core.signatures.keystore.type", keystoreTypeItemArray[1].value)));
        this.pkcsPathLabel = new JLabel();
        this.pkcsPathTextField = new JTextField();
        this.updatePkcsPaths();
        JButton jButton = new JButton(resourceBundle.getString("viewer.dialog.viewerPreferences.section.signatures.pkcs.keystore.path.browse.label"));
        jButton.addActionListener(actionEvent -> this.showBrowseDialog());
        this.pkcsPathTextField.addActionListener(actionEvent -> this.savePkcsPaths(this.keystoreTypeComboBox));
        this.keystoreTypeComboBox.addActionListener(actionEvent -> this.updatePkcsPaths());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setAlignmentY(0.0f);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1), resourceBundle.getString("viewer.dialog.viewerPreferences.section.signatures.pkcs.border.label"), 1, 0));
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 0;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.addGB(jPanel, new JLabel(resourceBundle.getString("viewer.dialog.viewerPreferences.section.signatures.pkcs.label")), 0, 0, 1, 1);
        this.constraints.anchor = 13;
        this.addGB(jPanel, this.keystoreTypeComboBox, 1, 0, 2, 1);
        this.constraints.anchor = 17;
        this.addGB(jPanel, this.pkcsPathLabel, 0, 1, 1, 1);
        this.constraints.anchor = 13;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 1;
        this.addGB(jPanel, this.pkcsPathTextField, 1, 1, 1, 1);
        this.addGB(jPanel, jButton, 2, 1, 1, 1);
        this.constraints.anchor = 18;
        this.constraints.fill = 1;
        this.addGB(this, jPanel, 0, 0, 1, 1);
        this.constraints.weighty = 1.0;
        this.addGB(this, new Label(" "), 0, 1, 1, 1);
    }

    private void updatePkcsPaths() {
        if (this.keystoreTypeComboBox.getSelectedIndex() == 0) {
            this.pkcsPathLabel.setText(this.messageBundle.getString("viewer.dialog.viewerPreferences.section.signatures.pkcs.11.config.path.label"));
            this.pkcsPathTextField.setText(this.preferences.get("org.icepdf.core.signatures.keystore.pkcs11.config.path", ""));
        } else if (this.keystoreTypeComboBox.getSelectedIndex() == 1) {
            this.pkcsPathLabel.setText(this.messageBundle.getString("viewer.dialog.viewerPreferences.section.signatures.pkcs.12.keystore.path.label"));
            this.pkcsPathTextField.setText(this.preferences.get("org.icepdf.core.signatures.keystore.pkcs12.config.path", ""));
        }
        KeystoreTypeItem keystoreTypeItem = (KeystoreTypeItem)this.keystoreTypeComboBox.getSelectedItem();
        if (keystoreTypeItem != null) {
            this.preferences.put("org.icepdf.core.signatures.keystore.type", keystoreTypeItem.getValue());
        }
    }

    private void savePkcsPaths(JComboBox jComboBox) {
        if (jComboBox.getSelectedIndex() == 0) {
            this.preferences.put("org.icepdf.core.signatures.keystore.pkcs11.config.path", this.pkcsPathTextField.getText());
        } else if (jComboBox.getSelectedIndex() == 1) {
            this.preferences.put("org.icepdf.core.signatures.keystore.pkcs12.config.path", this.pkcsPathTextField.getText());
        }
    }

    private void showBrowseDialog() {
        String string = this.pkcsPathTextField.getText();
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setDialogTitle(this.messageBundle.getString("viewer.dialog.viewerPreferences.section.signatures.pkcs.keystore.path.selection.title"));
        int n = jFileChooser.showDialog(this, this.messageBundle.getString("viewer.dialog.viewerPreferences.section.signatures.pkcs.keystore.path.accept.label"));
        if (n == 0) {
            this.pkcsPathTextField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            this.savePkcsPaths(this.keystoreTypeComboBox);
            this.updatePkcsPaths();
        }
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }

    static class KeystoreTypeItem {
        final String label;
        final String value;

        public KeystoreTypeItem(String string, String string2) {
            this.label = string;
            this.value = string2;
        }

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.label;
        }

        public boolean equals(Object object) {
            if (object instanceof KeystoreTypeItem) {
                return this.value.equals(((KeystoreTypeItem)object).getValue());
            }
            return this.value.equals(object);
        }
    }
}

