/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.concurrent.FutureTask;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.util.Library;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;

public class PageThumbnailComponent
extends AbstractPageViewComponent
implements MouseListener {
    private static final Logger logger = Logger.getLogger(PageThumbnailComponent.class.toString());

    public PageThumbnailComponent(DocumentViewController documentViewController, DocumentViewModel documentViewModel, PageTree pageTree, int n, float f) {
        this(documentViewController, documentViewModel, pageTree, n, 0, 0, f);
    }

    public PageThumbnailComponent(DocumentViewController documentViewController, DocumentViewModel documentViewModel, PageTree pageTree, int n, int n2, int n3, float f) {
        super(documentViewModel, pageTree, n, n2, n3);
        this.documentViewController = documentViewController;
        this.pageZoom = f;
        this.pageRotation = 0.0f;
        this.addMouseListener(this);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.updateView("documentViewZoomChange", 1, Float.valueOf(this.pageZoom));
    }

    @Override
    protected void calculateBufferLocation() {
        this.graphicsConfiguration = this.documentViewModel.getDocumentViewScrollPane().getGraphicsConfiguration();
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.documentViewModel.getDocumentViewScrollPane().getViewport().getViewRect();
        if (rectangle2.intersects(rectangle) && this.pageBufferStore.getImageReference() == null && (this.pageImageCaptureTask == null || this.pageImageCaptureTask.isDone() || this.pageImageCaptureTask.isCancelled())) {
            this.pageImageCaptureTask = new FutureTask<Object>(new AbstractPageViewComponent.PageImageCaptureTask(this, this.pageSize, this.pageSize, this.pageZoom, this.pageRotation));
            Library.execute((Runnable)this.pageImageCaptureTask);
        }
    }

    @Override
    public void dispose() {
        this.removeMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.documentViewController != null) {
            this.documentViewController.getParentController().getDocumentViewController().setCurrentPageIndex(this.pageIndex);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void pageInitializedCallback(Page page) {
    }

    @Override
    public void pageTeardownCallback() {
    }

    @Override
    public void clearSelectedText() {
    }
}

