/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.images.IconPack;
import org.icepdf.ri.images.Images;

public class DropDownButton
extends JButton
implements MouseListener {
    private static final Logger logger = Logger.getLogger(DropDownButton.class.toString());
    protected final Controller controller;
    protected final JPopupMenu popupMenu;
    protected final String imageName;
    protected final Images.IconSize imageSize;

    public DropDownButton(Controller controller, String string, String string2, String string3, Images.IconSize iconSize, Font font) {
        super(string);
        this.controller = controller;
        this.setFont(font);
        this.setToolTipText(string2);
        this.setRolloverEnabled(true);
        this.imageName = string3;
        this.imageSize = iconSize;
        if (string3 != null) {
            Images.applyIcons(this, string3, iconSize);
        }
        this.validate();
        this.popupMenu = new JPopupMenu();
        this.addMouseListener(this);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.popupMenu.setEnabled(bl);
    }

    @Override
    public void setSelected(boolean bl) {
        super.setSelected(bl);
        Images.applyIcon(this, this.imageName, bl ? IconPack.Variant.SELECTED : IconPack.Variant.NORMAL, this.imageSize);
    }

    public void add(JMenuItem jMenuItem, int n) {
        this.popupMenu.add((Component)jMenuItem, n);
    }

    public void add(JMenuItem jMenuItem) {
        this.popupMenu.add(jMenuItem);
    }

    public void addSeparator() {
        this.popupMenu.addSeparator();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && this.isEnabled()) {
            this.popupMenu.show(mouseEvent.getComponent(), 5, this.getHeight() - 5);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

