/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.icepdf.core.pobjects.Document;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.util.Resources;

public class ComponentKeyBinding {
    public static void install(final Controller controller, final JComponent jComponent) {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Document document = controller.getDocument();
                DocumentViewController documentViewController = controller.getDocumentViewController();
                if (document != null && controller.havePermissionToExtractContent() && (!documentViewController.getDocumentViewModel().isSelectAll() || document.getNumberOfPages() <= 250)) {
                    StringSelection stringSelection = new StringSelection(documentViewController.getSelectedText());
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
                } else {
                    Runnable runnable = () -> Resources.showMessageDialog(jComponent, 1, controller.getMessageBundle(), "viewer.dialog.information.copyAll.title", "viewer.dialog.information.copyAll.msg", 250);
                    SwingUtilities.invokeLater(runnable);
                }
            }
        };
        InputMap inputMap = jComponent.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(67, 128), "copyText");
        jComponent.getActionMap().put("copyText", abstractAction);
    }
}

