/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.icepdf.core.pobjects.Document;
import org.icepdf.ri.common.AbstractTask;
import org.icepdf.ri.common.MutableDocument;
import org.icepdf.ri.common.views.Controller;

public abstract class AbstractWorkerPanel
extends JPanel
implements MutableDocument {
    protected final Controller controller;
    protected final ResourceBundle messageBundle;
    protected JTree tree;
    protected DefaultMutableTreeNode rootTreeNode;
    protected String rootNodeLabel;
    protected DefaultTreeModel treeModel;
    protected DefaultTreeCellRenderer cellRenderer;
    protected GridBagConstraints constraints;
    protected AbstractTask workerTask;
    protected JProgressBar progressBar;
    protected JLabel progressLabel;
    protected NodeSelectionListener nodeSelectionListener;

    public AbstractWorkerPanel(Controller controller) {
        super(true);
        this.setFocusable(true);
        this.controller = controller;
        this.messageBundle = this.controller.getMessageBundle();
    }

    @Override
    public void refreshDocumentInstance() {
        if (this.rootTreeNode != null) {
            this.resetTree();
            this.rootTreeNode.setAllowsChildren(true);
            this.tree.setRootVisible(true);
        }
        this.buildWorkerTaskUI();
    }

    @Override
    public void disposeDocument() {
        if (this.workerTask != null && !this.workerTask.isDone()) {
            this.workerTask.cancel(true);
        }
    }

    protected void buildProgressBar() {
        this.progressBar = new JProgressBar(0, 1);
        this.progressBar.setValue(0);
        this.progressBar.setVisible(false);
        this.progressLabel = new JLabel("");
        this.progressLabel.setVisible(false);
        this.constraints.insets = new Insets(1, 1, 1, 1);
        this.constraints.weighty = 0.0;
        this.constraints.fill = 2;
        this.constraints.anchor = 13;
        this.progressLabel.setAlignmentX(1.0f);
        this.addGB(this, this.progressLabel, 0, 1, 1, 1);
        this.constraints.fill = 2;
        this.addGB(this, this.progressBar, 1, 1, 1, 1);
    }

    protected void buildUI() {
        this.rootTreeNode = new DefaultMutableTreeNode(this.rootNodeLabel);
        this.rootTreeNode.setAllowsChildren(true);
        this.treeModel = new DefaultTreeModel(this.rootTreeNode);
        this.tree = new JTree(this.treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(true);
        this.tree.setScrollsOnExpand(true);
        if (this.cellRenderer != null) {
            this.tree.setCellRenderer(this.cellRenderer);
        }
        this.tree.setRootVisible(false);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.setShowsRootHandles(true);
        this.tree.setScrollsOnExpand(true);
        if (this.nodeSelectionListener != null) {
            this.nodeSelectionListener.setTree(this.tree);
            this.tree.addMouseListener(this.nodeSelectionListener);
        }
        JScrollPane jScrollPane = new JScrollPane(this.tree, 22, 30);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        this.setLayout(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.anchor = 18;
        this.constraints.insets = new Insets(1, 1, 1, 1);
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.addGB(this, jScrollPane, 0, 0, 2, 1);
    }

    protected abstract void buildWorkerTaskUI();

    protected void stopWorkerTask() {
        if (this.workerTask != null) {
            this.workerTask.cancel(true);
        }
    }

    public abstract void selectTreeNodeUserObject(Object var1);

    protected void resetTree() {
        this.tree.setSelectionPath(null);
        this.rootTreeNode.removeAllChildren();
        this.treeModel.nodeStructureChanged(this.rootTreeNode);
        this.treeModel.reload();
    }

    public void expandAllNodes() {
        int n = this.tree.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.tree.expandRow(i);
            n = this.tree.getRowCount();
        }
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public abstract void startProgressControls(int var1);

    public abstract void updateProgressControls(int var1);

    public abstract void updateProgressControls(int var1, String var2);

    public abstract void updateProgressControls(String var1);

    public abstract void endProgressControls();

    public String getDocumentTitle() {
        String string = null;
        Document document = this.controller.getDocument();
        if (document != null && document.getInfo() != null) {
            string = document.getInfo().getTitle();
        }
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        return string;
    }

    protected void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }

    public static class NodeSelectionListener
    extends MouseAdapter {
        protected JTree tree;
        protected JPopupMenu contextMenu;

        public void setTree(JTree jTree) {
            this.tree = jTree;
        }
    }
}

