/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.destinations;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import org.icepdf.core.pobjects.Catalog;
import org.icepdf.core.pobjects.Destination;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.util.SystemProperties;
import org.icepdf.ri.common.utility.annotation.destinations.NameTreeEditDialog;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.ResizableBorder;
import org.icepdf.ri.common.views.ResizeableComponent;
import org.icepdf.ri.common.views.annotations.AnnotationState;

public class DestinationComponent
extends JComponent
implements FocusListener,
MouseInputListener,
ResizeableComponent,
ActionListener {
    protected static final Logger logger = Logger.getLogger(DestinationComponent.class.toString());
    private static final int HEIGHT = 24;
    protected float currentZoom;
    protected float currentRotation;
    public static final int resizeBoxSize = 4;
    protected static final ResizableBorder resizableBorder = new ResizableBorder(4);
    protected Destination destination;
    protected final DocumentViewController documentViewController;
    protected final AbstractPageViewComponent pageViewComponent;
    protected boolean isSelected;
    protected boolean isMousePressed;
    protected boolean resized;
    protected boolean wasResized;
    protected int dx;
    protected int dy;
    protected int cursor;
    protected Point startPos;
    protected AnnotationState previousAnnotationState;
    protected Point startOfMousePress;
    protected Point endOfMousePress;
    private final JPopupMenu contextMenu;
    private final JMenuItem deleteNameTreeNode;
    private final JMenuItem editNameTreeNode;

    public DestinationComponent(Destination destination, DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        this.destination = destination;
        this.documentViewController = documentViewController;
        this.pageViewComponent = abstractPageViewComponent;
        if (destination.getNamedDestination() != null) {
            this.setToolTipText(destination.getNamedDestination());
        }
        this.setFocusable(true);
        this.setBorder(resizableBorder);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.refreshBounds();
        DocumentViewModel documentViewModel = documentViewController.getDocumentViewModel();
        this.currentRotation = documentViewModel.getViewRotation();
        this.currentZoom = documentViewModel.getViewZoom();
        resizableBorder.setZoom(this.currentZoom);
        ResourceBundle resourceBundle = documentViewController.getParentController().getMessageBundle();
        this.contextMenu = new JPopupMenu();
        this.editNameTreeNode = new JMenuItem(resourceBundle.getString("viewer.utilityPane.destinations.view.contextMenu.edit.label"));
        this.editNameTreeNode.addActionListener(this);
        this.contextMenu.add(this.editNameTreeNode);
        this.contextMenu.addSeparator();
        this.deleteNameTreeNode = new JMenuItem(resourceBundle.getString("viewer.utilityPane.destinations.view.contextMenu.delete.label"));
        this.deleteNameTreeNode.addActionListener(this);
        this.contextMenu.add(this.deleteNameTreeNode);
    }

    public void updateDestination(Destination destination) {
        this.destination = destination;
        if (destination.getNamedDestination() != null) {
            this.setToolTipText(destination.getNamedDestination());
        }
        this.refreshBounds();
    }

    public Destination getDestination() {
        return this.destination;
    }

    @Override
    public void validate() {
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        if (this.currentZoom != documentViewModel.getViewZoom() || this.currentRotation != documentViewModel.getViewRotation()) {
            this.refreshBounds();
            this.currentRotation = documentViewModel.getViewRotation();
            this.currentZoom = documentViewModel.getViewZoom();
            resizableBorder.setZoom(this.currentZoom);
        }
    }

    public void refreshBounds() {
        if (this.destination.getLeft() != null && this.destination.getTop() != null) {
            Page page = this.pageViewComponent.getPage();
            DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
            AffineTransform affineTransform = page.getPageTransform(documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
            int n = 18;
            int n2 = this.destination.getLeft().intValue() - n;
            int n3 = this.destination.getTop().intValue();
            int n4 = 1;
            Rectangle rectangle = new Rectangle(n2 + n4, n3 - n4, n, 24);
            Shape shape = affineTransform.createTransformedShape(rectangle);
            this.setBounds(shape.getBounds());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!SystemProperties.INTERACTIVE_ANNOTATIONS) {
            return;
        }
        Object object = actionEvent.getSource();
        Controller controller = this.documentViewController.getParentController();
        if (object == this.editNameTreeNode) {
            NameTreeEditDialog nameTreeEditDialog = new NameTreeEditDialog(controller, this.destination);
            nameTreeEditDialog.setVisible(true);
        } else if (object == this.deleteNameTreeNode) {
            controller.getDocumentViewController().firePropertyChange("destinationDeleted", this.destination, null);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.documentViewController.getParentController().getViewModel().isAnnotationEditingMode()) {
            this.isSelected = true;
        }
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.isSelected = false;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!SystemProperties.INTERACTIVE_ANNOTATIONS) {
            return;
        }
        this.requestFocus();
        if (this.documentViewController.getDocumentViewModel().getViewToolMode() == 6 && mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 3) {
            this.contextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!SystemProperties.INTERACTIVE_ANNOTATIONS) {
            return;
        }
        this.requestFocus();
        this.isMousePressed = true;
        Point point = new Point();
        if (mouseEvent != null) {
            point = mouseEvent.getPoint();
        }
        this.startOfMousePress = point;
        this.endOfMousePress = new Point(point);
        if (this.documentViewController.getDocumentViewModel().getViewToolMode() == 6 && this.documentViewController.getParentController().getViewModel().isAnnotationEditingMode()) {
            Border border = this.getBorder();
            if (border instanceof ResizableBorder) {
                this.cursor = ((ResizableBorder)border).getCursor(mouseEvent);
            }
            this.startPos = mouseEvent.getPoint();
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.startPos = null;
        this.isMousePressed = false;
        if (this.wasResized) {
            this.wasResized = false;
        }
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.setCursor(Cursor.getDefaultCursor());
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.startPos != null) {
            this.dx = mouseEvent.getX() - this.startPos.x;
            this.dy = mouseEvent.getY() - this.startPos.y;
            if (this.endOfMousePress != null) {
                this.endOfMousePress.setLocation(this.endOfMousePress.x + this.dx, this.endOfMousePress.y + this.dy);
            }
            Rectangle rectangle = this.getBounds();
            rectangle.translate(this.dx, this.dy);
            this.setBounds(rectangle);
            this.resize();
            this.setCursor(Cursor.getPredefinedCursor(this.cursor));
            Page page = this.pageViewComponent.getPage();
            DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
            AffineTransform affineTransform = page.getToPageSpaceTransform(documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
            Point point = this.getLocation();
            point.setLocation(point.x + this.getWidth(), point.y + this.getHeight());
            Point2D point2D = affineTransform.transform(point, null);
            this.destination.setLocation((float)((int)point2D.getX()), (float)((int)point2D.getY()));
            Catalog catalog = this.documentViewController.getParentController().getDocument().getCatalog();
            String string = this.destination.getNamedDestination();
            catalog.updateNamedDestination(string, string, this.destination);
            this.refreshBounds();
            this.repaint();
        }
    }

    protected void resize() {
        if (this.getParent() != null) {
            this.getParent().validate();
        }
        this.resized = true;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.documentViewController.getDocumentViewModel().getViewToolMode();
        if (n == 6 && this.documentViewController.getParentController().getViewModel().isAnnotationEditingMode()) {
            Border border = this.getBorder();
            if (border instanceof ResizableBorder) {
                this.setCursor(Cursor.getPredefinedCursor(((ResizableBorder)border).getCursor(mouseEvent)));
            }
        } else {
            this.setCursor(this.documentViewController.getViewCursor(8));
        }
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean isResizable() {
        return false;
    }

    @Override
    public boolean isMovable() {
        return true;
    }

    @Override
    public boolean isSelected() {
        return this.isSelected;
    }

    @Override
    public boolean isBorderStyle() {
        return false;
    }

    @Override
    public boolean isRollover() {
        return false;
    }

    @Override
    public boolean isShowInvisibleBorder() {
        return false;
    }

    public static void paintDestination(Destination destination, Graphics2D graphics2D) {
        if (destination.getLeft() != null && destination.getTop() != null) {
            int n = destination.getLeft().intValue();
            int n2 = destination.getTop().intValue();
            int n3 = 24;
            int n4 = n - n3 / 3;
            int n5 = n2 + n3 / 2;
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            graphics2D.setColor(Color.GRAY);
            graphics2D.drawLine(n, n2, n4, n5);
            graphics2D.setColor(Color.RED);
            graphics2D.fillOval(n4 - 5, n5 - 5, 10, 10);
            graphics2D.setStroke(new BasicStroke(0.4f));
            graphics2D.setColor(Color.LIGHT_GRAY);
            graphics2D.drawOval(n4 - 5, n5 - 5, 10, 10);
            graphics2D.setColor(Color.WHITE);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
            graphics2D.fillOval(n4 - 3, n5 - 1, 4, 4);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
    }
}

