/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations.signatures;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.icepdf.core.util.HexDumper;
import org.icepdf.ri.common.EscapeJDialog;
import org.icepdf.ri.common.utility.signatures.SignatureUtilities;
import org.icepdf.ri.common.views.annotations.signatures.CertificateInfo;
import org.icepdf.ri.images.IconPack;
import org.icepdf.ri.images.Images;

public class CertificatePropertiesDialog
extends EscapeJDialog {
    private static final Logger logger = Logger.getLogger(CertificatePropertiesDialog.class.toString());
    protected static ResourceBundle messageBundle;
    private final Collection<? extends Certificate> certs;

    public CertificatePropertiesDialog(Frame frame, ResourceBundle resourceBundle, Collection<? extends Certificate> collection) {
        super(frame, true);
        messageBundle = resourceBundle;
        this.certs = collection;
        this.buildUI();
    }

    public CertificatePropertiesDialog(JDialog jDialog, ResourceBundle resourceBundle, Collection<? extends Certificate> collection) {
        super((Dialog)jDialog, true);
        messageBundle = resourceBundle;
        this.certs = collection;
        this.buildUI();
    }

    private void buildUI() {
        this.setTitle(messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.title"));
        this.getContentPane().setLayout(new BorderLayout());
        Certificate[] certificateArray = new Certificate[this.certs.size()];
        int n = 0;
        Object jPanel = this.certs.iterator();
        while (jPanel.hasNext()) {
            Certificate serializable2;
            certificateArray[n] = serializable2 = jPanel.next();
            ++n;
        }
        this.getContentPane().add((Component)this.getComponents(certificateArray), "Center");
        jPanel = new JPanel();
        ((Container)jPanel).setLayout(new FlowLayout(4));
        JButton jButton = new JButton(messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.closeButton.label"));
        jButton.setMnemonic("viewer.utilityPane.signatures.cert.dialog.closeButton.mnemonic".charAt(0));
        jButton.addActionListener(actionEvent -> this.setVisible(false));
        ((Container)jPanel).add(jButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.setSize(new Dimension(760, 450));
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(true);
    }

    private JComponent getComponents(Certificate[] certificateArray) {
        if (certificateArray.length > 0) {
            JTable jTable = new JTable();
            JTextArea jTextArea = new JTextArea();
            JTree jTree = this.buildCertChainTree(certificateArray);
            jTree.addTreeSelectionListener(treeSelectionEvent -> {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)jTree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode != null) {
                    CertificateInfo certificateInfo = (CertificateInfo)defaultMutableTreeNode.getUserObject();
                    this.showCertificateInfo(certificateInfo.getCertificate(), jTable, jTextArea);
                }
            });
            this.showCertificateInfo((X509Certificate)certificateArray[0], jTable, jTextArea);
            jTable.setSelectionMode(0);
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            listSelectionModel.addListSelectionListener(listSelectionEvent -> {
                int n = jTable.getSelectedRow();
                if (n >= 0) {
                    String string = (String)jTable.getValueAt(n, 1);
                    jTextArea.setText(string);
                    jTextArea.repaint();
                }
            });
            jTextArea.setLineWrap(false);
            jTextArea.setEditable(false);
            jTextArea.setRows(10);
            jTextArea.setColumns(40);
            Font font = new Font("Monospaced", 0, 12);
            jTextArea.setFont(font);
            jTable.setRowSelectionInterval(8, 8);
            JScrollPane jScrollPane = new JScrollPane(jTable);
            JSplitPane jSplitPane = new JSplitPane(0);
            jSplitPane.setDividerLocation(175);
            jSplitPane.setTopComponent(jScrollPane);
            jSplitPane.setBottomComponent(new JScrollPane(jTextArea));
            JSplitPane jSplitPane2 = new JSplitPane(1);
            jSplitPane2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), jScrollPane.getBorder()));
            jSplitPane2.setDividerLocation(200);
            jScrollPane = new JScrollPane(jTree);
            jSplitPane2.setLeftComponent(jScrollPane);
            jSplitPane2.setRightComponent(jSplitPane);
            return jSplitPane2;
        }
        return new JPanel();
    }

    private Object[] formatDNString(X500Name x500Name) {
        Object[] objectArray = new Object[]{CertificatePropertiesDialog.parseRelativeDistinguishedName(x500Name, BCStyle.O), CertificatePropertiesDialog.parseRelativeDistinguishedName(x500Name, BCStyle.OU), CertificatePropertiesDialog.parseRelativeDistinguishedName(x500Name, BCStyle.CN), CertificatePropertiesDialog.parseRelativeDistinguishedName(x500Name, BCStyle.L), CertificatePropertiesDialog.parseRelativeDistinguishedName(x500Name, BCStyle.ST), CertificatePropertiesDialog.parseRelativeDistinguishedName(x500Name, BCStyle.C), CertificatePropertiesDialog.parseRelativeDistinguishedName(x500Name, BCStyle.EmailAddress)};
        return objectArray;
    }

    protected static String parseRelativeDistinguishedName(X500Name x500Name, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        String string = SignatureUtilities.parseRelativeDistinguishedName(x500Name, aSN1ObjectIdentifier);
        if (string != null) {
            return string;
        }
        return messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.notAvailable.label");
    }

    private JTree buildCertChainTree(Certificate[] certificateArray) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (Certificate certificate : certificateArray) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new CertificateInfo((X509Certificate)certificate, messageBundle));
            if (defaultMutableTreeNode == null) {
                defaultMutableTreeNode = defaultMutableTreeNode3;
            } else {
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            }
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
        }
        JTree jTree = new JTree(defaultMutableTreeNode);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.putClientProperty("html.disable", Boolean.TRUE);
        Icon icon = Images.getSingleIcon("page", IconPack.Variant.NONE, Images.IconSize.TINY);
        defaultTreeCellRenderer.setOpenIcon(icon);
        defaultTreeCellRenderer.setClosedIcon(icon);
        defaultTreeCellRenderer.setLeafIcon(icon);
        jTree.setCellRenderer(defaultTreeCellRenderer);
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.setRootVisible(true);
        jTree.setShowsRootHandles(true);
        jTree.setScrollsOnExpand(true);
        return jTree;
    }

    private void byte2hex(byte by, StringBuffer stringBuffer) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n = (by & 0xF0) >> 4;
        int n2 = by & 0xF;
        stringBuffer.append(cArray[n]);
        stringBuffer.append(cArray[n2]);
    }

    private String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            this.byte2hex(byArray[i], stringBuffer);
            if (i >= n - 1) continue;
            stringBuffer.append(":");
        }
        return stringBuffer.toString();
    }

    private String getCertFingerPrint(String string, X509Certificate x509Certificate) throws Exception {
        byte[] byArray = x509Certificate.getEncoded();
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        byte[] byArray2 = messageDigest.digest(byArray);
        return this.toHexString(byArray2);
    }

    private void showCertificateInfo(X509Certificate x509Certificate, JTable jTable, JTextArea jTextArea) {
        MessageFormat messageFormat = new MessageFormat(messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.version.value"));
        String string = messageFormat.format(new Object[]{String.valueOf(x509Certificate.getVersion())});
        messageFormat.applyPattern(messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.serialNumber.value"));
        String string2 = messageFormat.format(new Object[]{String.valueOf(x509Certificate.getSerialNumber())});
        messageFormat.applyPattern(messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.signatureAlgorithm.value"));
        String string3 = messageFormat.format(new Object[]{x509Certificate.getSigAlgName()});
        messageFormat.applyPattern(messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.issuer.value"));
        String string4 = messageFormat.format(this.formatDNString(new X500Name(x509Certificate.getIssuerDN().toString())));
        messageFormat.applyPattern(messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.validity.value"));
        String string5 = messageFormat.format(new Object[]{x509Certificate.getNotBefore(), x509Certificate.getNotAfter()});
        messageFormat.applyPattern(messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.subject.value"));
        String string6 = messageFormat.format(this.formatDNString(new X500Name(x509Certificate.getSubjectDN().toString())));
        String string7 = new HexDumper().dump(x509Certificate.getSignature());
        String string8 = null;
        String string9 = null;
        try {
            messageFormat.applyPattern(messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.md5.value"));
            string8 = messageFormat.format(new Object[]{this.getCertFingerPrint("MD5", x509Certificate)});
            messageFormat.applyPattern(messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.sha1.value"));
            string9 = messageFormat.format(new Object[]{this.getCertFingerPrint("SHA1", x509Certificate)});
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Failed to get cert fingerprint", exception);
        }
        Object[][] objectArray = new Object[][]{{messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.version.label"), string}, {messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.serialNumber.label"), string2}, {messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.signatureAlgorithm.label"), string3}, {messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.issuer.label"), string4}, {messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.validity.label"), string5}, {messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.subject.label"), string6}, {messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.signature.label"), string7}, {messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.md5.label"), string8}, {messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.sha1.label"), string9}};
        Object[] objectArray2 = new String[]{messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.column1.label"), messageBundle.getString("viewer.utilityPane.signatures.cert.dialog.info.column2.label")};
        jTable.setModel(new DefaultTableModel(objectArray, objectArray2){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        });
        jTable.setRowSelectionInterval(8, 8);
        jTable.repaint();
        jTextArea.repaint();
    }
}

