/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.border.AbstractBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.icepdf.core.pobjects.annotations.BorderStyle;
import org.icepdf.core.pobjects.annotations.FreeTextAnnotation;
import org.icepdf.core.pobjects.fonts.FontManager;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewControllerImpl;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.MarkupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.ScalableTextArea;
import org.icepdf.ri.common.views.annotations.SpellCheckLoader;

public class FreeTextAnnotationComponent
extends MarkupAnnotationComponent<FreeTextAnnotation>
implements PropertyChangeListener,
DocumentListener {
    private static final Logger logger = Logger.getLogger(FreeTextAnnotation.class.toString());
    private final ScalableTextArea freeTextPane;
    protected Font fontFile;
    private boolean contentTextChange;

    public FreeTextAnnotationComponent(FreeTextAnnotation freeTextAnnotation, DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(freeTextAnnotation, documentViewController, abstractPageViewComponent);
        this.isRollover = false;
        this.isShowInvisibleBorder = false;
        this.freeTextPane = new ScalableTextArea(documentViewController.getDocumentViewModel());
        this.freeTextPane.setLineWrap(false);
        this.freeTextPane.setBackground(new Color(0, 0, 0, 0));
        this.freeTextPane.setMargin(new Insets(0, 0, 0, 0));
        this.freeTextPane.setEditable(false);
        this.applyAppearanceStreamToFreeTextPane();
        String string = freeTextAnnotation.getContents();
        if (string != null) {
            string = string.replace('\r', '\n');
            this.freeTextPane.setText(string);
        }
        this.freeTextPane.getDocument().addDocumentListener(this);
        SpellCheckLoader.addSpellChecker(this.freeTextPane);
        GridLayout gridLayout = new GridLayout(1, 1, 0, 0);
        this.setLayout(gridLayout);
        this.add(this.freeTextPane);
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addPropertyChangeListener(this);
        if (!freeTextAnnotation.hasAppearanceStream()) {
            this.resetAppearanceShapes();
        }
        this.revalidate();
        ((DocumentViewControllerImpl)documentViewController).addPropertyChangeListener(this);
    }

    @Override
    public void validate() {
        if (this.freeTextPane != null) {
            DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
            this.freeTextPane.setFont(new Font(((FreeTextAnnotation)this.annotation).getFontName(), 0, (int)((float)((FreeTextAnnotation)this.annotation).getFontSize() * documentViewModel.getViewZoom())));
        }
        super.validate();
    }

    private void applyAppearanceStreamToFreeTextPane() {
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        this.fontFile = FontManager.getInstance().initialize().getType1AWTFont(((FreeTextAnnotation)this.annotation).getFontName(), (int)((float)((FreeTextAnnotation)this.annotation).getFontSize() * documentViewModel.getViewZoom()));
        this.freeTextPane.setFont(this.fontFile);
        this.freeTextPane.setForeground(((FreeTextAnnotation)this.annotation).getFontColor());
        if (((FreeTextAnnotation)this.annotation).isFillType()) {
            this.freeTextPane.setOpaque(true);
            this.freeTextPane.setBackground(((FreeTextAnnotation)this.annotation).getFillColor());
        } else {
            this.freeTextPane.setOpaque(false);
        }
        if (((FreeTextAnnotation)this.annotation).isStrokeType()) {
            if (((FreeTextAnnotation)this.annotation).getBorderStyle().isStyleSolid()) {
                this.freeTextPane.setBorder(BorderFactory.createLineBorder(((FreeTextAnnotation)this.annotation).getColor(), (int)((FreeTextAnnotation)this.annotation).getBorderStyle().getStrokeWidth()));
            } else if (((FreeTextAnnotation)this.annotation).getBorderStyle().isStyleDashed()) {
                this.freeTextPane.setBorder(new DashedBorder(((FreeTextAnnotation)this.annotation).getBorderStyle(), ((FreeTextAnnotation)this.annotation).getColor()));
            }
        } else {
            this.freeTextPane.setBorder(BorderFactory.createEmptyBorder());
        }
        this.freeTextPane.revalidate();
    }

    private void applyFreeTextPanelContents() {
        String string = null;
        try {
            string = this.freeTextPane.getDocument().getText(0, this.freeTextPane.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            logger.warning("Error getting rich text.");
        }
        Rectangle rectangle = this.convertToPageSpace(this.getBounds());
        ((FreeTextAnnotation)this.annotation).setBBox(new Rectangle(0, 0, rectangle.width, rectangle.height));
        ((FreeTextAnnotation)this.annotation).setContents(string);
        ((FreeTextAnnotation)this.annotation).setRichText(this.freeTextPane.getText());
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        this.resetAppearanceShapes();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.contentTextChange = true;
        this.autoResize();
        this.updatePopupText();
        this.documentViewController.updateAnnotation(this);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.contentTextChange = true;
        this.autoResize();
        this.updatePopupText();
        this.documentViewController.updateAnnotation(this);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.contentTextChange = true;
        this.autoResize();
        this.updatePopupText();
        this.documentViewController.updateAnnotation(this);
    }

    protected void autoResize() {
        Dimension dimension = this.getPreferredSize();
        Rectangle rectangle = this.getBounds();
        int n = 10;
        this.setBounds(rectangle.x, rectangle.y, dimension.width + n, dimension.height);
        this.resize();
        this.refreshAnnotationRect();
    }

    protected void updatePopupText() {
        ((FreeTextAnnotation)this.annotation).setContents(this.freeTextPane.getText());
        PopupAnnotationComponent popupAnnotationComponent = this.getPopupAnnotationComponent();
        if (popupAnnotationComponent != null) {
            popupAnnotationComponent.refreshPopupState();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        PopupAnnotationComponent popupAnnotationComponent;
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        Object object2 = propertyChangeEvent.getOldValue();
        if ("focusOwner".equals(string) && object2 instanceof JTextArea) {
            JTextArea jTextArea = (JTextArea)object2;
            if (jTextArea.equals(this.freeTextPane)) {
                jTextArea.setEditable(false);
                if (this.contentTextChange) {
                    this.contentTextChange = false;
                    ((FreeTextAnnotation)this.annotation).setContents(jTextArea.getText());
                    this.resetAppearanceShapes();
                    this.documentViewController.updateAnnotation(this);
                }
                if (jTextArea instanceof ScalableTextArea) {
                    ((ScalableTextArea)jTextArea).setActive(false);
                }
            }
            this.repaint();
        } else if ("focusOwner".equals(string) && object instanceof JTextArea) {
            JTextArea jTextArea = (JTextArea)object;
            if (jTextArea.equals(this.freeTextPane) && !((FreeTextAnnotation)this.annotation).getFlagReadOnly()) {
                jTextArea.setEditable(true);
                if (jTextArea instanceof ScalableTextArea) {
                    ((ScalableTextArea)jTextArea).setActive(true);
                }
            }
            this.repaint();
        } else if (("annotationUpdated".equals(propertyChangeEvent.getPropertyName()) || "annotationSummaryUpdated".equals(propertyChangeEvent.getPropertyName())) && propertyChangeEvent.getNewValue() instanceof PopupAnnotationComponent && this.equals((popupAnnotationComponent = (PopupAnnotationComponent)propertyChangeEvent.getNewValue()).getAnnotationParentComponent())) {
            this.freeTextPane.getDocument().removeDocumentListener(this);
            this.freeTextPane.setText(popupAnnotationComponent.textArea.getText());
            this.autoResize();
            this.resetAppearanceShapes();
            this.freeTextPane.getDocument().addDocumentListener(this);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        this.isShowInvisibleBorder = (documentViewModel.getViewToolMode() == 6 || documentViewModel.getViewToolMode() == 17) && !((FreeTextAnnotation)this.annotation).getFlagReadOnly() && !((FreeTextAnnotation)this.annotation).getFlagLocked() && !((FreeTextAnnotation)this.annotation).getFlagInvisible() && !((FreeTextAnnotation)this.annotation).getFlagHidden();
    }

    @Override
    public void dispose() {
        super.dispose();
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.removePropertyChangeListener(this);
    }

    @Override
    public void resetAppearanceShapes() {
        super.resetAppearanceShapes();
        this.applyFreeTextPanelContents();
        ((FreeTextAnnotation)this.annotation).resetAppearanceStream(this.getToPageSpaceTransform());
    }

    @Override
    public boolean isActive() {
        return this.freeTextPane.isActive();
    }

    public String clearXMLHeader(String string) {
        String string2 = "[<][?]\\s*[xml].*[?][>]";
        string = string.replaceFirst(string2, "");
        return string;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
    }

    public void requestTextAreaFocus() {
        this.freeTextPane.requestFocus();
    }

    private class DashedBorder
    extends AbstractBorder {
        private final BasicStroke stroke;
        private final Color color;

        DashedBorder(BorderStyle borderStyle, Color color) {
            int n = (int)borderStyle.getStrokeWidth();
            this.stroke = new BasicStroke(n, 2, 0, (float)n * 2.0f, ((FreeTextAnnotation)FreeTextAnnotationComponent.this.annotation).getBorderStyle().getDashArray(), 0.0f);
            this.color = color;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            float f = this.stroke.getLineWidth();
            if (f > 0.0f) {
                if ((graphics = graphics.create()) instanceof Graphics2D) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setStroke(this.stroke);
                    graphics2D.setPaint((Paint)(this.color != null ? this.color : (component == null ? null : component.getForeground())));
                    graphics2D.draw(new Rectangle2D.Float((float)n + f / 2.0f, (float)n2 + f / 2.0f, (float)n3 - f, (float)n4 - f));
                }
                graphics.dispose();
            }
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.right = insets.bottom = (int)this.stroke.getLineWidth();
            insets.top = insets.bottom;
            insets.left = insets.bottom;
            return insets;
        }
    }

    public static class MyHtml2Text
    extends HTMLEditorKit.ParserCallback {
        StringBuffer s;

        public void parse(Reader reader) throws IOException {
            this.s = new StringBuffer();
            ParserDelegator parserDelegator = new ParserDelegator();
            parserDelegator.parse(reader, this, Boolean.TRUE);
        }

        @Override
        public void handleText(char[] cArray, int n) {
            this.s.append(cArray);
            this.s.append("\n");
        }

        public String getText() {
            return this.s.toString();
        }
    }
}

