/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.icepdf.core.pobjects.LiteralStringObject;
import org.icepdf.core.pobjects.NameTree;
import org.icepdf.core.pobjects.annotations.LinkAnnotation;
import org.icepdf.ri.common.utility.annotation.properties.NameTreeDialog;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.common.views.PageViewComponentImpl;

public class AnnotationPopup<T extends AnnotationComponent>
extends JPopupMenu
implements ActionListener {
    protected final JMenuItem propertiesMenuItem;
    protected final JMenuItem deleteMenuItem;
    protected final JMenuItem destinationsMenuItem;
    protected int x;
    protected int y;
    protected T annotationComponent;
    protected PageViewComponentImpl pageViewComponent;
    protected final Controller controller;
    protected final ResourceBundle messageBundle;

    public AnnotationPopup(T t, Controller controller, AbstractPageViewComponent abstractPageViewComponent) {
        this.annotationComponent = t;
        this.pageViewComponent = (PageViewComponentImpl)abstractPageViewComponent;
        this.controller = controller;
        this.messageBundle = controller.getMessageBundle();
        boolean bl = controller.havePermissionToModifyDocument();
        this.propertiesMenuItem = new JMenuItem(this.messageBundle.getString("viewer.annotation.popup.properties.label"));
        this.deleteMenuItem = new JMenuItem(this.messageBundle.getString("viewer.annotation.popup.delete.label"));
        this.deleteMenuItem.setEnabled(bl);
        this.destinationsMenuItem = new JMenuItem(this.messageBundle.getString("viewer.annotation.popup.destinations.label"));
    }

    public void buildGui() {
        this.add((Component)this.destinationsMenuItem, -1);
        this.destinationsMenuItem.addActionListener(this);
        if (!(this.annotationComponent.getAnnotation() instanceof LinkAnnotation)) {
            this.destinationsMenuItem.setEnabled(false);
        }
        this.addSeparator();
        this.add((Component)this.deleteMenuItem, -1);
        this.deleteMenuItem.addActionListener(this);
        this.addSeparator();
        this.add(this.propertiesMenuItem);
        this.propertiesMenuItem.addActionListener(this);
    }

    protected void setDeleteMenuItemEnabledState() {
        if (this.destinationsMenuItem != null) {
            this.destinationsMenuItem.setEnabled(this.controller.getDocument().getCatalog().getNames() != null);
        }
    }

    @Override
    public void show(Component component, int n, int n2) {
        this.setDeleteMenuItemEnabledState();
        this.x = n;
        this.y = n2;
        super.show(component, n, n2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        NameTree nameTree;
        Object object = actionEvent.getSource();
        if (object == null) {
            return;
        }
        if (object == this.propertiesMenuItem) {
            this.controller.showAnnotationProperties((AnnotationComponent)this.annotationComponent);
        } else if (object == this.deleteMenuItem) {
            this.controller.getDocumentViewController().deleteAnnotation((AnnotationComponent)this.annotationComponent);
        } else if (object == this.destinationsMenuItem && this.controller.getDocument().getCatalog().getNames() != null && (nameTree = this.controller.getDocument().getCatalog().getNames().getDestsNameTree()) != null) {
            NameTreeDialog nameTreeDialog = new NameTreeDialog(this.controller, true, nameTree);
            LinkAnnotation linkAnnotation = (LinkAnnotation)this.annotationComponent.getAnnotation();
            Object object2 = linkAnnotation.getEntries().get((Object)LinkAnnotation.DESTINATION_KEY);
            String string = "";
            if (object2 instanceof LiteralStringObject) {
                string = ((LiteralStringObject)object2).getDecryptedLiteralString(this.controller.getDocument().getSecurityManager());
            }
            nameTreeDialog.setDestinationName(string);
            nameTreeDialog.setVisible(true);
            linkAnnotation.setNamedDestination(nameTreeDialog.getDestinationName());
            nameTreeDialog.dispose();
        }
    }
}

