/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations;

import java.awt.Graphics;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.acroform.ButtonFieldDictionary;
import org.icepdf.core.pobjects.acroform.ChoiceFieldDictionary;
import org.icepdf.core.pobjects.acroform.FieldDictionaryFactory;
import org.icepdf.core.pobjects.annotations.AbstractWidgetAnnotation;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.ButtonWidgetAnnotation;
import org.icepdf.core.pobjects.annotations.ChoiceWidgetAnnotation;
import org.icepdf.core.pobjects.annotations.CircleAnnotation;
import org.icepdf.core.pobjects.annotations.FreeTextAnnotation;
import org.icepdf.core.pobjects.annotations.InkAnnotation;
import org.icepdf.core.pobjects.annotations.LineAnnotation;
import org.icepdf.core.pobjects.annotations.LinkAnnotation;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.annotations.PopupAnnotation;
import org.icepdf.core.pobjects.annotations.RedactionAnnotation;
import org.icepdf.core.pobjects.annotations.SignatureWidgetAnnotation;
import org.icepdf.core.pobjects.annotations.SquareAnnotation;
import org.icepdf.core.pobjects.annotations.TextAnnotation;
import org.icepdf.core.pobjects.annotations.TextMarkupAnnotation;
import org.icepdf.core.pobjects.annotations.TextWidgetAnnotation;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.CircleAnnotationComponent;
import org.icepdf.ri.common.views.annotations.FreeTextAnnotationComponent;
import org.icepdf.ri.common.views.annotations.InkAnnotationComponent;
import org.icepdf.ri.common.views.annotations.LineAnnotationComponent;
import org.icepdf.ri.common.views.annotations.LinkAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PolyLineAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PolygonAnnotationComponent;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.RedactionAnnotationComponent;
import org.icepdf.ri.common.views.annotations.SquareAnnotationComponent;
import org.icepdf.ri.common.views.annotations.TextAnnotationComponent;
import org.icepdf.ri.common.views.annotations.TextMarkupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.WidgetAnnotationComponent;
import org.icepdf.ri.common.views.annotations.acroform.AbstractButtonComponent;
import org.icepdf.ri.common.views.annotations.acroform.AbstractChoiceComponent;
import org.icepdf.ri.common.views.annotations.acroform.CheckButtonComponent;
import org.icepdf.ri.common.views.annotations.acroform.ChoiceComboComponent;
import org.icepdf.ri.common.views.annotations.acroform.ChoiceListComponent;
import org.icepdf.ri.common.views.annotations.acroform.PushButtonComponent;
import org.icepdf.ri.common.views.annotations.acroform.RadioButtonComponent;
import org.icepdf.ri.common.views.annotations.acroform.SignatureComponent;
import org.icepdf.ri.common.views.annotations.acroform.TextWidgetComponent;

public class AnnotationComponentFactory {
    protected static final Logger logger = Logger.getLogger(AnnotationComponentFactory.class.toString());

    private AnnotationComponentFactory() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized AbstractAnnotationComponent buildAnnotationComponent(Annotation annotation, DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        Name name = annotation.getSubType();
        if (name == null) return null;
        if (Annotation.SUBTYPE_LINK.equals(name)) {
            return new LinkAnnotationComponent((LinkAnnotation)annotation, documentViewController, abstractPageViewComponent);
        }
        if (TextMarkupAnnotation.isTextMarkupAnnotation((Name)name)) {
            return new TextMarkupAnnotationComponent((TextMarkupAnnotation)annotation, documentViewController, abstractPageViewComponent);
        }
        if (Annotation.SUBTYPE_REDACT.equals(name)) {
            return new RedactionAnnotationComponent((RedactionAnnotation)annotation, documentViewController, abstractPageViewComponent);
        }
        if (Annotation.SUBTYPE_LINE.equals(name)) {
            return new LineAnnotationComponent((LineAnnotation)annotation, documentViewController, abstractPageViewComponent);
        }
        if (Annotation.SUBTYPE_CIRCLE.equals(name)) {
            return new CircleAnnotationComponent((CircleAnnotation)annotation, documentViewController, abstractPageViewComponent);
        }
        if (Annotation.SUBTYPE_POLYGON.equals(name)) {
            return new PolygonAnnotationComponent((MarkupAnnotation)annotation, documentViewController, abstractPageViewComponent);
        }
        if (Annotation.SUBTYPE_POLYLINE.equals(name)) {
            return new PolyLineAnnotationComponent((MarkupAnnotation)annotation, documentViewController, abstractPageViewComponent);
        }
        if (Annotation.SUBTYPE_SQUARE.equals(name)) {
            return new SquareAnnotationComponent((SquareAnnotation)annotation, documentViewController, abstractPageViewComponent);
        }
        if (Annotation.SUBTYPE_POPUP.equals(name)) {
            return new PopupAnnotationComponent((PopupAnnotation)annotation, documentViewController, abstractPageViewComponent);
        }
        if (Annotation.SUBTYPE_TEXT.equals(name)) {
            return new TextAnnotationComponent((TextAnnotation)annotation, documentViewController, abstractPageViewComponent);
        }
        if (Annotation.SUBTYPE_INK.equals(name)) {
            return new InkAnnotationComponent((InkAnnotation)annotation, documentViewController, abstractPageViewComponent);
        }
        if (Annotation.SUBTYPE_FREE_TEXT.equals(name)) {
            return new FreeTextAnnotationComponent((FreeTextAnnotation)annotation, documentViewController, abstractPageViewComponent);
        }
        if (!Annotation.SUBTYPE_WIDGET.equals(name)) return new AbstractAnnotationComponent<Annotation>(annotation, documentViewController, abstractPageViewComponent){
            private static final long serialVersionUID = 409696785049691125L;

            @Override
            public void resetAppearanceShapes() {
            }

            @Override
            public void paintComponent(Graphics graphics) {
            }

            @Override
            public boolean isActive() {
                return false;
            }
        };
        AbstractWidgetAnnotation abstractWidgetAnnotation = (AbstractWidgetAnnotation)annotation;
        Name name2 = abstractWidgetAnnotation.getFieldDictionary().getFieldType();
        if (FieldDictionaryFactory.TYPE_BUTTON.equals(name2)) {
            ButtonWidgetAnnotation buttonWidgetAnnotation = AbstractButtonComponent.getButtonWidgetAnnotation(annotation);
            ButtonFieldDictionary buttonFieldDictionary = buttonWidgetAnnotation.getFieldDictionary();
            ButtonFieldDictionary.ButtonFieldType buttonFieldType = buttonFieldDictionary.getButtonFieldType();
            if (buttonFieldType == ButtonFieldDictionary.ButtonFieldType.CHECK_BUTTON) {
                return new CheckButtonComponent(buttonWidgetAnnotation, documentViewController, abstractPageViewComponent);
            }
            if (buttonFieldType == ButtonFieldDictionary.ButtonFieldType.RADIO_BUTTON) {
                return new RadioButtonComponent(buttonWidgetAnnotation, documentViewController, abstractPageViewComponent);
            }
            if (buttonFieldType == ButtonFieldDictionary.ButtonFieldType.PUSH_BUTTON) {
                return new PushButtonComponent(buttonWidgetAnnotation, documentViewController, abstractPageViewComponent);
            }
            logger.warning("Unknown button type " + name2);
            return null;
        } else if (FieldDictionaryFactory.TYPE_CHOICE.equals(name2)) {
            ChoiceWidgetAnnotation choiceWidgetAnnotation = AbstractChoiceComponent.getButtonWidgetAnnotation(annotation);
            ChoiceFieldDictionary choiceFieldDictionary = choiceWidgetAnnotation.getFieldDictionary();
            ChoiceFieldDictionary.ChoiceFieldType choiceFieldType = choiceFieldDictionary.getChoiceFieldType();
            if (choiceFieldType == ChoiceFieldDictionary.ChoiceFieldType.CHOICE_COMBO || choiceFieldType == ChoiceFieldDictionary.ChoiceFieldType.CHOICE_EDITABLE_COMBO) {
                return new ChoiceComboComponent(choiceWidgetAnnotation, documentViewController, abstractPageViewComponent);
            }
            if (choiceFieldType == ChoiceFieldDictionary.ChoiceFieldType.CHOICE_LIST_SINGLE_SELECT || choiceFieldType == ChoiceFieldDictionary.ChoiceFieldType.CHOICE_LIST_MULTIPLE_SELECT) {
                return new ChoiceListComponent(choiceWidgetAnnotation, documentViewController, abstractPageViewComponent);
            }
            logger.warning("Unknown choice type " + name2);
            return null;
        } else {
            if (FieldDictionaryFactory.TYPE_TEXT.equals(name2)) {
                return new TextWidgetComponent((TextWidgetAnnotation)annotation, documentViewController, abstractPageViewComponent);
            }
            if (!FieldDictionaryFactory.TYPE_SIGNATURE.equals(name2)) return new WidgetAnnotationComponent((AbstractWidgetAnnotation)annotation, documentViewController, abstractPageViewComponent);
            return new SignatureComponent((SignatureWidgetAnnotation)annotation, documentViewController, abstractPageViewComponent);
        }
    }
}

