/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.search;

import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.JCheckBoxMenuItem;
import org.icepdf.ri.common.DropDownButton;
import org.icepdf.ri.common.PersistentJCheckBoxMenuItem;
import org.icepdf.ri.common.SwingViewBuilder;
import org.icepdf.ri.common.utility.search.BaseSearchModel;
import org.icepdf.ri.common.utility.search.SearchTextTask;
import org.icepdf.ri.common.utility.search.SimpleSearchHelper;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.images.Images;

public class SearchFilterButton
extends DropDownButton {
    private final JCheckBoxMenuItem wholePageCheckbox;
    private final JCheckBoxMenuItem wholeWordCheckbox;
    private final JCheckBoxMenuItem regexCheckbox;
    private final JCheckBoxMenuItem caseSensitiveCheckbox;
    private final JCheckBoxMenuItem cumulativeCheckbox;
    private final JCheckBoxMenuItem textCheckbox;
    private final JCheckBoxMenuItem formsCheckbox;
    private final JCheckBoxMenuItem commentsCheckbox;
    private final JCheckBoxMenuItem destinationsCheckbox;
    private final JCheckBoxMenuItem outlinesCheckbox;
    private final JCheckBoxMenuItem showPagesCheckbox;

    public SearchFilterButton(BaseSearchModel baseSearchModel, Controller controller, String string) {
        super(controller, "", controller.getMessageBundle().getString(string), "filter", Images.getDefaultIconSizeOr(controller.getPropertiesManager(), Images.IconSize.LARGE), SwingViewBuilder.buildButtonFont());
        Preferences preferences = controller.getPropertiesManager().getPreferences();
        boolean bl = preferences.getBoolean("application.viewer.utility.search.whole.page.enabled", false);
        boolean bl2 = preferences.getBoolean("application.viewer.utility.search.regex.enabled", true);
        boolean bl3 = preferences.getBoolean("application.viewer.utility.search.whole.words.enabled", false);
        boolean bl4 = preferences.getBoolean("application.viewer.utility.search.case.sensitive.enabled", false);
        boolean bl5 = preferences.getBoolean("application.viewer.utility.search.case.cumulative.enabled", false);
        boolean bl6 = preferences.getBoolean("application.viewer.utility.search.case.text.enabled", true);
        boolean bl7 = preferences.getBoolean("application.viewer.utility.search.case.forms.enabled", true);
        boolean bl8 = preferences.getBoolean("application.viewer.utility.search.comments.cumulative.enabled", false);
        boolean bl9 = preferences.getBoolean("application.viewer.utility.search.case.destinations.enabled", false);
        boolean bl10 = preferences.getBoolean("application.viewer.utility.search.case.outlines.enabled", false);
        boolean bl11 = preferences.getBoolean("application.viewer.utility.search.case.pages.enabled", true);
        ResourceBundle resourceBundle = controller.getMessageBundle();
        this.wholePageCheckbox = new PersistentJCheckBoxMenuItem(resourceBundle.getString("viewer.utilityPane.search.wholePageCheckbox.label"), bl);
        this.wholePageCheckbox.addActionListener(actionEvent -> {
            baseSearchModel.notifySearchFiltersChanged();
            preferences.putBoolean("application.viewer.utility.search.whole.page.enabled", this.isWholePage());
        });
        this.wholeWordCheckbox = new PersistentJCheckBoxMenuItem(resourceBundle.getString("viewer.utilityPane.search.wholeWordCheckbox.label"), bl3);
        this.wholeWordCheckbox.addActionListener(actionEvent -> {
            this.getRegexCheckbox().setEnabled(!this.isWholeWord());
            baseSearchModel.notifySearchFiltersChanged();
            preferences.putBoolean("application.viewer.utility.search.whole.words.enabled", this.isWholeWord());
        });
        this.regexCheckbox = new PersistentJCheckBoxMenuItem(resourceBundle.getString("viewer.utilityPane.search.regexCheckbox.label"), bl2);
        this.regexCheckbox.addActionListener(actionEvent -> {
            this.getWholeWordCheckbox().setEnabled(!this.isRegex());
            this.wholePageCheckbox.setEnabled(!this.isRegex());
            this.wholePageCheckbox.setSelected(this.isWholePage() || this.isRegex());
            baseSearchModel.notifySearchFiltersChanged();
            preferences.putBoolean("application.viewer.utility.search.regex.enabled", this.isRegex());
        });
        this.caseSensitiveCheckbox = new PersistentJCheckBoxMenuItem(resourceBundle.getString("viewer.utilityPane.search.caseSenstiveCheckbox.label"), bl4);
        this.caseSensitiveCheckbox.addActionListener(actionEvent -> {
            baseSearchModel.notifySearchFiltersChanged();
            preferences.putBoolean("application.viewer.utility.search.case.pages.enabled", this.isShowPages());
        });
        if (bl2 || bl3) {
            this.regexCheckbox.setEnabled(bl2);
            this.wholeWordCheckbox.setEnabled(bl3);
        }
        this.cumulativeCheckbox = new PersistentJCheckBoxMenuItem(resourceBundle.getString("viewer.utilityPane.search.cumlitiveCheckbox.label"), bl5);
        this.cumulativeCheckbox.addActionListener(actionEvent -> {
            baseSearchModel.notifySearchFiltersChanged();
            preferences.putBoolean("application.viewer.utility.search.case.cumulative.enabled", this.isCumulative());
        });
        this.textCheckbox = new PersistentJCheckBoxMenuItem(resourceBundle.getString("viewer.utilityPane.search.text.label"), bl6);
        this.textCheckbox.addActionListener(actionEvent -> {
            baseSearchModel.notifySearchFiltersChanged();
            preferences.putBoolean("application.viewer.utility.search.case.text.enabled", this.isText());
        });
        this.formsCheckbox = new PersistentJCheckBoxMenuItem(resourceBundle.getString("viewer.utilityPane.search.forms.label"), bl6);
        this.formsCheckbox.addActionListener(actionEvent -> {
            baseSearchModel.notifySearchFiltersChanged();
            preferences.putBoolean("application.viewer.utility.search.case.forms.enabled", this.isForms());
        });
        this.commentsCheckbox = new PersistentJCheckBoxMenuItem(resourceBundle.getString("viewer.utilityPane.search.comments.label"), bl8);
        this.commentsCheckbox.addActionListener(actionEvent -> {
            baseSearchModel.notifySearchFiltersChanged();
            preferences.putBoolean("application.viewer.utility.search.comments.cumulative.enabled", this.isComments());
        });
        this.destinationsCheckbox = new PersistentJCheckBoxMenuItem(resourceBundle.getString("viewer.utilityPane.search.destinations.label"), bl9);
        this.destinationsCheckbox.addActionListener(actionEvent -> {
            baseSearchModel.notifySearchFiltersChanged();
            preferences.putBoolean("application.viewer.utility.search.case.destinations.enabled", this.isDestinations());
        });
        this.outlinesCheckbox = new PersistentJCheckBoxMenuItem(resourceBundle.getString("viewer.utilityPane.search.outlines.label"), bl10);
        this.outlinesCheckbox.addActionListener(actionEvent -> {
            baseSearchModel.notifySearchFiltersChanged();
            preferences.putBoolean("application.viewer.utility.search.case.outlines.enabled", this.isOutlines());
        });
        this.showPagesCheckbox = new PersistentJCheckBoxMenuItem(resourceBundle.getString("viewer.utilityPane.search.showPagesCheckbox.label"), bl11);
        this.showPagesCheckbox.addActionListener(actionEvent -> {
            baseSearchModel.notifySearchFiltersChanged();
            preferences.putBoolean("application.viewer.utility.search.case.pages.enabled", this.isShowPages());
        });
        this.add(this.wholePageCheckbox);
        if (string.contains("utilityPane")) {
            this.add(this.regexCheckbox);
            this.add(this.wholeWordCheckbox);
            this.add(this.caseSensitiveCheckbox);
            this.add(this.cumulativeCheckbox);
            this.addSeparator();
            this.add(this.textCheckbox);
            this.add(this.formsCheckbox);
            this.add(this.commentsCheckbox);
            this.add(this.outlinesCheckbox);
            this.add(this.destinationsCheckbox);
            this.addSeparator();
            this.add(this.showPagesCheckbox);
        } else {
            this.add(this.wholeWordCheckbox);
            this.add(this.caseSensitiveCheckbox);
            this.add(this.commentsCheckbox);
        }
    }

    public JCheckBoxMenuItem getWholePageCheckbox() {
        return this.wholePageCheckbox;
    }

    public JCheckBoxMenuItem getWholeWordCheckbox() {
        return this.wholeWordCheckbox;
    }

    public JCheckBoxMenuItem getRegexCheckbox() {
        return this.regexCheckbox;
    }

    public JCheckBoxMenuItem getCaseSensitiveCheckbox() {
        return this.caseSensitiveCheckbox;
    }

    public JCheckBoxMenuItem getCumulativeCheckbox() {
        return this.cumulativeCheckbox;
    }

    public JCheckBoxMenuItem getTextCheckbox() {
        return this.textCheckbox;
    }

    public JCheckBoxMenuItem getFormsCheckbox() {
        return this.formsCheckbox;
    }

    public JCheckBoxMenuItem getCommentsCheckbox() {
        return this.commentsCheckbox;
    }

    public JCheckBoxMenuItem getDestinationsCheckbox() {
        return this.destinationsCheckbox;
    }

    public JCheckBoxMenuItem getOutlinesCheckbox() {
        return this.outlinesCheckbox;
    }

    public JCheckBoxMenuItem getShowPagesCheckbox() {
        return this.showPagesCheckbox;
    }

    public boolean isWholePage() {
        return this.wholePageCheckbox.isSelected();
    }

    public boolean isWholeWord() {
        return this.wholeWordCheckbox.isSelected();
    }

    public boolean isRegex() {
        return this.regexCheckbox.isSelected();
    }

    public boolean isCaseSensitive() {
        return this.caseSensitiveCheckbox.isSelected();
    }

    public boolean isCumulative() {
        return this.cumulativeCheckbox.isSelected();
    }

    public boolean isText() {
        return this.textCheckbox.isSelected();
    }

    public boolean isForms() {
        return this.formsCheckbox.isSelected();
    }

    public boolean isComments() {
        return this.commentsCheckbox.isSelected();
    }

    public boolean isDestinations() {
        return this.destinationsCheckbox.isSelected();
    }

    public boolean isOutlines() {
        return this.outlinesCheckbox.isSelected();
    }

    public boolean isShowPages() {
        return this.showPagesCheckbox.isSelected();
    }

    public SearchTextTask getSearchTask(BaseSearchModel baseSearchModel, Controller controller, String string) {
        SearchTextTask.Builder builder = new SearchTextTask.Builder(controller, string);
        return builder.setSearchModel(baseSearchModel).setWholePage(this.isWholePage()).setCaseSensitive(this.isCaseSensitive()).setWholeWord(this.isWholeWord()).setCumulative(this.isCumulative()).setShowPages(this.isShowPages()).setRegex(this.isRegex()).setText(this.isText()).setForms(this.isForms()).setDestinations(this.isDestinations()).setOutlines(this.isOutlines()).setComments(this.isComments()).build();
    }

    public SimpleSearchHelper getSimpleSearchHelper(Controller controller, String string) {
        SimpleSearchHelper.Builder builder = new SimpleSearchHelper.Builder(controller, string);
        return builder.setCaseSensitive(this.isCaseSensitive()).setWholePage(this.isWholePage()).setWholeWord(this.isWholeWord()).setComments(this.isComments()).build();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Arrays.stream(this.getComponents()).forEach(component -> component.setEnabled(bl));
    }
}

