/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation.properties;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.icepdf.core.pobjects.actions.Action;
import org.icepdf.core.pobjects.actions.ActionFactory;
import org.icepdf.core.pobjects.actions.GoToAction;
import org.icepdf.core.pobjects.actions.LaunchAction;
import org.icepdf.core.pobjects.actions.URIAction;
import org.icepdf.core.pobjects.annotations.LinkAnnotation;
import org.icepdf.core.util.Library;
import org.icepdf.ri.common.utility.annotation.properties.AnnotationPanelAdapter;
import org.icepdf.ri.common.utility.annotation.properties.GoToActionDialog;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.Controller;

public class ActionsPanel
extends AnnotationPanelAdapter
implements ListSelectionListener,
ActionListener {
    private static final Logger logger = Logger.getLogger(ActionsPanel.class.toString());
    private DefaultListModel<ActionEntry> actionListModel;
    private JList<ActionEntry> actionList;
    private JButton addAction;
    private JButton editAction;
    private JButton removeAction;
    private final String uriActionLabel;
    private final String goToActionLabel;
    private final String launchActionLabel;
    private GoToActionDialog goToActionDialog;

    public ActionsPanel(Controller controller) {
        super(controller);
        this.setLayout(new GridLayout(2, 1, 5, 5));
        this.setFocusable(true);
        this.createGUI();
        this.setEnabled(false);
        String string = this.messageBundle.getString("viewer.utilityPane.action.type.destination.label");
        this.uriActionLabel = this.messageBundle.getString("viewer.utilityPane.action.type.uriAction.label");
        this.goToActionLabel = this.messageBundle.getString("viewer.utilityPane.action.type.goToAction.label");
        this.launchActionLabel = this.messageBundle.getString("viewer.utilityPane.action.type.launchAction.label");
    }

    @Override
    public void setAnnotationComponent(AnnotationComponent annotationComponent) {
        this.currentAnnotationComponent = annotationComponent;
        this.actionListModel.clear();
        if (annotationComponent.getAnnotation() != null && annotationComponent.getAnnotation().getAction() != null) {
            this.addActionToList(annotationComponent.getAnnotation().getAction());
            if (this.actionListModel.size() > 0) {
                this.actionList.setSelectedIndex(0);
            }
        }
        this.refreshActionCrud();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.currentAnnotationComponent == null) {
            logger.warning("No annotation was selected, edit is not possible.");
            return;
        }
        if (object == this.addAction) {
            this.addAction();
        } else if (object == this.editAction) {
            this.editAction();
        } else if (object == this.removeAction) {
            int n = JOptionPane.showConfirmDialog(this.controller.getViewerFrame(), this.messageBundle.getString("viewer.utilityPane.action.dialog.delete.msgs"), this.messageBundle.getString("viewer.utilityPane.action.dialog.delete.title"), 0);
            if (0 == n) {
                this.removeAction();
            }
            this.refreshActionCrud();
        }
        this.updateCurrentAnnotation();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (this.actionList.getSelectedIndex() == -1) {
                this.addAction.setEnabled(false);
                this.editAction.setEnabled(false);
                this.removeAction.setEnabled(false);
            } else {
                this.refreshActionCrud();
            }
        }
    }

    private void addAction() {
        LaunchAction launchAction;
        String string;
        Object[] objectArray = new Object[]{new ActionChoice(this.messageBundle.getString("viewer.utilityPane.action.type.goToAction.label"), 1), new ActionChoice(this.messageBundle.getString("viewer.utilityPane.action.type.launchAction.label"), 3), new ActionChoice(this.messageBundle.getString("viewer.utilityPane.action.type.uriAction.label"), 2)};
        ActionChoice actionChoice = (ActionChoice)JOptionPane.showInputDialog(this.controller.getViewerFrame(), this.messageBundle.getString("viewer.utilityPane.action.dialog.new.msgs"), this.messageBundle.getString("viewer.utilityPane.action.dialog.new.title"), -1, null, objectArray, null);
        if (actionChoice != null && actionChoice.getActionType() == 1) {
            this.showGoToActionDialog();
        } else if (actionChoice != null && actionChoice.getActionType() == 2) {
            URIAction uRIAction;
            String string2 = this.showURIActionDialog(null);
            if (string2 != null && this.currentAnnotationComponent != null && (uRIAction = (URIAction)ActionFactory.buildAction((Library)this.currentAnnotationComponent.getAnnotation().getLibrary(), (int)2)) != null) {
                uRIAction.setURI(string2);
                this.currentAnnotationComponent.getAnnotation().addAction((Action)uRIAction);
                this.actionListModel.addElement(new ActionEntry(this.messageBundle.getString("viewer.utilityPane.action.type.uriAction.label"), (Action)uRIAction));
            }
        } else if (actionChoice != null && actionChoice.getActionType() == 3 && (string = this.showLaunchActionDialog(null)) != null && this.currentAnnotationComponent != null && (launchAction = (LaunchAction)ActionFactory.buildAction((Library)this.currentAnnotationComponent.getAnnotation().getLibrary(), (int)3)) != null) {
            launchAction.setExternalFile(string);
            this.currentAnnotationComponent.getAnnotation().addAction((Action)launchAction);
            this.actionListModel.addElement(new ActionEntry(this.messageBundle.getString("viewer.utilityPane.action.type.launchAction.label"), (Action)launchAction));
        }
    }

    private void editAction() {
        String string;
        String string2;
        URIAction uRIAction;
        ActionEntry actionEntry = this.actionListModel.getElementAt(this.actionList.getSelectedIndex());
        Action action = actionEntry.getAction();
        if (action instanceof URIAction) {
            uRIAction = (URIAction)action;
            string2 = uRIAction.getURI();
            string = this.showURIActionDialog(string2);
            if (string != null && !string2.equals(string)) {
                uRIAction.setURI(string);
                this.currentAnnotationComponent.getAnnotation().updateAction((Action)uRIAction);
            }
        } else if (action instanceof GoToAction || action == null) {
            this.showGoToActionDialog();
        }
        if (action instanceof LaunchAction && (string = this.showLaunchActionDialog(string2 = (uRIAction = (LaunchAction)action).getExternalFile())) != null && !string2.equals(string)) {
            uRIAction.setExternalFile(string);
            this.currentAnnotationComponent.getAnnotation().updateAction((Action)uRIAction);
        }
    }

    private void removeAction() {
        ActionEntry actionEntry = this.actionListModel.getElementAt(this.actionList.getSelectedIndex());
        Action action = actionEntry.getAction();
        if (action != null) {
            boolean bl = this.currentAnnotationComponent.getAnnotation().deleteAction(action);
            if (bl) {
                this.actionListModel.removeElementAt(this.actionList.getSelectedIndex());
                this.actionList.setSelectedIndex(-1);
            }
        } else if (this.currentAnnotationComponent.getAnnotation() instanceof LinkAnnotation) {
            LinkAnnotation linkAnnotation = (LinkAnnotation)this.currentAnnotationComponent.getAnnotation();
            linkAnnotation.getEntries().remove((Object)LinkAnnotation.DESTINATION_KEY);
            this.updateCurrentAnnotation();
            this.actionListModel.removeElementAt(this.actionList.getSelectedIndex());
            this.actionList.setSelectedIndex(-1);
        }
    }

    private String showURIActionDialog(String string) {
        return (String)JOptionPane.showInputDialog(this.controller.getViewerFrame(), this.messageBundle.getString("viewer.utilityPane.action.dialog.uri.msgs"), this.messageBundle.getString("viewer.utilityPane.action.dialog.uri.title"), -1, null, null, string);
    }

    private String showLaunchActionDialog(String string) {
        return (String)JOptionPane.showInputDialog(this.controller.getViewerFrame(), this.messageBundle.getString("viewer.utilityPane.action.dialog.launch.msgs"), this.messageBundle.getString("viewer.utilityPane.action.dialog.launch.title"), -1, null, null, string);
    }

    private void showGoToActionDialog() {
        if (this.goToActionDialog != null) {
            this.goToActionDialog.dispose();
        }
        this.goToActionDialog = new GoToActionDialog(this.controller, this);
        this.goToActionDialog.setAnnotationComponent(this.currentAnnotationComponent);
        this.goToActionDialog.setVisible(true);
    }

    private void refreshActionCrud() {
        this.addAction.setEnabled(this.actionListModel.getSize() == 0);
        this.editAction.setEnabled(this.actionListModel.getSize() > 0);
        this.removeAction.setEnabled(this.actionListModel.getSize() > 0);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.actionList.setEnabled(bl);
        this.actionList.setSelectedIndex(-1);
        boolean bl2 = this.actionList.getSelectedIndex() != -1;
        this.addAction.setEnabled(bl && this.actionListModel.getSize() == 0);
        this.editAction.setEnabled(bl && bl2);
        this.removeAction.setEnabled(bl && bl2);
    }

    private void createGUI() {
        this.setBorder(new TitledBorder(new EtchedBorder(1), this.messageBundle.getString("viewer.utilityPane.action.selectionTitle"), 1, 0));
        this.actionListModel = new DefaultListModel();
        this.actionList = new JList<ActionEntry>(this.actionListModel);
        this.actionList.setSelectionMode(1);
        this.actionList.setVisibleRowCount(-1);
        this.actionList.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.actionList);
        jScrollPane.setPreferredSize(new Dimension(150, 50));
        this.add(jScrollPane);
        this.addAction = new JButton(this.messageBundle.getString("viewer.utilityPane.action.addAction"));
        this.addAction.setEnabled(false);
        this.addAction.addActionListener(this);
        this.editAction = new JButton(this.messageBundle.getString("viewer.utilityPane.action.editAction"));
        this.editAction.setEnabled(false);
        this.editAction.addActionListener(this);
        this.removeAction = new JButton(this.messageBundle.getString("viewer.utilityPane.action.removeAction"));
        this.removeAction.setEnabled(false);
        this.removeAction.addActionListener(this);
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.addAction);
        jPanel.add(this.editAction);
        jPanel.add(this.removeAction);
        this.add(jPanel);
        this.revalidate();
    }

    public void clearActionList() {
        this.actionListModel.clear();
    }

    public void addActionToList(Action action) {
        if (action instanceof GoToAction) {
            this.actionListModel.addElement(new ActionEntry(this.goToActionLabel, action));
        } else if (action instanceof URIAction) {
            this.actionListModel.addElement(new ActionEntry(this.uriActionLabel, action));
        } else if (action instanceof LaunchAction) {
            this.actionListModel.addElement(new ActionEntry(this.launchActionLabel, action));
        }
    }

    static class ActionChoice {
        final String title;
        final int actionType;

        ActionChoice(String string, int n) {
            this.actionType = n;
            this.title = string;
        }

        int getActionType() {
            return this.actionType;
        }

        public String toString() {
            return this.title;
        }
    }

    static class ActionEntry {
        final String title;
        Action action;

        ActionEntry(String string) {
            this.title = string;
        }

        ActionEntry(String string, Action action) {
            this.action = action;
            this.title = string;
        }

        Action getAction() {
            return this.action;
        }

        public String toString() {
            return this.title;
        }
    }
}

