/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.tools.DestinationHandler;
import org.icepdf.ri.common.tools.HighLightAnnotationHandler;
import org.icepdf.ri.common.tools.StrikeOutAnnotationHandler;
import org.icepdf.ri.common.tools.TextSelection;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.tools.UnderLineAnnotationHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.PageViewComponentImpl;
import org.icepdf.ri.images.IconPack;
import org.icepdf.ri.images.Images;

public class TextSelectionViewHandler
extends TextSelection
implements ToolHandler,
MouseWheelListener {
    protected static final Logger logger = Logger.getLogger(TextSelectionViewHandler.class.toString());
    protected final JComponent parentComponent;
    protected boolean isDragging;
    protected boolean isSelecting;

    public TextSelectionViewHandler(DocumentViewController documentViewController, JComponent jComponent) {
        super(documentViewController, null);
        this.parentComponent = jComponent;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.documentViewController.clearSelectedText();
            this.clearSelectionState();
            PageViewComponentImpl pageViewComponentImpl = this.isOverPageComponent(this.parentComponent, mouseEvent);
            if (pageViewComponentImpl != null) {
                pageViewComponentImpl.requestFocus();
                MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(this.parentComponent, mouseEvent, pageViewComponentImpl);
                pageViewComponentImpl.getTextSelectionPageHandler().wordLineSelection(mouseEvent2.getClickCount(), mouseEvent2.getPoint(), pageViewComponentImpl);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl;
        if (mouseEvent.getButton() == 1) {
            this.documentViewController.clearSelectedText();
            this.clearSelectionState();
            this.isSelecting = true;
            this.lastMousePressedLocation = mouseEvent.getPoint();
            this.resetRectangle(mouseEvent.getX(), mouseEvent.getY());
            PageViewComponentImpl pageViewComponentImpl = this.isOverPageComponent(this.parentComponent, mouseEvent);
            if (pageViewComponentImpl != null) {
                pageViewComponentImpl.requestFocus();
                MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(this.parentComponent, mouseEvent, pageViewComponentImpl);
                pageViewComponentImpl.getTextSelectionPageHandler().selectionStart(mouseEvent2.getPoint(), pageViewComponentImpl, true);
            }
        } else if (mouseEvent.getButton() == 3 && (bl = this.documentViewController.getParentController().havePermissionToExtractContent()) && this.documentViewController.getSelectedText() != null && !this.documentViewController.getSelectedText().isEmpty()) {
            PageViewComponentImpl pageViewComponentImpl = this.isOverPageComponent(this.parentComponent, mouseEvent);
            JPopupMenu jPopupMenu = this.buildContextMenu(pageViewComponentImpl);
            jPopupMenu.show(this.parentComponent, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private Rectangle getSelectionBounds(PageViewComponentImpl pageViewComponentImpl) {
        ArrayList<Shape> arrayList = HighLightAnnotationHandler.getSelectedTextBounds(pageViewComponentImpl, this.getPageTransform(pageViewComponentImpl));
        GeneralPath generalPath = new GeneralPath();
        for (Shape shape : arrayList) {
            generalPath.append(shape, false);
        }
        return generalPath.getBounds();
    }

    protected JPopupMenu buildContextMenu(PageViewComponentImpl pageViewComponentImpl) {
        SwingController swingController = (SwingController)this.documentViewController.getParentController();
        boolean bl = swingController.havePermissionToModifyDocument();
        ResourceBundle resourceBundle = swingController.getMessageBundle();
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(swingController.getMessageBundle().getString("viewer.menu.edit.copy.label"));
        swingController.setCopyContextMenuItem(jMenuItem);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem(resourceBundle.getString("viewer.utilityPane.view.selectionTool.contextMenu.addDestination.label"));
        jMenuItem2.setEnabled(bl);
        Images.applyIcon(jMenuItem2, "destination", IconPack.Variant.NONE, Images.IconSize.MINI);
        jMenuItem2.addActionListener(actionEvent -> {
            Point point = this.getSelectionBounds(pageViewComponentImpl).getLocation();
            new DestinationHandler(swingController.getDocumentViewController(), pageViewComponentImpl).createNewDestination(swingController.getDocumentViewController().getSelectedText(), point.x, point.y);
        });
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem(resourceBundle.getString("viewer.annotation.popup.addAnnotation.hightlight.label"));
        jMenuItem3.setEnabled(bl);
        Images.applyIcon(jMenuItem3, "highlight_annot", IconPack.Variant.NORMAL, Images.IconSize.MINI);
        jMenuItem3.addActionListener(actionEvent -> new HighLightAnnotationHandler(swingController.getDocumentViewController(), pageViewComponentImpl).createMarkupAnnotation(null));
        jPopupMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem(resourceBundle.getString("viewer.annotation.popup.addAnnotation.underline.label"));
        jMenuItem4.setEnabled(bl);
        Images.applyIcon(jMenuItem4, "underline", IconPack.Variant.NORMAL, Images.IconSize.MINI);
        jMenuItem4.addActionListener(actionEvent -> new UnderLineAnnotationHandler(swingController.getDocumentViewController(), pageViewComponentImpl).createMarkupAnnotation(null));
        jPopupMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem(resourceBundle.getString("viewer.annotation.popup.addAnnotation.strikeout.label"));
        jMenuItem5.setEnabled(bl);
        Images.applyIcon(jMenuItem5, "strikeout", IconPack.Variant.NORMAL, Images.IconSize.MINI);
        jMenuItem5.addActionListener(actionEvent -> new StrikeOutAnnotationHandler(swingController.getDocumentViewController(), pageViewComponentImpl).createMarkupAnnotation(null));
        jPopupMenu.add(jMenuItem5);
        return jPopupMenu;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.isDragging = false;
        this.isSelecting = false;
        ArrayList<AbstractPageViewComponent> arrayList = this.documentViewController.getDocumentViewModel().getSelectedPageText();
        PageViewComponentImpl pageViewComponentImpl = this.isOverPageComponent(this.parentComponent, mouseEvent);
        if (pageViewComponentImpl != null) {
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(this.parentComponent, mouseEvent, pageViewComponentImpl);
            if (arrayList != null && arrayList.size() > 0) {
                for (AbstractPageViewComponent abstractPageViewComponent : arrayList) {
                    PageViewComponentImpl pageViewComponentImpl2 = (PageViewComponentImpl)abstractPageViewComponent;
                    if (pageViewComponentImpl2 == null) continue;
                    pageViewComponentImpl2.getTextSelectionPageHandler().selectionEnd(mouseEvent2.getPoint(), pageViewComponentImpl2);
                }
            }
        }
        if (arrayList != null && arrayList.size() > 0) {
            this.documentViewController.firePropertyChange("textSelected", null, null);
        }
        this.clearRectangle(this.parentComponent);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.isDragging) {
            Component component = this.documentViewController.getViewPort().getView();
            Point point = SwingUtilities.convertPoint(mouseWheelEvent.getComponent(), mouseWheelEvent.getPoint(), component);
            MouseEvent mouseEvent = new MouseEvent(component, 0, mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiersEx(), point.x, point.y, mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getButton());
            this.mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.documentViewController != null && this.isSelecting) {
            this.isDragging = true;
            this.updateSelectionSize(mouseEvent.getX(), mouseEvent.getY(), this.parentComponent);
            DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
            documentViewModel.clearSelectedPageText();
            List<AbstractPageViewComponent> list = documentViewModel.getPageComponents();
            for (AbstractPageViewComponent abstractPageViewComponent : list) {
                Rectangle rectangle = SwingUtilities.convertRectangle(this.parentComponent, this.getRectToDraw(), abstractPageViewComponent);
                if (abstractPageViewComponent.getBounds().intersects(rectangle)) {
                    documentViewModel.addSelectedPageText(abstractPageViewComponent);
                    Point point = SwingUtilities.convertPoint(this.parentComponent, mouseEvent.getPoint(), abstractPageViewComponent);
                    abstractPageViewComponent.setSelectionRectangle(point, rectangle);
                    ((PageViewComponentImpl)abstractPageViewComponent).getTextSelectionPageHandler().setRectToDraw(rectangle);
                    boolean bl = this.lastMousePressedLocation.y <= mouseEvent.getPoint().y;
                    boolean bl2 = this.lastMousePressedLocation.x <= mouseEvent.getPoint().x;
                    ((PageViewComponentImpl)abstractPageViewComponent).getTextSelectionPageHandler().selection(point, abstractPageViewComponent, bl, bl2);
                    continue;
                }
                documentViewModel.removeSelectedPageText(abstractPageViewComponent);
                abstractPageViewComponent.clearSelectedText();
                abstractPageViewComponent.repaint();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        PageViewComponentImpl pageViewComponentImpl = this.isOverPageComponent(this.parentComponent, mouseEvent);
        if (pageViewComponentImpl != null) {
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(this.parentComponent, mouseEvent, pageViewComponentImpl);
            pageViewComponentImpl.getTextSelectionPageHandler().selectionTextSelectIcon(mouseEvent2.getPoint(), pageViewComponentImpl);
        }
    }

    @Override
    public void paintTool(Graphics graphics) {
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

