/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.graphics.text.GlyphText;
import org.icepdf.core.pobjects.graphics.text.LineText;
import org.icepdf.core.pobjects.graphics.text.PageText;
import org.icepdf.core.pobjects.graphics.text.WordText;
import org.icepdf.core.util.Defs;
import org.icepdf.ri.common.tools.GlyphLocation;
import org.icepdf.ri.common.tools.SelectionBoxHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.PageViewComponentImpl;

public class TextSelection
extends SelectionBoxHandler {
    protected static final Logger logger = Logger.getLogger(TextSelection.class.toString());
    public int selectedCount;
    protected Point lastMousePressedLocation;
    protected Point lastMouseLocation;
    private GlyphLocation glyphStartLocation;
    private GlyphLocation glyphEndLocation;
    private GlyphLocation lastGlyphStartLocation;
    private GlyphLocation lastGlyphEndLocation;
    protected int topMargin = 75;
    protected int bottomMargin = 75;
    protected static boolean enableMarginExclusion;
    protected static boolean enableMarginExclusionBorder;
    protected Rectangle2D topMarginExclusion;
    protected Rectangle2D bottomMarginExclusion;
    protected Page pageLock;
    private boolean isFirst;

    public TextSelection(DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(documentViewController, abstractPageViewComponent);
    }

    @Override
    protected void checkAndApplyPreferences() {
    }

    public void wordLineSelection(int n, Point point, AbstractPageViewComponent abstractPageViewComponent) {
        try {
            if (n == 3) {
                Page page = abstractPageViewComponent.getPage();
                Point point2 = (Point)point.clone();
                this.lineSelectHandler(page, point2);
            } else if (n == 2) {
                Page page = abstractPageViewComponent.getPage();
                Point point3 = (Point)point.clone();
                this.wordSelectHandler(page, point3);
            }
            if (abstractPageViewComponent != null) {
                abstractPageViewComponent.requestFocus();
            }
        }
        catch (InterruptedException interruptedException) {
            logger.fine("Text selection page access interrupted");
        }
    }

    public void selectionStart(Point point, AbstractPageViewComponent abstractPageViewComponent, boolean bl) {
        try {
            Page page = abstractPageViewComponent.getPage();
            this.isFirst = bl;
            if (page != null) {
                PageText pageText = page.getViewText();
                this.calculateTextSelectionExclusion();
                ArrayList arrayList = pageText.getPageLines();
                Point2D.Float float_ = this.convertToPageSpace(point);
                this.glyphStartLocation = GlyphLocation.findGlyphLocation(arrayList, float_, true, true, null, this.topMarginExclusion, this.bottomMarginExclusion);
                this.glyphEndLocation = null;
            }
            this.currentRect = new Rectangle(point.x, point.y, 0, 0);
            this.updateDrawableRect(abstractPageViewComponent.getWidth(), abstractPageViewComponent.getHeight());
            abstractPageViewComponent.repaint();
        }
        catch (InterruptedException interruptedException) {
            logger.fine("Text selection page access interrupted");
        }
    }

    public void selectionEnd(Point point, AbstractPageViewComponent abstractPageViewComponent) {
        try {
            Page page;
            if (abstractPageViewComponent != null && logger.isLoggable(Level.FINE) && (page = abstractPageViewComponent.getPage()).getViewText() != null) {
                logger.fine(page.getViewText().getSelected().toString());
            }
            if (this.selectedCount > 0) {
                this.documentViewController.getDocumentViewModel().addSelectedPageText(abstractPageViewComponent);
                this.documentViewController.firePropertyChange("textSelected", null, null);
            }
            this.clearRectangle(abstractPageViewComponent);
            abstractPageViewComponent.repaint();
        }
        catch (InterruptedException interruptedException) {
            logger.fine("Text selection page access interrupted");
        }
    }

    public void clearSelection() {
        this.pageLock = null;
        this.lastGlyphStartLocation = null;
        this.lastGlyphEndLocation = null;
        this.glyphStartLocation = null;
        this.glyphEndLocation = null;
        this.selectedCount = 0;
    }

    public void clearSelectionState() {
        List<AbstractPageViewComponent> list = this.documentViewController.getDocumentViewModel().getPageComponents();
        for (AbstractPageViewComponent abstractPageViewComponent : list) {
            ((PageViewComponentImpl)abstractPageViewComponent).getTextSelectionPageHandler().clearSelection();
        }
    }

    public void selection(Point point, AbstractPageViewComponent abstractPageViewComponent, boolean bl, boolean bl2) {
        try {
            if (abstractPageViewComponent != null) {
                this.pageLock = abstractPageViewComponent.getPage();
                boolean bl3 = this.lastMouseLocation != null ? this.lastMouseLocation.y <= point.y : bl;
                this.multiLineSelectHandler(abstractPageViewComponent, point, bl, bl3, bl2);
                this.lastMouseLocation = point;
            }
        }
        catch (InterruptedException interruptedException) {
            logger.fine("Text selection page access interrupted");
        }
    }

    public boolean selectionTextSelectIcon(Point point, AbstractPageViewComponent abstractPageViewComponent) {
        boolean bl = false;
        try {
            PageText pageText;
            Page page = abstractPageViewComponent.getPage();
            if (page != null && (pageText = page.getViewText()) != null) {
                this.calculateTextSelectionExclusion();
                ArrayList arrayList = pageText.getPageLines();
                if (arrayList != null) {
                    Point2D.Float float_ = this.convertToPageSpace(point);
                    for (LineText lineText : arrayList) {
                        if (!lineText.getBounds().contains(float_) || this.topMarginExclusion != null && this.bottomMarginExclusion != null && (this.topMarginExclusion.contains(float_) || this.bottomMarginExclusion.contains(float_))) continue;
                        bl = true;
                        this.documentViewController.setViewCursor(10);
                        break;
                    }
                    if (!bl) {
                        this.documentViewController.setViewCursor(7);
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            logger.fine("Text selection page access interrupted");
        }
        return bl;
    }

    protected void calculateTextSelectionExclusion() {
        if (enableMarginExclusion) {
            Rectangle2D.Float float_ = this.pageViewComponent.getPage().getCropBox();
            this.topMarginExclusion = new Rectangle2D.Float((int)((RectangularShape)float_).getX(), (int)((RectangularShape)float_).getY() - this.topMargin, (int)((RectangularShape)float_).getWidth(), this.topMargin);
            this.bottomMarginExclusion = new Rectangle2D.Float((int)((RectangularShape)float_).getX(), (int)(((RectangularShape)float_).getY() - ((RectangularShape)float_).getHeight()), (int)((RectangularShape)float_).getWidth(), this.bottomMargin);
        }
    }

    public static void paintSelectedText(Graphics graphics, AbstractPageViewComponent abstractPageViewComponent, DocumentViewModel documentViewModel) throws InterruptedException {
        PageText pageText;
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
        graphics2D.setColor(Page.selectionColor);
        graphics2D.setStroke(new BasicStroke(1.0f));
        Page page = abstractPageViewComponent.getPage();
        if (page != null && (pageText = page.getViewText()) != null) {
            AffineTransform affineTransform2 = page.getPageTransform(documentViewModel.getPageBoundary(), documentViewModel.getViewRotation(), documentViewModel.getViewZoom());
            ArrayList arrayList = pageText.getPageLines();
            if (arrayList != null) {
                for (LineText lineText : arrayList) {
                    for (WordText wordText : lineText.getWords()) {
                        GeneralPath generalPath;
                        if (wordText.isSelected() || wordText.isHighlighted()) {
                            generalPath = new GeneralPath(wordText.getBounds());
                            generalPath.transform(affineTransform2);
                            if (wordText.isSelected()) {
                                graphics2D.setColor(Page.selectionColor);
                                graphics2D.fill(generalPath);
                            }
                            if (!wordText.isHighlighted()) continue;
                            if (wordText.isHighlightCursor()) {
                                graphics2D.setColor(Page.highlightCursorColor);
                            } else {
                                graphics2D.setColor(wordText.getHighlightColor());
                            }
                            graphics2D.fill(generalPath);
                            continue;
                        }
                        for (GlyphText glyphText : wordText.getGlyphs()) {
                            if (!glyphText.isSelected()) continue;
                            generalPath = new GeneralPath(glyphText.getBounds());
                            generalPath.transform(affineTransform2);
                            graphics2D.setColor(Page.selectionColor);
                            graphics2D.fill(generalPath);
                        }
                    }
                }
            }
        }
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics2D.setTransform(affineTransform);
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
    }

    protected void paintTextBounds(Graphics graphics) throws InterruptedException {
        ArrayList arrayList;
        Page page = this.pageViewComponent.getPage();
        AffineTransform affineTransform = this.getPageTransform();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = graphics.getColor();
        graphics.setColor(Color.red);
        PageText pageText = page.getViewText();
        if (pageText != null && (arrayList = pageText.getPageLines()) != null) {
            for (LineText lineText : arrayList) {
                for (WordText wordText : lineText.getWords()) {
                    for (GlyphText glyphText : wordText.getGlyphs()) {
                        graphics.setColor(Color.black);
                        GeneralPath generalPath = new GeneralPath(glyphText.getBounds());
                        generalPath.transform(affineTransform);
                        graphics2D.draw(generalPath);
                    }
                }
                graphics.setColor(Color.red);
                GeneralPath generalPath = new GeneralPath(lineText.getBounds());
                generalPath.transform(affineTransform);
                graphics2D.draw(generalPath);
            }
        }
        graphics.setColor(color);
    }

    protected void multiLineSelectHandler(AbstractPageViewComponent abstractPageViewComponent, Point point, boolean bl, boolean bl2, boolean bl3) throws InterruptedException {
        Page page = abstractPageViewComponent.getPage();
        this.selectedCount = 0;
        if (page != null) {
            PageText pageText = page.getViewText();
            if (pageText != null) {
                pageText.clearSelected();
                ArrayList arrayList = pageText.getPageLines();
                this.calculateTextSelectionExclusion();
                Point2D.Float float_ = this.convertToPageSpace(point);
                if (this.glyphStartLocation == null) {
                    this.glyphStartLocation = GlyphLocation.findFirstGlyphLocation(arrayList, float_, bl, bl2, this.lastGlyphEndLocation, this.topMarginExclusion, this.bottomMarginExclusion);
                    if (this.glyphStartLocation != null) {
                        this.glyphEndLocation = new GlyphLocation(this.glyphStartLocation);
                        this.isFirst = false;
                    }
                } else {
                    this.glyphEndLocation = GlyphLocation.findGlyphLocation(arrayList, float_, bl, bl2, this.lastGlyphEndLocation, this.topMarginExclusion, this.bottomMarginExclusion);
                }
                boolean bl4 = true;
                if (this.glyphStartLocation != null && this.glyphEndLocation != null) {
                    this.selectedCount = GlyphLocation.highLightGlyphs(arrayList, this.glyphStartLocation, this.glyphEndLocation, bl4, bl, bl2, bl3, this.topMarginExclusion, this.bottomMarginExclusion);
                    this.lastGlyphStartLocation = this.glyphStartLocation;
                    this.lastGlyphEndLocation = this.glyphEndLocation;
                } else if (this.lastGlyphStartLocation != null && this.lastGlyphEndLocation != null) {
                    this.selectedCount = GlyphLocation.highLightGlyphs(arrayList, this.lastGlyphStartLocation, this.lastGlyphEndLocation, bl4, bl, bl2, bl3, this.topMarginExclusion, this.bottomMarginExclusion);
                }
            }
            abstractPageViewComponent.repaint();
        }
    }

    protected void wordSelectHandler(Page page, Point point) throws InterruptedException {
        PageText pageText;
        if (page != null && (pageText = page.getViewText()) != null) {
            pageText.clearSelected();
            DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
            Point2D.Float float_ = this.convertToPageSpace(point);
            ArrayList arrayList = pageText.getPageLines();
            if (arrayList != null) {
                block0: for (LineText lineText : arrayList) {
                    if (!lineText.getBounds().contains(float_)) continue;
                    lineText.setHasSelected(true);
                    List list = lineText.getWords();
                    for (WordText wordText : list) {
                        if (!wordText.getBounds().contains(float_)) continue;
                        wordText.selectAll();
                        documentViewModel.addSelectedPageText(this.pageViewComponent);
                        this.documentViewController.firePropertyChange("textSelected", null, null);
                        this.pageViewComponent.repaint();
                        continue block0;
                    }
                }
            }
        }
    }

    protected void lineSelectHandler(Page page, Point point) throws InterruptedException {
        PageText pageText;
        if (page != null && (pageText = page.getViewText()) != null) {
            pageText.clearSelected();
            DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
            Point2D.Float float_ = this.convertToPageSpace(point);
            ArrayList arrayList = pageText.getPageLines();
            if (arrayList != null) {
                for (LineText lineText : arrayList) {
                    if (!lineText.getBounds().contains(float_)) continue;
                    lineText.selectAll();
                    documentViewModel.addSelectedPageText(this.pageViewComponent);
                    this.documentViewController.firePropertyChange("textSelected", null, null);
                    this.pageViewComponent.repaint();
                    break;
                }
            }
        }
    }

    @Override
    public void setSelectionRectangle(Point point, Rectangle rectangle) {
    }

    public void setTopMargin(int n) {
        this.topMargin = n;
    }

    public void setBottomMargin(int n) {
        this.bottomMargin = n;
    }

    static {
        try {
            enableMarginExclusion = Defs.booleanProperty((String)"org.icepdf.core.views.page.marginExclusion.enabled", (boolean)false);
        }
        catch (NumberFormatException numberFormatException) {
            logger.warning("Error reading margin exclusion enabled property.");
        }
        try {
            enableMarginExclusionBorder = Defs.booleanProperty((String)"org.icepdf.core.views.page.marginExclusionBorder.enabled", (boolean)false);
        }
        catch (NumberFormatException numberFormatException) {
            logger.warning("Error reading margin exclusion boarder enabled property.");
        }
    }
}

