/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.AnnotationFactory;
import org.icepdf.core.pobjects.annotations.RedactionAnnotation;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.commands.DrawCmd;
import org.icepdf.core.pobjects.graphics.commands.ImageDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.ShapesDrawCmd;
import org.icepdf.core.pobjects.graphics.images.ImageStream;
import org.icepdf.core.util.Library;
import org.icepdf.ri.common.tools.HighLightAnnotationHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;
import org.icepdf.ri.common.views.annotations.RedactionAnnotationComponent;

public class RedactionAnnotationHandler
extends HighLightAnnotationHandler {
    private boolean isOverImage = false;

    public RedactionAnnotationHandler(DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(documentViewController, abstractPageViewComponent);
        this.markupSubType = Annotation.SUBTYPE_REDACT;
        selectionBoxColour = Color.BLACK;
    }

    @Override
    protected void createMarkupAnnotationFromTextSelection(MouseEvent mouseEvent) {
        ArrayList<Shape> arrayList = RedactionAnnotationHandler.getSelectedTextBounds(this.pageViewComponent, this.getPageTransform());
        this.createRedactionAnnotation(arrayList);
        this.documentViewController.getParentController().setDocumentToolMode(this.preferences.getInt("application.annotation.redaction.selection.type", 0));
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        boolean bl = this.selectionTextSelectIcon(mouseEvent.getPoint(), this.pageViewComponent);
        if (!bl) {
            this.selectionImageSelectIcon(mouseEvent.getPoint(), this.pageViewComponent);
        } else {
            this.isOverImage = false;
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isOverImage) {
            super.mousePressed(mouseEvent);
        } else {
            this.isClearSelection = false;
            this.pageViewComponent.requestFocus();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            this.currentRect = new Rectangle(n, n2, 0, 0);
            this.updateDrawableRect(this.pageViewComponent.getWidth(), this.pageViewComponent.getHeight());
            this.pageViewComponent.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.isOverImage) {
            super.mouseReleased(mouseEvent);
        } else {
            this.updateSelectionSize(mouseEvent.getX(), mouseEvent.getY(), this.pageViewComponent);
            this.createMarkupAnnotationFromSelectionBox();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.isClearSelection) {
            return;
        }
        if (!this.isOverImage) {
            super.mouseDragged(mouseEvent);
        } else {
            this.updateSelectionSize(mouseEvent.getX(), mouseEvent.getY(), this.pageViewComponent);
        }
    }

    @Override
    public void paintTool(Graphics graphics) {
        this.paintSelectionBox(graphics, this.rectToDraw);
    }

    @Override
    protected void paintRectangle(Graphics2D graphics2D, Rectangle rectangle) {
        if (this.isOverImage) {
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        }
    }

    public void selectionImageSelectIcon(Point point, AbstractPageViewComponent abstractPageViewComponent) {
        try {
            Page page = abstractPageViewComponent.getPage();
            Point2D.Float float_ = this.convertToPageSpace(point);
            if (page != null) {
                Shapes shapes = page.getShapes();
                ArrayList arrayList = shapes.getShapes();
                this.isOverImage = this.isCursorOverImage(float_, arrayList);
            }
        }
        catch (Exception exception) {
            logger.fine("Image selection page access interrupted");
        }
    }

    private boolean isCursorOverImage(Point2D.Float float_, ArrayList<DrawCmd> arrayList) {
        for (DrawCmd drawCmd : arrayList) {
            ImageDrawCmd imageDrawCmd;
            if (drawCmd instanceof ImageDrawCmd) {
                imageDrawCmd = (ImageDrawCmd)drawCmd;
                ImageStream imageStream = imageDrawCmd.getImageStream();
                Rectangle2D rectangle2D = imageStream.getNormalizedBounds();
                if (!rectangle2D.contains(float_)) continue;
                this.documentViewController.setViewCursor(11);
                return true;
            }
            if (!(drawCmd instanceof ShapesDrawCmd)) continue;
            imageDrawCmd = ((ShapesDrawCmd)drawCmd).getShapes();
            return this.isCursorOverImage(float_, imageDrawCmd.getShapes());
        }
        return false;
    }

    public void createMarkupAnnotationFromSelectionBox() {
        if (this.rectToDraw.getWidth() < 5.0 || this.rectToDraw.getHeight() < 5.0) {
            this.rectToDraw.setSize(new Dimension(15, 25));
        }
        Rectangle rectangle = this.convertToPageSpace(this.rectToDraw).getBounds();
        this.annotation = (RedactionAnnotation)AnnotationFactory.buildAnnotation((Library)this.documentViewController.getDocument().getPageTree().getLibrary(), (Name)this.markupSubType, (Rectangle)rectangle);
        if (this.annotation != null) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(this.rectToDraw, false);
            ArrayList<Shape> arrayList = new ArrayList<Shape>(1);
            arrayList.add(this.rectToDraw);
            this.convertToPageSpace(arrayList, generalPath);
            AffineTransform affineTransform = this.getToPageSpaceTransform();
            this.annotation.setColor(Color.BLACK);
            this.annotation.setMarkupBounds(arrayList);
            this.annotation.setMarkupPath(generalPath);
            this.annotation.setBBox(rectangle);
            this.annotation.resetAppearanceStream(affineTransform);
            RedactionAnnotationComponent redactionAnnotationComponent = (RedactionAnnotationComponent)AnnotationComponentFactory.buildAnnotationComponent((Annotation)this.annotation, this.documentViewController, this.pageViewComponent);
            if (redactionAnnotationComponent != null) {
                this.documentViewController.addNewAnnotation(redactionAnnotationComponent);
                redactionAnnotationComponent.setBounds(this.rectToDraw);
                Rectangle2D.Float float_ = this.annotation.getUserSpaceRectangle();
                this.annotation.syncBBoxToUserSpaceRectangle((Rectangle2D)float_);
            }
        }
        this.rectToDraw = null;
    }

    public void createRedactionAnnotation(ArrayList<Shape> arrayList) {
        DocumentViewModel documentViewModel = this.documentViewController.getDocumentViewModel();
        if (documentViewModel.isSelectAll()) {
            this.documentViewController.clearSelectedText();
            return;
        }
        if (arrayList == null) {
            arrayList = RedactionAnnotationHandler.getSelectedTextBounds(this.pageViewComponent, this.getPageTransform());
        }
        this.documentViewController.clearSelectedText();
        if (arrayList != null && !arrayList.isEmpty()) {
            Shape shape2;
            Area area = new Area();
            for (Shape shape2 : arrayList) {
                Rectangle2D rectangle2D = shape2.getBounds2D();
                double d = rectangle2D.getHeight() * 0.025;
                rectangle2D.setRect(rectangle2D.getX() - d, rectangle2D.getY() - d, rectangle2D.getWidth() + d * 2.0, rectangle2D.getHeight() + d * 2.0);
                area.add(new Area(rectangle2D));
            }
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(area, false);
            shape2 = generalPath.getBounds();
            Rectangle rectangle = this.convertToPageSpace(arrayList, generalPath);
            AffineTransform affineTransform = this.getToPageSpaceTransform();
            this.annotation = (RedactionAnnotation)AnnotationFactory.buildAnnotation((Library)documentViewModel.getDocument().getPageTree().getLibrary(), (Name)this.markupSubType, (Rectangle)rectangle);
            if (this.annotation != null) {
                this.annotation.setColor(Color.BLACK);
                this.annotation.setMarkupBounds(arrayList);
                this.annotation.setMarkupPath(generalPath);
                this.annotation.setBBox(rectangle);
                this.annotation.resetAppearanceStream(affineTransform);
                RedactionAnnotationComponent redactionAnnotationComponent = (RedactionAnnotationComponent)AnnotationComponentFactory.buildAnnotationComponent((Annotation)this.annotation, this.documentViewController, this.pageViewComponent);
                if (redactionAnnotationComponent != null) {
                    this.documentViewController.addNewAnnotation(redactionAnnotationComponent);
                    redactionAnnotationComponent.setBounds((Rectangle)shape2);
                    Rectangle2D.Float float_ = this.annotation.getUserSpaceRectangle();
                    this.annotation.syncBBoxToUserSpaceRectangle((Rectangle2D)float_);
                }
            }
        }
        this.pageViewComponent.repaint();
    }
}

