/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.annotations.LineAnnotation;
import org.icepdf.ri.common.tools.LineAnnotationHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;

public class LineArrowAnnotationHandler
extends LineAnnotationHandler {
    private static final Logger logger = Logger.getLogger(LineAnnotationHandler.class.toString());

    public LineArrowAnnotationHandler(DocumentViewController documentViewController, AbstractPageViewComponent abstractPageViewComponent) {
        super(documentViewController, abstractPageViewComponent);
        startLineEnding = LineAnnotation.LINE_END_OPEN_ARROW;
        endLineEnding = LineAnnotation.LINE_END_NONE;
    }

    @Override
    public void paintTool(Graphics graphics) {
        if (this.startOfLine != null && this.endOfLine != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = graphics2D.getColor();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setColor(lineColor);
            graphics2D.setStroke(LineArrowAnnotationHandler.stroke);
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)opacity / 255.0f));
            graphics2D.drawLine((int)this.startOfLine.getX(), (int)this.startOfLine.getY(), (int)this.endOfLine.getX(), (int)this.endOfLine.getY());
            if (!startLineEnding.equals(LineAnnotation.LINE_END_NONE)) {
                LineAnnotation.drawLineStart((Graphics2D)graphics2D, (Name)startLineEnding, (Point2D)this.startOfLine, (Point2D)this.endOfLine, (Color)lineColor, (Color)internalColor);
            }
            if (!endLineEnding.equals(LineAnnotation.LINE_END_NONE)) {
                LineAnnotation.drawLineEnd((Graphics2D)graphics2D, (Name)endLineEnding, (Point2D)this.endOfLine, (Point2D)this.endOfLine, (Color)lineColor, (Color)internalColor);
            }
            graphics.setColor(color);
            graphics2D.setStroke(stroke);
        }
    }

    @Override
    protected void checkAndApplyPreferences() {
        lineColor = new Color(this.preferences.getInt("application.viewer.preference.annotation.arrow.color", lineColor.getRGB()));
        internalColor = new Color(this.preferences.getInt("application.viewer.preference.annotation.arrow.fill.color", internalColor.getRGB()));
        opacity = this.preferences.getInt("application.viewer.preference.annotation.arrow.fill.opacity", opacity);
    }
}

