/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.properties;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.icepdf.ri.common.fonts.FontHandlerPanel;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.util.font.ClearFontCacheWorker;

public class FontPanel
extends JPanel
implements ActionListener,
WindowListener {
    private JButton resetFontCacheButton;
    private final FontHandlerPanel fontHandlerPanel;
    private final ResourceBundle messageBundle;
    private GridBagConstraints constraints;

    public FontPanel(Controller controller) {
        this.setFocusable(true);
        this.messageBundle = controller.getMessageBundle();
        this.fontHandlerPanel = new FontHandlerPanel(controller);
        this.fontHandlerPanel.refreshDocumentInstance();
        this.setGui();
    }

    private void setGui() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1), this.messageBundle.getString("viewer.dialog.fonts.border.label"), 1, 0));
        this.setLayout(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.anchor = 18;
        this.constraints.insets = new Insets(1, 5, 5, 5);
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.fontHandlerPanel.setPreferredSize(new Dimension(150, 150));
        this.addGB(jPanel, this.fontHandlerPanel, 0, 0, 2, 1);
        this.resetFontCacheButton = new JButton(this.messageBundle.getString("viewer.dialog.fonts.resetCache.label"));
        this.resetFontCacheButton.setToolTipText(this.messageBundle.getString("viewer.dialog.fonts.resetCache.tip"));
        this.resetFontCacheButton.addActionListener(this);
        this.constraints.insets = new Insets(0, 5, 5, 5);
        this.constraints.weighty = 0.0;
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.addGB(jPanel, this.resetFontCacheButton, 0, 1, 1, 1);
        this.constraints.fill = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.addGB(this, jPanel, 0, 0, 1, 1);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.resetFontCacheButton) {
            this.resetFontCacheButton.setEnabled(false);
            new ClearFontCacheWorker(this.resetFontCacheButton).execute();
        }
    }

    protected void closeWindowOperations() {
        this.fontHandlerPanel.disposeDocument();
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.closeWindowOperations();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.closeWindowOperations();
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

