/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.print;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.CancelablePrintJob;
import javax.print.PrintException;
import javax.swing.SwingUtilities;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.print.PrintHelper;

public class PrinterTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(PrinterTask.class.toString());
    private final PrintHelper printHelper;
    private final SwingController controller;
    private CancelablePrintJob cancelablePrintJob;

    public PrinterTask(PrintHelper printHelper, SwingController swingController) {
        this.printHelper = printHelper;
        this.controller = swingController;
    }

    @Override
    public void run() {
        int n = this.controller.getDocumentViewToolMode();
        try {
            SwingUtilities.invokeLater(() -> this.controller.setDisplayTool(51));
            if (this.printHelper != null) {
                this.cancelablePrintJob = this.printHelper.cancelablePrint();
            }
        }
        catch (PrintException printException) {
            logger.log(Level.FINE, "Error during printing.", printException);
        }
        finally {
            SwingUtilities.invokeLater(() -> this.controller.setDisplayTool(n));
        }
    }

    public void cancel() {
        try {
            if (this.cancelablePrintJob != null) {
                this.cancelablePrintJob.cancel();
            }
        }
        catch (PrintException printException) {
            logger.log(Level.FINE, "Error during printing, " + printException.getMessage());
        }
    }
}

