/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.icepdf.core.pobjects.graphics.images.references.ImageReference;
import org.icepdf.core.util.Library;
import org.icepdf.ri.common.PageNumberTextFieldInputVerifier;
import org.icepdf.ri.common.preferences.BooleanItem;
import org.icepdf.ri.common.views.Controller;
import org.icepdf.ri.util.ViewerPropertiesManager;

public class AdvancedPreferencesPanel
extends JPanel {
    private final GridBagConstraints constraints;
    private final Preferences preferences;
    private JTextField imageProxyThreadCountField;
    private final JTextField commonThreadCountField;

    public AdvancedPreferencesPanel(Controller controller, ViewerPropertiesManager viewerPropertiesManager, ResourceBundle resourceBundle) {
        super(new GridBagLayout());
        this.setAlignmentY(0.0f);
        this.preferences = viewerPropertiesManager.getPreferences();
        boolean bl = this.preferences.getBoolean("org.icepdf.core.imageProxy", ImageReference.useProxy);
        int n = this.preferences.getInt("org.icepdf.core.library.imageThreadPoolSize", Library.imagePoolThreads);
        int n2 = this.preferences.getInt("org.icepdf.core.library.threadPoolSize", Library.commonPoolThreads);
        BooleanItem[] booleanItemArray = new BooleanItem[]{new BooleanItem(resourceBundle.getString("viewer.dialog.viewerPreferences.section.advanced.imageProxyEnabled.label"), true), new BooleanItem(resourceBundle.getString("viewer.dialog.viewerPreferences.section.advanced.imageProxyDisabled.label"), false)};
        JComboBox<BooleanItem> jComboBox = new JComboBox<BooleanItem>(booleanItemArray);
        jComboBox.setSelectedItem(new BooleanItem("", bl));
        jComboBox.addActionListener(actionEvent -> {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            BooleanItem booleanItem = (BooleanItem)jComboBox.getSelectedItem();
            if (booleanItem != null) {
                this.preferences.putBoolean("org.icepdf.core.imageProxy", booleanItem.getValue());
                this.imageProxyThreadCountField.setEnabled(booleanItem.getValue());
            }
        });
        this.imageProxyThreadCountField = new JTextField(2);
        this.imageProxyThreadCountField.setEnabled(bl);
        this.imageProxyThreadCountField.setText(String.valueOf(n));
        this.imageProxyThreadCountField.setInputVerifier(new PageNumberTextFieldInputVerifier());
        this.imageProxyThreadCountField.addActionListener(actionEvent -> this.preferences.putInt("org.icepdf.core.library.imageThreadPoolSize", Integer.parseInt(this.imageProxyThreadCountField.getText())));
        this.commonThreadCountField = new JTextField(2);
        this.commonThreadCountField.setText(String.valueOf(n2));
        this.commonThreadCountField.setInputVerifier(new PageNumberTextFieldInputVerifier());
        this.commonThreadCountField.addActionListener(actionEvent -> this.preferences.putInt("org.icepdf.core.library.threadPoolSize", Integer.parseInt(this.commonThreadCountField.getText())));
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 0;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setAlignmentY(0.0f);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1), resourceBundle.getString("viewer.dialog.viewerPreferences.section.advanced.commonThreadPool.border.label"), 1, 0));
        this.addGB(jPanel, new JLabel(resourceBundle.getString("viewer.dialog.viewerPreferences.section.advanced.commonThreadPool.label")), 0, 0, 1, 1);
        this.constraints.anchor = 13;
        this.addGB(jPanel, this.commonThreadCountField, 1, 0, 1, 1);
        this.constraints.anchor = 17;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setAlignmentY(0.0f);
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(1), resourceBundle.getString("viewer.dialog.viewerPreferences.section.advanced.imageProxy.border.label"), 1, 0));
        this.addGB(jPanel2, new JLabel(resourceBundle.getString("viewer.dialog.viewerPreferences.section.advanced.imageProxy.label")), 0, 0, 1, 1);
        this.addGB(jPanel2, jComboBox, 1, 0, 1, 1);
        this.constraints.anchor = 17;
        this.addGB(jPanel2, new JLabel(resourceBundle.getString("viewer.dialog.viewerPreferences.section.advanced.imageProxyPoolSize.label")), 0, 1, 1, 1);
        this.constraints.anchor = 13;
        this.addGB(jPanel2, this.imageProxyThreadCountField, 1, 1, 1, 1);
        this.constraints.anchor = 18;
        this.constraints.fill = 1;
        this.addGB(this, jPanel, 0, 0, 1, 1);
        this.addGB(this, jPanel2, 0, 1, 1, 1);
        this.addGB(this, new JLabel(resourceBundle.getString("viewer.dialog.viewerPreferences.section.advanced.restartRequired.label")), 0, 2, 1, 1);
        this.constraints.weighty = 1.0;
        this.addGB(this, new Label(" "), 0, 3, 1, 1);
    }

    private void addGB(JPanel jPanel, Component component, int n, int n2, int n3, int n4) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        jPanel.add(component, this.constraints);
    }
}

