/*
 * Decompiled with CFR 0.152.
 */
package com.passiondroid.imageeditorlib;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.os.Bundle;
import android.util.Log;
import android.util.LruCache;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.passiondroid.imageeditorlib.AnimationHelper;
import com.passiondroid.imageeditorlib.BaseFragment;
import com.passiondroid.imageeditorlib.ImageEditActivity;
import com.passiondroid.imageeditorlib.R;
import com.passiondroid.imageeditorlib.filter.ProcessingImage;
import com.passiondroid.imageeditorlib.utils.Matrix3;
import com.passiondroid.imageeditorlib.utils.TaskCallback;
import com.passiondroid.imageeditorlib.utils.Utility;
import com.passiondroid.imageeditorlib.views.PhotoEditorView;
import com.passiondroid.imageeditorlib.views.VerticalSlideColorPicker;
import com.passiondroid.imageeditorlib.views.ViewTouchListener;
import com.passiondroid.imageeditorlib.views.imagezoom.ImageViewTouch;

public class PhotoEditorFragment
extends BaseFragment
implements View.OnClickListener,
ViewTouchListener {
    ImageViewTouch mainImageView;
    ImageView cropButton;
    ImageView stickerButton;
    ImageView addTextButton;
    PhotoEditorView photoEditorView;
    ImageView paintButton;
    ImageView deleteButton;
    VerticalSlideColorPicker colorPickerView;
    View toolbarLayout;
    FloatingActionButton doneBtn;
    private Bitmap mainBitmap;
    private LruCache<Integer, Bitmap> cacheStack;
    private OnFragmentInteractionListener mListener;
    public static final int MODE_NONE = 0;
    public static final int MODE_PAINT = 1;
    public static final int MODE_ADD_TEXT = 2;
    public static final int MODE_STICKER = 3;
    protected int currentMode;
    private Bitmap originalBitmap;

    public static PhotoEditorFragment newInstance(String imagePath) {
        Bundle bundle = new Bundle();
        bundle.putString("EXTRA_IMAGE_PATH", imagePath);
        PhotoEditorFragment photoEditorFragment = new PhotoEditorFragment();
        photoEditorFragment.setArguments(bundle);
        return photoEditorFragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_photo_editor, container, false);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof OnFragmentInteractionListener)) {
            throw new RuntimeException(context.toString() + " must implement OnFragmentInteractionListener");
        }
        this.mListener = (OnFragmentInteractionListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.mainImageView.setImageBitmap(bitmap);
        this.mainImageView.post(new Runnable(){

            @Override
            public void run() {
                PhotoEditorFragment.this.photoEditorView.setBounds(PhotoEditorFragment.this.mainImageView.getBitmapRect());
            }
        });
    }

    public void setImageWithRect(Rect rect) {
        this.mainBitmap = this.getScaledBitmap(this.getCroppedBitmap(this.getBitmapCache(this.originalBitmap), rect));
        this.mainImageView.setImageBitmap(this.mainBitmap);
        this.mainImageView.post(new Runnable(){

            @Override
            public void run() {
                PhotoEditorFragment.this.photoEditorView.setBounds(PhotoEditorFragment.this.mainImageView.getBitmapRect());
            }
        });
    }

    private Bitmap getScaledBitmap(Bitmap resource) {
        int currentBitmapWidth = resource.getWidth();
        int currentBitmapHeight = resource.getHeight();
        int ivWidth = this.mainImageView.getWidth();
        int newHeight = (int)Math.floor((double)currentBitmapHeight * ((double)ivWidth / (double)currentBitmapWidth));
        return Bitmap.createScaledBitmap((Bitmap)resource, (int)ivWidth, (int)newHeight, (boolean)true);
    }

    private Bitmap getCroppedBitmap(Bitmap srcBitmap, Rect rect) {
        return Bitmap.createBitmap((Bitmap)srcBitmap, (int)rect.left, (int)rect.top, (int)(rect.right - rect.left), (int)(rect.bottom - rect.top));
    }

    public void reset() {
        this.photoEditorView.reset();
    }

    @Override
    protected void initView(View view) {
        this.mainImageView = (ImageViewTouch)view.findViewById(R.id.image_iv);
        this.cropButton = (ImageView)view.findViewById(R.id.crop_btn);
        this.stickerButton = (ImageView)view.findViewById(R.id.stickers_btn);
        this.addTextButton = (ImageView)view.findViewById(R.id.add_text_btn);
        this.deleteButton = (ImageView)view.findViewById(R.id.delete_view);
        this.photoEditorView = (PhotoEditorView)view.findViewById(R.id.photo_editor_view);
        this.paintButton = (ImageView)view.findViewById(R.id.paint_btn);
        this.colorPickerView = (VerticalSlideColorPicker)view.findViewById(R.id.color_picker_view);
        this.toolbarLayout = view.findViewById(R.id.toolbar_layout);
        this.doneBtn = (FloatingActionButton)view.findViewById(R.id.done_btn);
        if (this.getArguments() != null && this.getActivity() != null && this.getActivity().getIntent() != null) {
            String imagePath = this.getArguments().getString("EXTRA_IMAGE_PATH");
            Glide.with((Fragment)this).asBitmap().load(imagePath).into((Target)new SimpleTarget<Bitmap>(){

                public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                    int currentBitmapWidth = resource.getWidth();
                    int currentBitmapHeight = resource.getHeight();
                    int ivWidth = PhotoEditorFragment.this.mainImageView.getWidth();
                    int newHeight = (int)Math.floor((double)currentBitmapHeight * ((double)ivWidth / (double)currentBitmapWidth));
                    PhotoEditorFragment.this.originalBitmap = Bitmap.createScaledBitmap((Bitmap)resource, (int)ivWidth, (int)newHeight, (boolean)true);
                    PhotoEditorFragment.this.mainBitmap = PhotoEditorFragment.this.originalBitmap;
                    PhotoEditorFragment.this.setImageBitmap(PhotoEditorFragment.this.mainBitmap);
                }
            });
            Intent intent = this.getActivity().getIntent();
            this.setVisibility((View)this.addTextButton, intent.getBooleanExtra("EXTRA_IS_TEXT_MODE", false));
            this.setVisibility((View)this.cropButton, intent.getBooleanExtra("EXTRA_IS_CROP_MODE", false));
            this.setVisibility((View)this.stickerButton, intent.getBooleanExtra("EXTRA_IS_STICKER_MODE", false));
            this.setVisibility((View)this.paintButton, intent.getBooleanExtra("EXTRA_IS_PAINT_MODE", false));
            this.photoEditorView.setImageView((ImageView)this.mainImageView, this.deleteButton, this);
            this.cropButton.setOnClickListener((View.OnClickListener)this);
            this.stickerButton.setOnClickListener((View.OnClickListener)this);
            this.addTextButton.setOnClickListener((View.OnClickListener)this);
            this.paintButton.setOnClickListener((View.OnClickListener)this);
            this.doneBtn.setOnClickListener((View.OnClickListener)this);
            view.findViewById(R.id.back_iv).setOnClickListener((View.OnClickListener)this);
            this.colorPickerView.setOnColorChangeListener(new VerticalSlideColorPicker.OnColorChangeListener(){

                @Override
                public void onColorChange(int selectedColor) {
                    if (PhotoEditorFragment.this.currentMode == 1) {
                        PhotoEditorFragment.this.paintButton.setBackground(Utility.tintDrawable(PhotoEditorFragment.this.getContext(), R.drawable.circle, selectedColor));
                        PhotoEditorFragment.this.photoEditorView.setColor(selectedColor);
                    } else if (PhotoEditorFragment.this.currentMode == 2) {
                        PhotoEditorFragment.this.addTextButton.setBackground(Utility.tintDrawable(PhotoEditorFragment.this.getContext(), R.drawable.circle, selectedColor));
                        PhotoEditorFragment.this.photoEditorView.setTextColor(selectedColor);
                    }
                }
            });
            this.photoEditorView.setColor(this.colorPickerView.getDefaultColor());
            this.photoEditorView.setTextColor(this.colorPickerView.getDefaultColor());
        }
    }

    protected void onModeChanged(int currentMode) {
        Log.i((String)ImageEditActivity.class.getSimpleName(), (String)("CM: " + currentMode));
        this.onStickerMode(currentMode == 3);
        this.onAddTextMode(currentMode == 2);
        this.onPaintMode(currentMode == 1);
        if (currentMode == 1 || currentMode == 2) {
            AnimationHelper.animate(this.getContext(), this.colorPickerView, R.anim.slide_in_right, 0, null);
        } else {
            AnimationHelper.animate(this.getContext(), this.colorPickerView, R.anim.slide_out_right, 4, null);
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.crop_btn) {
            this.mListener.onCropClicked(this.getBitmapCache(this.originalBitmap));
            this.photoEditorView.hidePaintView();
        } else if (id2 == R.id.stickers_btn) {
            this.setMode(3);
        } else if (id2 == R.id.add_text_btn) {
            this.setMode(2);
        } else if (id2 == R.id.paint_btn) {
            this.setMode(1);
        } else if (id2 == R.id.back_iv) {
            this.getActivity().onBackPressed();
        } else if (id2 == R.id.done_btn) {
            new ProcessingImage(this.getBitmapCache(this.mainBitmap), Utility.getCacheFilePath(view.getContext()), new TaskCallback<String>(){

                @Override
                public void onTaskDone(String data) {
                    PhotoEditorFragment.this.mListener.onDoneClicked(data);
                }
            }).execute(new Void[0]);
        }
        if (this.currentMode != 0) {
            this.mainImageView.animate().scaleX(1.0f);
            this.photoEditorView.animate().scaleX(1.0f);
            this.mainImageView.animate().scaleY(1.0f);
            this.photoEditorView.animate().scaleY(1.0f);
        }
    }

    private void onAddTextMode(boolean status) {
        if (status) {
            this.addTextButton.setBackground(Utility.tintDrawable(this.getContext(), R.drawable.circle, this.photoEditorView.getColor()));
            this.photoEditorView.addText();
        } else {
            this.addTextButton.setBackground(null);
            this.photoEditorView.hideTextMode();
        }
    }

    private void onPaintMode(boolean status) {
        if (status) {
            this.paintButton.setBackground(Utility.tintDrawable(this.getContext(), R.drawable.circle, this.photoEditorView.getColor()));
            this.photoEditorView.showPaintView();
        } else {
            this.paintButton.setBackground(null);
            this.photoEditorView.hidePaintView();
        }
    }

    private void onStickerMode(boolean status) {
        if (status) {
            this.stickerButton.setBackground(Utility.tintDrawable(this.getContext(), R.drawable.circle, this.photoEditorView.getColor()));
            if (this.getActivity() != null && this.getActivity().getIntent() != null) {
                String folderName = this.getActivity().getIntent().getStringExtra("EXTRA_STICKER_FOLDER_NAME");
                this.photoEditorView.showStickers(folderName);
            }
        } else {
            this.stickerButton.setBackground(null);
            this.photoEditorView.hideStickers();
        }
    }

    @Override
    public void onStartViewChangeListener(View view) {
        Log.i((String)ImageEditActivity.class.getSimpleName(), (String)("onStartViewChangeListener" + view.getId()));
        this.toolbarLayout.setVisibility(8);
        AnimationHelper.animate(this.getContext(), (View)this.deleteButton, R.anim.fade_in_medium, 0, null);
    }

    @Override
    public void onStopViewChangeListener(View view) {
        Log.i((String)ImageEditActivity.class.getSimpleName(), (String)("onStopViewChangeListener" + view.getId()));
        this.deleteButton.setVisibility(8);
        AnimationHelper.animate(this.getContext(), this.toolbarLayout, R.anim.fade_in_medium, 0, null);
    }

    private Bitmap getBitmapCache(Bitmap bitmap) {
        Matrix touchMatrix = this.mainImageView.getImageViewMatrix();
        Bitmap resultBit = Bitmap.createBitmap((Bitmap)bitmap).copy(Bitmap.Config.ARGB_8888, true);
        Canvas canvas = new Canvas(resultBit);
        float[] data = new float[9];
        touchMatrix.getValues(data);
        Matrix3 cal = new Matrix3(data);
        Matrix3 inverseMatrix = cal.inverseMatrix();
        Matrix m = new Matrix();
        m.setValues(inverseMatrix.getValues());
        float[] f = new float[9];
        m.getValues(f);
        int dx = (int)f[2];
        int dy = (int)f[5];
        float scale_x = f[0];
        float scale_y = f[4];
        canvas.save();
        canvas.translate((float)dx, (float)dy);
        canvas.scale(scale_x, scale_y);
        this.photoEditorView.setDrawingCacheEnabled(true);
        if (this.photoEditorView.getDrawingCache() != null) {
            canvas.drawBitmap(this.photoEditorView.getDrawingCache(), 0.0f, 0.0f, null);
        }
        if (this.photoEditorView.getPaintBit() != null) {
            canvas.drawBitmap(this.photoEditorView.getPaintBit(), 0.0f, 0.0f, null);
        }
        canvas.restore();
        return resultBit;
    }

    protected void setMode(int mode) {
        if (this.currentMode != mode) {
            this.onModeChanged(mode);
        } else {
            mode = 0;
            this.onModeChanged(mode);
        }
        this.currentMode = mode;
    }

    public static interface OnFragmentInteractionListener {
        public void onCropClicked(Bitmap var1);

        public void onDoneClicked(String var1);
    }
}

