/*
 * Decompiled with CFR 0.152.
 */
package com.passiondroid.imageeditorlib.views;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.passiondroid.imageeditorlib.R;
import com.passiondroid.imageeditorlib.utils.KeyboardHeightProvider;
import com.passiondroid.imageeditorlib.utils.MultiTouchListener;
import com.passiondroid.imageeditorlib.utils.Utility;
import com.passiondroid.imageeditorlib.views.AutofitTextView;
import com.passiondroid.imageeditorlib.views.CustomPaintView;
import com.passiondroid.imageeditorlib.views.ViewTouchListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PhotoEditorView
extends FrameLayout
implements ViewTouchListener,
KeyboardHeightProvider.KeyboardHeightObserver {
    RelativeLayout container;
    RecyclerView recyclerView;
    CustomPaintView customPaintView;
    private String folderName;
    private ImageView imageView;
    private ImageView deleteView;
    private ViewTouchListener viewTouchListener;
    private View selectedView;
    private int selectViewIndex;
    private EditText inputTextET;
    private KeyboardHeightProvider keyboardHeightProvider;
    private float initialY;
    private View containerView;

    public PhotoEditorView(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public PhotoEditorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public PhotoEditorView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    private void init(Context context, AttributeSet attrs, int defStyle) {
        View view = PhotoEditorView.inflate((Context)this.getContext(), (int)R.layout.photo_editor_view, null);
        this.container = (RelativeLayout)view.findViewById(R.id.container);
        this.containerView = view.findViewById(R.id.container_view);
        this.recyclerView = (RecyclerView)view.findViewById(R.id.recyclerview);
        this.inputTextET = (EditText)view.findViewById(R.id.add_text_et);
        this.customPaintView = (CustomPaintView)view.findViewById(R.id.paint_view);
        this.inputTextET.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView textView, int actionId, KeyEvent keyEvent) {
                if (actionId == 6) {
                    if (PhotoEditorView.this.selectedView != null) {
                        ((AutofitTextView)PhotoEditorView.this.selectedView).setText((CharSequence)PhotoEditorView.this.inputTextET.getText());
                        Utility.hideSoftKeyboard((Activity)PhotoEditorView.this.getContext());
                    } else {
                        PhotoEditorView.this.createText(PhotoEditorView.this.inputTextET.getText().toString());
                        Utility.hideSoftKeyboard((Activity)PhotoEditorView.this.getContext());
                    }
                    PhotoEditorView.this.inputTextET.setVisibility(4);
                }
                return false;
            }
        });
        this.keyboardHeightProvider = new KeyboardHeightProvider((Activity)this.getContext());
        this.keyboardHeightProvider.setKeyboardHeightObserver(this);
        GridLayoutManager gridLayoutManager = new GridLayoutManager(this.getContext(), 3);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager);
        StickerListAdapter stickerAdapter = new StickerListAdapter(new ArrayList<String>());
        this.recyclerView.setAdapter((RecyclerView.Adapter)stickerAdapter);
        view.post(new Runnable(){

            @Override
            public void run() {
                PhotoEditorView.this.keyboardHeightProvider.start();
            }
        });
        this.inputTextET.post(new Runnable(){

            @Override
            public void run() {
                PhotoEditorView.this.initialY = PhotoEditorView.this.inputTextET.getY();
            }
        });
        this.addView(view);
    }

    public void showPaintView() {
        this.recyclerView.setVisibility(8);
        this.inputTextET.setVisibility(8);
        Utility.hideSoftKeyboard((Activity)this.getContext());
        this.customPaintView.bringToFront();
    }

    public void setBounds(RectF bitmapRect) {
        this.customPaintView.setBounds(bitmapRect);
    }

    public void setColor(int selectedColor) {
        this.customPaintView.setColor(selectedColor);
    }

    public int getColor() {
        return this.customPaintView.getColor();
    }

    public Bitmap getPaintBit() {
        return this.customPaintView.getPaintBit();
    }

    public void hidePaintView() {
        this.containerView.bringToFront();
    }

    public void setImageView(ImageView imageView, ImageView deleteButton, ViewTouchListener viewTouchListener) {
        this.imageView = imageView;
        this.deleteView = deleteButton;
        this.viewTouchListener = viewTouchListener;
    }

    public void setTextColor(int selectedColor) {
        AutofitTextView autofitTextView = null;
        if (this.selectedView != null) {
            autofitTextView = (AutofitTextView)this.selectedView;
            autofitTextView.setTextColor(selectedColor);
        } else {
            View view = this.getViewChildAt(this.selectViewIndex);
            if (view != null && view instanceof AutofitTextView) {
                autofitTextView = (AutofitTextView)view;
                autofitTextView.setTextColor(selectedColor);
            }
        }
        this.inputTextET.setTextColor(selectedColor);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public void addText() {
        this.inputTextET.setVisibility(0);
        this.recyclerView.setVisibility(8);
        this.containerView.bringToFront();
        this.inputTextET.setText(null);
        Utility.showSoftKeyboard((Activity)this.getContext(), (View)this.inputTextET);
    }

    public void hideTextMode() {
        Utility.hideSoftKeyboard((Activity)this.getContext());
        this.inputTextET.setVisibility(4);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public void setOnTouchListener(View.OnTouchListener l) {
        super.setOnTouchListener(l);
        this.containerView.setOnTouchListener(l);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void createText(String text) {
        AutofitTextView autofitTextView = (AutofitTextView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.text_editor, null);
        autofitTextView.setId(this.container.getChildCount());
        autofitTextView.setText(text);
        autofitTextView.setTextColor(this.inputTextET.getCurrentTextColor());
        autofitTextView.setMaxTextSize(2, 50.0f);
        MultiTouchListener multiTouchListener = new MultiTouchListener((View)this.deleteView, this.container, this.imageView, true, this);
        multiTouchListener.setOnMultiTouchListener(new MultiTouchListener.OnMultiTouchListener(){

            @Override
            public void onRemoveViewListener(View removedView) {
                PhotoEditorView.this.container.removeView(removedView);
                PhotoEditorView.this.inputTextET.setText(null);
                PhotoEditorView.this.inputTextET.setVisibility(4);
                PhotoEditorView.this.selectedView = null;
            }
        });
        multiTouchListener.setOnGestureControl(new MultiTouchListener.OnGestureControl(){

            @Override
            public void onClick(View currentView) {
                if (currentView != null) {
                    PhotoEditorView.this.selectedView = currentView;
                    PhotoEditorView.this.selectViewIndex = currentView.getId();
                    PhotoEditorView.this.inputTextET.setVisibility(0);
                    PhotoEditorView.this.inputTextET.setText(((AutofitTextView)currentView).getText());
                    PhotoEditorView.this.inputTextET.setSelection(PhotoEditorView.this.inputTextET.getText().length());
                    Log.i((String)"ViewNum", (String)(":" + PhotoEditorView.this.selectViewIndex + " " + ((AutofitTextView)currentView).getText()));
                }
                Utility.showSoftKeyboard((Activity)PhotoEditorView.this.getContext(), (View)PhotoEditorView.this.inputTextET);
            }

            @Override
            public void onLongClick() {
            }
        });
        autofitTextView.setOnTouchListener(multiTouchListener);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(13, -1);
        this.container.addView((View)autofitTextView, (ViewGroup.LayoutParams)params);
        this.selectViewIndex = this.container.getChildAt(this.container.getChildCount() - 1).getId();
        this.selectedView = null;
    }

    @Override
    public void onStartViewChangeListener(View view) {
        Utility.hideSoftKeyboard((Activity)this.getContext());
        if (this.viewTouchListener != null) {
            this.viewTouchListener.onStartViewChangeListener(view);
        }
    }

    @Override
    public void onStopViewChangeListener(View view) {
        if (this.viewTouchListener != null) {
            this.viewTouchListener.onStopViewChangeListener(view);
        }
    }

    private View getViewChildAt(int index) {
        if (index > this.container.getChildCount() - 1) {
            return null;
        }
        return this.container.getChildAt(index);
    }

    @Override
    public void onKeyboardHeightChanged(int height, int orientation) {
        if (height == 0) {
            this.inputTextET.setY(this.initialY);
            this.inputTextET.requestLayout();
        } else {
            float newPosition = this.initialY - (float)height;
            this.inputTextET.setY(newPosition);
            this.inputTextET.requestLayout();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.keyboardHeightProvider.close();
    }

    public void showStickers(String stickersFolder) {
        this.containerView.bringToFront();
        this.recyclerView.setVisibility(0);
        this.inputTextET.setVisibility(8);
        Utility.hideSoftKeyboard((Activity)this.getContext());
        this.folderName = stickersFolder;
        StickerListAdapter stickerListAdapter = (StickerListAdapter)this.recyclerView.getAdapter();
        if (stickerListAdapter != null) {
            stickerListAdapter.setData(this.getStickersList(stickersFolder));
        }
    }

    public void hideStickers() {
        this.recyclerView.setVisibility(8);
    }

    private List<String> getStickersList(String folderName) {
        AssetManager assetManager = this.getContext().getAssets();
        try {
            String[] lists = assetManager.list(folderName);
            return Arrays.asList(lists);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public void onItemClick(Bitmap bitmap) {
        this.recyclerView.setVisibility(8);
        ImageView stickerImageView = (ImageView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.sticker_view, null);
        stickerImageView.setImageBitmap(bitmap);
        stickerImageView.setId(this.container.getChildCount());
        MultiTouchListener multiTouchListener = new MultiTouchListener((View)this.deleteView, this.container, this.imageView, true, this);
        multiTouchListener.setOnMultiTouchListener(new MultiTouchListener.OnMultiTouchListener(){

            @Override
            public void onRemoveViewListener(View removedView) {
                PhotoEditorView.this.container.removeView(removedView);
                PhotoEditorView.this.selectedView = null;
            }
        });
        multiTouchListener.setOnGestureControl(new MultiTouchListener.OnGestureControl(){

            @Override
            public void onClick(View currentView) {
                if (currentView != null) {
                    PhotoEditorView.this.selectedView = currentView;
                    PhotoEditorView.this.selectViewIndex = currentView.getId();
                }
            }

            @Override
            public void onLongClick() {
            }
        });
        stickerImageView.setOnTouchListener((View.OnTouchListener)multiTouchListener);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(13, -1);
        this.container.addView((View)stickerImageView, (ViewGroup.LayoutParams)params);
    }

    public void reset() {
        this.container.removeAllViews();
        this.customPaintView.reset();
        this.invalidate();
    }

    public void crop(Rect cropRect) {
        this.container.removeAllViews();
        this.customPaintView.reset();
        this.invalidate();
    }

    public class StickerListAdapter
    extends RecyclerView.Adapter<ViewHolder> {
        private List<String> stickers;

        public StickerListAdapter(ArrayList<String> list) {
            this.stickers = list;
        }

        public void setData(List<String> stickersList) {
            this.stickers = stickersList;
            this.notifyDataSetChanged();
        }

        public void add(int position, String item) {
            this.stickers.add(position, item);
            this.notifyItemInserted(position);
        }

        public void remove(int position) {
            this.stickers.remove(position);
            this.notifyItemRemoved(position);
        }

        public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
            View v = inflater.inflate(R.layout.sticker_view, parent, false);
            ViewHolder vh = new ViewHolder(v);
            return vh;
        }

        public void onBindViewHolder(ViewHolder holder, int position) {
            final String path = this.stickers.get(position);
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    PhotoEditorView.this.onItemClick(StickerListAdapter.this.getImageFromAssetsFile(path));
                }
            });
            ((ImageView)holder.itemView).setImageBitmap(this.getImageFromAssetsFile(path));
        }

        public int getItemCount() {
            return this.stickers.size();
        }

        private Bitmap getImageFromAssetsFile(String fileName) {
            Bitmap image = null;
            AssetManager am = PhotoEditorView.this.getResources().getAssets();
            try {
                InputStream is = am.open(PhotoEditorView.this.folderName + "/" + fileName);
                image = BitmapFactory.decodeStream((InputStream)is);
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return image;
        }

        public class ViewHolder
        extends RecyclerView.ViewHolder {
            public ViewHolder(View v) {
                super(v);
            }
        }
    }
}

