/*
 * Decompiled with CFR 0.152.
 */
package com.passiondroid.imageeditorlib.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class Utility {
    public static Drawable tintDrawable(Context context, @DrawableRes int drawableRes, int colorCode) {
        Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)drawableRes);
        if (drawable2 != null) {
            drawable2.mutate();
            DrawableCompat.setTint((Drawable)drawable2, (int)colorCode);
        }
        return drawable2;
    }

    public static void hideSoftKeyboard(Activity context) {
        if (context.getCurrentFocus() != null) {
            InputMethodManager inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(context.getCurrentFocus().getWindowToken(), 0);
        }
    }

    public static void showSoftKeyboard(Activity context, View view) {
        InputMethodManager inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
        view.requestFocus();
        inputMethodManager.showSoftInput(view, 0);
    }

    public static int dpToPx(Context context, int dp) {
        float density = context.getResources().getDisplayMetrics().density;
        return Math.round((float)dp * density);
    }

    public static String saveBitmap(Bitmap bitmap, String imagePath) {
        try {
            File outputFile = new File(imagePath);
            FileOutputStream bmpFile = new FileOutputStream(outputFile);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bmpFile);
            bmpFile.flush();
            bmpFile.close();
            return outputFile.getAbsolutePath();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getCacheFilePath(Context context) {
        return context.getCacheDir() + "edited_" + System.currentTimeMillis() + ".jpg";
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize >= reqHeight && halfWidth / inSampleSize >= reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    public static Bitmap decodeBitmap(String imagePath, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        options.inSampleSize = Utility.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
    }
}

