/*
 * Decompiled with CFR 0.152.
 */
package com.github.paolorotolo.appintro.model;

import android.view.View;
import com.github.paolorotolo.appintro.model.Transformation;

public class ZoomTransformation
extends Transformation {
    private static final float MIN_SCALE_ZOOM = 0.85f;
    private static final float MIN_ALPHA_ZOOM = 0.5f;

    @Override
    public void transformPage(View page, float position) {
        if (position >= -1.0f && position <= 1.0f) {
            this.scale = Math.max(0.85f, 1.0f - Math.abs(position));
            this.alpha = 0.5f + (this.scale - 0.85f) / 0.14999998f * 0.5f;
            float vMargin = (float)page.getHeight() * (1.0f - this.scale) / 2.0f;
            float hMargin = (float)page.getWidth() * (1.0f - this.scale) / 2.0f;
            this.translationX = position < 0.0f ? hMargin - vMargin / 2.0f : -hMargin + vMargin / 2.0f;
        } else {
            this.alpha = 1.0f;
            this.scale = 1.0f;
            this.translationX = 0.0f;
        }
        this.setTransformParameters(page);
    }
}

