/*
 * Decompiled with CFR 0.152.
 */
package com.github.appintro.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.animation.Interpolator;
import androidx.viewpager.widget.ViewPager;
import com.github.appintro.AppIntroBase;
import com.github.appintro.AppIntroPageTransformerType;
import com.github.appintro.AppIntroViewPagerListener;
import com.github.appintro.internal.LayoutUtil;
import com.github.appintro.internal.LogHelper;
import com.github.appintro.internal.ScrollerCustomDuration;
import com.github.appintro.internal.viewpager.ViewPagerTransformer;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0000\u0018\u0000 >2\u00020\u0001:\u0001>B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u00060 R\u00020!H\u0000\u00a2\u0006\u0002\b\"J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$J\u0006\u0010&\u001a\u00020\u001eJ\u0006\u0010'\u001a\u00020\u001eJ\u0010\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*H\u0002J\u000e\u0010+\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020$J\u000e\u0010,\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020$J\u0018\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\bH\u0002J\u0010\u00100\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u00101\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*H\u0017J\b\u00102\u001a\u00020\u000fH\u0016J\r\u00103\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b4J\u000e\u00105\u001a\u00020\u001e2\u0006\u00106\u001a\u000207J\u0010\u00108\u001a\u00020\u001e2\u0006\u00109\u001a\u00020$H\u0016J\u000e\u0010:\u001a\u00020\u001e2\u0006\u0010;\u001a\u00020<J\b\u0010=\u001a\u00020\u000fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/github/appintro/internal/AppIntroViewPager;", "Landroidx/viewpager/widget/ViewPager;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "currentTouchDownX", "", "currentTouchDownY", "customScroller", "Lcom/github/appintro/internal/ScrollerCustomDuration;", "illegallyRequestedNextPageLastCalled", "", "isFullPagingEnabled", "", "()Z", "setFullPagingEnabled", "(Z)V", "isPermissionSlide", "setPermissionSlide", "onNextPageRequestedListener", "Lcom/github/appintro/AppIntroViewPagerListener;", "getOnNextPageRequestedListener", "()Lcom/github/appintro/AppIntroViewPagerListener;", "setOnNextPageRequestedListener", "(Lcom/github/appintro/AppIntroViewPagerListener;)V", "pageChangeListener", "Landroidx/viewpager/widget/ViewPager$OnPageChangeListener;", "addOnPageChangeListener", "", "listener", "Lcom/github/appintro/AppIntroBase$OnPageChangeListener;", "Lcom/github/appintro/AppIntroBase;", "addOnPageChangeListener$appintro_release", "getCurrentSlideNumber", "", "size", "goToNextSlide", "goToPreviousSlide", "handleTouchEvent", "event", "Landroid/view/MotionEvent;", "isFirstSlide", "isLastSlide", "isSwipeForward", "oldX", "newX", "onInterceptTouchEvent", "onTouchEvent", "performClick", "reCenterCurrentSlide", "reCenterCurrentSlide$appintro_release", "setAppIntroPageTransformer", "appIntroTransformer", "Lcom/github/appintro/AppIntroPageTransformerType;", "setCurrentItem", "currentItem", "setScrollDurationFactor", "factor", "", "userIllegallyRequestNextPage", "Companion", "appintro_release"})
public final class AppIntroViewPager
extends ViewPager {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private boolean isFullPagingEnabled;
    private boolean isPermissionSlide;
    @Nullable
    private AppIntroViewPagerListener onNextPageRequestedListener;
    private float currentTouchDownX;
    private float currentTouchDownY;
    private long illegallyRequestedNextPageLastCalled;
    @Nullable
    private ScrollerCustomDuration customScroller;
    @Nullable
    private ViewPager.OnPageChangeListener pageChangeListener;
    private static final int ON_ILLEGALLY_REQUESTED_NEXT_PAGE_MAX_INTERVAL = 1000;
    @NotNull
    private static final String TAG = LogHelper.INSTANCE.makeLogTag(Reflection.getOrCreateKotlinClass(AppIntroViewPager.class));

    public AppIntroViewPager(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.isFullPagingEnabled = true;
        try {
            Field scroller = ViewPager.class.getDeclaredField("mScroller");
            scroller.setAccessible(true);
            Field interpolator = ViewPager.class.getDeclaredField("sInterpolator");
            interpolator.setAccessible(true);
            Object object = interpolator.get(null);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.animation.Interpolator");
            this.customScroller = new ScrollerCustomDuration(context, (Interpolator)object);
            scroller.set((Object)this, (Object)this.customScroller);
        }
        catch (NoSuchFieldException e) {
            LogHelper.e(TAG, "Failed to access the viewpager interpolator", e);
        }
    }

    public final boolean isFullPagingEnabled() {
        return this.isFullPagingEnabled;
    }

    public final void setFullPagingEnabled(boolean bl) {
        this.isFullPagingEnabled = bl;
    }

    public final boolean isPermissionSlide() {
        return this.isPermissionSlide;
    }

    public final void setPermissionSlide(boolean bl) {
        this.isPermissionSlide = bl;
    }

    @Nullable
    public final AppIntroViewPagerListener getOnNextPageRequestedListener() {
        return this.onNextPageRequestedListener;
    }

    public final void setOnNextPageRequestedListener(@Nullable AppIntroViewPagerListener appIntroViewPagerListener) {
        this.onNextPageRequestedListener = appIntroViewPagerListener;
    }

    public final void addOnPageChangeListener$appintro_release(@NotNull AppIntroBase.OnPageChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        super.addOnPageChangeListener((ViewPager.OnPageChangeListener)listener);
        this.pageChangeListener = listener;
    }

    public final void goToNextSlide() {
        int n = this.getCurrentItem();
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        this.setCurrentItem(n + (!LayoutUtil.isRtl(context) ? 1 : -1));
    }

    public final void goToPreviousSlide() {
        int n = this.getCurrentItem();
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        this.setCurrentItem(n + (!LayoutUtil.isRtl(context) ? -1 : 1));
    }

    public final void reCenterCurrentSlide$appintro_release() {
        int item = this.getCurrentItem();
        this.setCurrentItem(Math.max(item - 1, 0), false);
        this.setCurrentItem(item, false);
    }

    public final boolean isFirstSlide(int size) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        return LayoutUtil.isRtl(context) ? this.getCurrentItem() - size + 1 == 0 : this.getCurrentItem() == 0;
    }

    public final boolean isLastSlide(int size) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        return LayoutUtil.isRtl(context) ? this.getCurrentItem() == 0 : this.getCurrentItem() - size + 1 == 0;
    }

    public final int getCurrentSlideNumber(int size) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        return LayoutUtil.isRtl(context) ? size - this.getCurrentItem() : this.getCurrentItem() + 1;
    }

    public void setCurrentItem(int currentItem) {
        block1: {
            int oldItem = super.getCurrentItem();
            super.setCurrentItem(currentItem);
            if (oldItem != 0 || currentItem != 0) break block1;
            ViewPager.OnPageChangeListener onPageChangeListener = this.pageChangeListener;
            if (onPageChangeListener != null) {
                onPageChangeListener.onPageSelected(0);
            }
        }
    }

    public final void setScrollDurationFactor(double factor) {
        ScrollerCustomDuration scrollerCustomDuration = this.customScroller;
        if (scrollerCustomDuration != null) {
            scrollerCustomDuration.setScrollDurationFactor(factor);
        }
    }

    public boolean performClick() {
        return super.performClick();
    }

    public boolean onInterceptTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.handleTouchEvent(event)) {
            return false;
        }
        return super.onInterceptTouchEvent(event);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.handleTouchEvent(event)) {
            return false;
        }
        return super.onTouchEvent(event);
    }

    private final boolean handleTouchEvent(MotionEvent event) {
        block7: {
            boolean canRequestNextPage;
            block6: {
                if (!this.isFullPagingEnabled) {
                    return false;
                }
                if (event.getAction() != 0) break block6;
                this.currentTouchDownX = event.getX();
                this.currentTouchDownY = event.getY();
                break block7;
            }
            if (event.getAction() == 1) {
                this.performClick();
            }
            AppIntroViewPagerListener appIntroViewPagerListener = this.onNextPageRequestedListener;
            boolean bl = canRequestNextPage = appIntroViewPagerListener != null ? appIntroViewPagerListener.onCanRequestNextPage() : true;
            if (!canRequestNextPage && this.isSwipeForward(this.currentTouchDownX, event.getX())) {
                if (this.userIllegallyRequestNextPage()) {
                    AppIntroViewPagerListener appIntroViewPagerListener2 = this.onNextPageRequestedListener;
                    if (appIntroViewPagerListener2 != null) {
                        appIntroViewPagerListener2.onIllegallyRequestedNextPage();
                    }
                }
                return false;
            }
            if (!this.isPermissionSlide || !this.isSwipeForward(this.currentTouchDownX, event.getX())) break block7;
            AppIntroViewPagerListener appIntroViewPagerListener3 = this.onNextPageRequestedListener;
            if (appIntroViewPagerListener3 != null) {
                appIntroViewPagerListener3.onUserRequestedPermissionsDialog();
            }
        }
        return this.isFullPagingEnabled;
    }

    private final boolean isSwipeForward(float oldX, float newX) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        return LayoutUtil.isRtl(context) ? newX > oldX : oldX > newX;
    }

    private final boolean userIllegallyRequestNextPage() {
        if (System.currentTimeMillis() - this.illegallyRequestedNextPageLastCalled >= 1000L) {
            this.illegallyRequestedNextPageLastCalled = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public final void setAppIntroPageTransformer(@NotNull AppIntroPageTransformerType appIntroTransformer) {
        Intrinsics.checkNotNullParameter((Object)appIntroTransformer, (String)"appIntroTransformer");
        this.setPageTransformer(true, new ViewPagerTransformer(appIntroTransformer));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/github/appintro/internal/AppIntroViewPager$Companion;", "", "()V", "ON_ILLEGALLY_REQUESTED_NEXT_PAGE_MAX_INTERVAL", "", "TAG", "", "appintro_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

