/*
 * Decompiled with CFR 0.152.
 */
package com.github.appintro;

import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.FontRes;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.core.widget.TextViewCompat;
import com.github.appintro.AppIntroBase;
import com.github.appintro.R;
import com.github.appintro.internal.TypefaceContainer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u0004J\u0010\u0010\n\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u0004J\u0010\u0010\u000b\u001a\u00020\b2\b\b\u0001\u0010\f\u001a\u00020\u0004J\u0010\u0010\r\u001a\u00020\b2\b\b\u0001\u0010\u000e\u001a\u00020\u0004J\u0010\u0010\u000f\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u000f\u001a\u00020\b2\b\b\u0001\u0010\u0012\u001a\u00020\u0004J\u0010\u0010\u0013\u001a\u00020\b2\b\b\u0001\u0010\u0014\u001a\u00020\u0004J\u0010\u0010\u0015\u001a\u00020\b2\b\b\u0001\u0010\u0016\u001a\u00020\u0004J\u0010\u0010\u0015\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u000e\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u0004J\u0010\u0010\u001d\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u0004J\u0010\u0010\u001e\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u001e\u001a\u00020\b2\b\b\u0001\u0010\u001f\u001a\u00020\u0004J\u0010\u0010 \u001a\u00020\b2\b\b\u0001\u0010\u0014\u001a\u00020\u0004J\u0010\u0010!\u001a\u00020\b2\b\b\u0001\u0010\u0016\u001a\u00020\u0004J\u0010\u0010!\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u000e\u0010\"\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006$"}, d2={"Lcom/github/appintro/AppIntro;", "Lcom/github/appintro/AppIntroBase;", "()V", "layoutId", "", "getLayoutId", "()I", "setBackArrowColor", "", "color", "setBarColor", "setColorDoneText", "colorDoneText", "setColorSkipButton", "colorSkipButton", "setDoneText", "text", "", "doneResId", "setDoneTextAppearance", "textAppearance", "setDoneTextTypeface", "typeface", "typeURL", "", "setImageNextButton", "imageNextButton", "Landroid/graphics/drawable/Drawable;", "setNextArrowColor", "setSeparatorColor", "setSkipText", "skipResId", "setSkipTextAppearance", "setSkipTextTypeface", "showSeparator", "", "appintro_release"})
public abstract class AppIntro
extends AppIntroBase {
    private final int layoutId = R.layout.appintro_intro_layout;

    @Override
    protected int getLayoutId() {
        return this.layoutId;
    }

    public final void setBarColor(@ColorInt int color) {
        View bottomBar = this.findViewById(R.id.bottom);
        bottomBar.setBackgroundColor(color);
    }

    public final void setNextArrowColor(@ColorInt int color) {
        ImageButton nextButton = (ImageButton)this.findViewById(R.id.next);
        nextButton.setColorFilter(color);
    }

    public final void setBackArrowColor(@ColorInt int color) {
        ImageButton backButton = (ImageButton)this.findViewById(R.id.back);
        backButton.setColorFilter(color);
    }

    public final void setSeparatorColor(@ColorInt int color) {
        View separator = this.findViewById(R.id.bottom_separator);
        separator.setBackgroundColor(color);
    }

    public final void setSkipText(@Nullable CharSequence text) {
        TextView skipText = (TextView)this.findViewById(R.id.skip);
        skipText.setText(text);
    }

    public final void setSkipText(@StringRes int skipResId) {
        TextView skipText = (TextView)this.findViewById(R.id.skip);
        skipText.setText(skipResId);
    }

    public final void setSkipTextTypeface(@FontRes int typeface) {
        TextView view = (TextView)this.findViewById(R.id.skip);
        new TypefaceContainer(null, typeface).applyTo(view);
    }

    public final void setSkipTextTypeface(@Nullable String typeURL) {
        TextView view = (TextView)this.findViewById(R.id.skip);
        new TypefaceContainer(typeURL, 0).applyTo(view);
    }

    public final void setDoneText(@Nullable CharSequence text) {
        TextView doneText = (TextView)this.findViewById(R.id.done);
        doneText.setText(text);
    }

    public final void setDoneText(@StringRes int doneResId) {
        TextView doneText = (TextView)this.findViewById(R.id.done);
        doneText.setText(doneResId);
    }

    public final void setDoneTextTypeface(@Nullable String typeURL) {
        TextView view = (TextView)this.findViewById(R.id.done);
        new TypefaceContainer(typeURL, 0).applyTo(view);
    }

    public final void setDoneTextTypeface(@FontRes int typeface) {
        TextView view = (TextView)this.findViewById(R.id.done);
        new TypefaceContainer(null, typeface).applyTo(view);
    }

    public final void setColorDoneText(@ColorInt int colorDoneText) {
        TextView doneText = (TextView)this.findViewById(R.id.done);
        doneText.setTextColor(colorDoneText);
    }

    public final void setDoneTextAppearance(@StyleRes int textAppearance) {
        TextView doneText = (TextView)this.findViewById(R.id.done);
        TextViewCompat.setTextAppearance((TextView)doneText, (int)textAppearance);
    }

    public final void setColorSkipButton(@ColorInt int colorSkipButton) {
        TextView skip = (TextView)this.findViewById(R.id.skip);
        skip.setTextColor(colorSkipButton);
    }

    public final void setSkipTextAppearance(@StyleRes int textAppearance) {
        TextView skip = (TextView)this.findViewById(R.id.skip);
        TextViewCompat.setTextAppearance((TextView)skip, (int)textAppearance);
    }

    public final void setImageNextButton(@NotNull Drawable imageNextButton) {
        Intrinsics.checkNotNullParameter((Object)imageNextButton, (String)"imageNextButton");
        ImageView nextButton = (ImageView)this.findViewById(R.id.next);
        nextButton.setImageDrawable(imageNextButton);
    }

    public final void showSeparator(boolean showSeparator) {
        View bottomSeparator = this.findViewById(R.id.bottom_separator);
        if (showSeparator) {
            bottomSeparator.setVisibility(0);
        } else {
            bottomSeparator.setVisibility(4);
        }
    }
}

