/*
 * Decompiled with CFR 0.152.
 */
package com.github.paolorotolo.appintro;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.github.paolorotolo.appintro.ISlideBackgroundColorHolder;
import com.github.paolorotolo.appintro.ISlideSelectionListener;
import com.github.paolorotolo.appintro.R;
import com.github.paolorotolo.appintro.util.LogHelper;
import com.github.paolorotolo.appintro.util.TypefaceContainer;

public abstract class AppIntroBaseFragment
extends Fragment
implements ISlideSelectionListener,
ISlideBackgroundColorHolder {
    protected static final String ARG_TITLE = "title";
    protected static final String ARG_TITLE_TYPEFACE = "title_typeface";
    protected static final String ARG_TITLE_TYPEFACE_RES = "title_typeface_res";
    protected static final String ARG_DESC = "desc";
    protected static final String ARG_DESC_TYPEFACE = "desc_typeface";
    protected static final String ARG_DESC_TYPEFACE_RES = "desc_typeface_res";
    protected static final String ARG_DRAWABLE = "drawable";
    protected static final String ARG_BG_COLOR = "bg_color";
    protected static final String ARG_TITLE_COLOR = "title_color";
    protected static final String ARG_DESC_COLOR = "desc_color";
    private static final String TAG = LogHelper.makeLogTag(AppIntroBaseFragment.class);
    private int drawable;
    private int bgColor;
    private int titleColor;
    private int descColor;
    private int layoutId;
    private String title;
    private String description;
    private TypefaceContainer titleTypeface;
    private TypefaceContainer descTypeface;
    private LinearLayout mainLayout;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
        if (this.getArguments() != null && this.getArguments().size() != 0) {
            String argsTitleTypeface = this.getArguments().getString(ARG_TITLE_TYPEFACE);
            String argsDescTypeface = this.getArguments().getString(ARG_DESC_TYPEFACE);
            int argsTitleTypefaceRes = this.getArguments().getInt(ARG_TITLE_TYPEFACE_RES);
            int argsDescTypefaceRes = this.getArguments().getInt(ARG_DESC_TYPEFACE_RES);
            this.drawable = this.getArguments().getInt(ARG_DRAWABLE);
            this.title = this.getArguments().getString(ARG_TITLE);
            this.description = this.getArguments().getString(ARG_DESC);
            this.titleTypeface = new TypefaceContainer(argsTitleTypeface, argsTitleTypefaceRes);
            this.descTypeface = new TypefaceContainer(argsDescTypeface, argsDescTypefaceRes);
            this.bgColor = this.getArguments().getInt(ARG_BG_COLOR);
            this.titleColor = this.getArguments().containsKey(ARG_TITLE_COLOR) ? this.getArguments().getInt(ARG_TITLE_COLOR) : 0;
            this.descColor = this.getArguments().containsKey(ARG_DESC_COLOR) ? this.getArguments().getInt(ARG_DESC_COLOR) : 0;
        }
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (savedInstanceState != null) {
            this.drawable = savedInstanceState.getInt(ARG_DRAWABLE);
            this.title = savedInstanceState.getString(ARG_TITLE);
            this.description = savedInstanceState.getString(ARG_DESC);
            this.titleTypeface = new TypefaceContainer(savedInstanceState.getString(ARG_TITLE_TYPEFACE), savedInstanceState.getInt(ARG_TITLE_TYPEFACE_RES, 0));
            this.descTypeface = new TypefaceContainer(savedInstanceState.getString(ARG_DESC_TYPEFACE), savedInstanceState.getInt(ARG_DESC_TYPEFACE_RES, 0));
            this.bgColor = savedInstanceState.getInt(ARG_BG_COLOR);
            this.titleColor = savedInstanceState.getInt(ARG_TITLE_COLOR);
            this.descColor = savedInstanceState.getInt(ARG_DESC_COLOR);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(this.getLayoutId(), container, false);
        TextView titleText = (TextView)view.findViewById(R.id.title);
        TextView descriptionText = (TextView)view.findViewById(R.id.description);
        ImageView slideImage = (ImageView)view.findViewById(R.id.image);
        this.mainLayout = (LinearLayout)view.findViewById(R.id.main);
        titleText.setText((CharSequence)this.title);
        if (this.titleColor != 0) {
            titleText.setTextColor(this.titleColor);
        }
        this.titleTypeface.applyTo(titleText);
        this.titleTypeface.applyTo(descriptionText);
        descriptionText.setText((CharSequence)this.description);
        if (this.descColor != 0) {
            descriptionText.setTextColor(this.descColor);
        }
        slideImage.setImageResource(this.drawable);
        this.mainLayout.setBackgroundColor(this.bgColor);
        return view;
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        outState.putInt(ARG_DRAWABLE, this.drawable);
        outState.putString(ARG_TITLE, this.title);
        outState.putString(ARG_DESC, this.description);
        outState.putInt(ARG_BG_COLOR, this.bgColor);
        outState.putInt(ARG_TITLE_COLOR, this.titleColor);
        outState.putInt(ARG_DESC_COLOR, this.descColor);
        this.saveTypefacesInstanceState(outState);
        super.onSaveInstanceState(outState);
    }

    private void saveTypefacesInstanceState(Bundle outState) {
        if (this.titleTypeface != null) {
            outState.putString(ARG_TITLE_TYPEFACE, this.titleTypeface.getTypeFaceUrl());
            outState.putInt(ARG_TITLE_TYPEFACE_RES, this.titleTypeface.getTypeFaceResource());
        }
        if (this.descTypeface != null) {
            outState.putString(ARG_DESC_TYPEFACE, this.descTypeface.getTypeFaceUrl());
            outState.putInt(ARG_DESC_TYPEFACE_RES, this.descTypeface.getTypeFaceResource());
        }
    }

    @Override
    public void onSlideDeselected() {
        LogHelper.d(TAG, String.format("Slide %s has been deselected.", this.title));
    }

    @Override
    public void onSlideSelected() {
        LogHelper.d(TAG, String.format("Slide %s has been selected.", this.title));
    }

    @Override
    public int getDefaultBackgroundColor() {
        return this.bgColor;
    }

    @Override
    public void setBackgroundColor(@ColorInt int backgroundColor) {
        this.mainLayout.setBackgroundColor(backgroundColor);
    }

    @LayoutRes
    protected abstract int getLayoutId();
}

