/*
 * Decompiled with CFR 0.152.
 */
package com.github.paolorotolo.appintro;

import android.animation.ArgbEvaluator;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Vibrator;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.Toast;
import com.github.paolorotolo.appintro.AppIntroViewPager;
import com.github.paolorotolo.appintro.DefaultIndicatorController;
import com.github.paolorotolo.appintro.IndicatorController;
import com.github.paolorotolo.appintro.PagerAdapter;
import com.github.paolorotolo.appintro.PermissionObject;
import com.github.paolorotolo.appintro.ProgressIndicatorController;
import com.github.paolorotolo.appintro.R;
import com.github.paolorotolo.appintro.ViewPageTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public abstract class AppIntro2
extends AppCompatActivity {
    public static final int DEFAULT_COLOR = 1;
    private static final int DEFAULT_SCROLL_DURATION_FACTOR = 1;
    private boolean STATUS_BAR_VISIBLE = false;
    protected PagerAdapter mPagerAdapter;
    protected AppIntroViewPager pager;
    protected List<Fragment> fragments = new Vector<Fragment>();
    protected List<ImageView> dots;
    protected int slidesNumber;
    protected Vibrator mVibrator;
    protected IndicatorController mController;
    protected boolean isVibrateOn = false;
    protected int vibrateIntensity = 20;
    protected boolean baseProgressButtonEnabled = true;
    protected boolean progressButtonEnabled = true;
    protected int selectedIndicatorColor = 1;
    protected int unselectedIndicatorColor = 1;
    protected View nextButton;
    protected View doneButton;
    protected View customBackgroundView;
    protected FrameLayout backgroundFrame;
    protected int savedCurrentItem;
    protected ArrayList<PermissionObject> permissionsArray = new ArrayList();
    private static final int PERMISSIONS_REQUEST_ALL_PERMISSIONS = 1;
    private ArrayList<Integer> transitionColors;
    private ArgbEvaluator argbEvaluator = new ArgbEvaluator();
    private static String TAG = "AppIntro2";

    protected final void onCreate(Bundle savedInstanceState) {
        this.requestWindowFeature(1);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intro_layout2);
        this.nextButton = this.findViewById(R.id.next);
        this.doneButton = this.findViewById(R.id.done);
        this.backgroundFrame = (FrameLayout)this.findViewById(R.id.background);
        this.mVibrator = (Vibrator)this.getSystemService("vibrator");
        this.mPagerAdapter = new PagerAdapter(this.getSupportFragmentManager(), this.fragments);
        this.pager = (AppIntroViewPager)this.findViewById(R.id.view_pager);
        this.pager.setAdapter((android.support.v4.view.PagerAdapter)this.mPagerAdapter);
        if (savedInstanceState != null) {
            this.restoreLockingState(savedInstanceState);
        }
        this.nextButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(@NonNull View v) {
                if (AppIntro2.this.isVibrateOn) {
                    AppIntro2.this.mVibrator.vibrate((long)AppIntro2.this.vibrateIntensity);
                }
                boolean requestPermission = false;
                int position = 0;
                int i = 0;
                if (i < AppIntro2.this.permissionsArray.size()) {
                    requestPermission = AppIntro2.this.pager.getCurrentItem() + 1 == AppIntro2.this.permissionsArray.get(i).getPosition();
                    position = i;
                }
                if (requestPermission) {
                    if (Build.VERSION.SDK_INT >= 23) {
                        AppIntro2.this.requestPermissions(AppIntro2.this.permissionsArray.get(position).getPermission(), 1);
                        AppIntro2.this.permissionsArray.remove(position);
                    } else {
                        AppIntro2.this.pager.setCurrentItem(AppIntro2.this.pager.getCurrentItem() + 1);
                        AppIntro2.this.onNextPressed();
                    }
                } else {
                    AppIntro2.this.pager.setCurrentItem(AppIntro2.this.pager.getCurrentItem() + 1);
                    AppIntro2.this.onNextPressed();
                }
            }
        });
        this.doneButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(@NonNull View v) {
                if (AppIntro2.this.isVibrateOn) {
                    AppIntro2.this.mVibrator.vibrate((long)AppIntro2.this.vibrateIntensity);
                }
                AppIntro2.this.onDonePressed();
            }
        });
        this.pager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                if (AppIntro2.this.transitionColors != null) {
                    if (position < AppIntro2.this.pager.getAdapter().getCount() - 1 && position < AppIntro2.this.transitionColors.size() - 1) {
                        AppIntro2.this.pager.setBackgroundColor((Integer)AppIntro2.this.argbEvaluator.evaluate(positionOffset, AppIntro2.this.transitionColors.get(position), AppIntro2.this.transitionColors.get(position + 1)));
                    } else {
                        AppIntro2.this.pager.setBackgroundColor((Integer)AppIntro2.this.transitionColors.get(AppIntro2.this.transitionColors.size() - 1));
                    }
                }
            }

            public void onPageSelected(int position) {
                if (AppIntro2.this.slidesNumber > 1) {
                    AppIntro2.this.mController.selectPosition(position);
                }
                if (!AppIntro2.this.pager.isNextPagingEnabled()) {
                    if (AppIntro2.this.pager.getCurrentItem() != AppIntro2.this.pager.getLockPage()) {
                        AppIntro2.this.setProgressButtonEnabled(AppIntro2.this.baseProgressButtonEnabled);
                        AppIntro2.this.pager.setNextPagingEnabled(true);
                    } else {
                        AppIntro2.this.setProgressButtonEnabled(AppIntro2.this.progressButtonEnabled);
                    }
                } else {
                    AppIntro2.this.setProgressButtonEnabled(AppIntro2.this.progressButtonEnabled);
                }
                AppIntro2.this.onSlideChanged();
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.setScrollDurationFactor(1);
        this.pager.setCurrentItem(this.savedCurrentItem);
        this.init(savedInstanceState);
        this.slidesNumber = this.fragments.size();
        if (this.slidesNumber == 1) {
            this.setProgressButtonEnabled(this.progressButtonEnabled);
        } else {
            this.initController();
        }
    }

    protected void setScrollDurationFactor(int factor) {
        this.pager.setScrollDurationFactor(factor);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("baseProgressButtonEnabled", this.baseProgressButtonEnabled);
        outState.putBoolean("progressButtonEnabled", this.progressButtonEnabled);
        outState.putBoolean("nextEnabled", this.pager.isPagingEnabled());
        outState.putBoolean("nextPagingEnabled", this.pager.isNextPagingEnabled());
        outState.putInt("lockPage", this.pager.getLockPage());
        outState.putInt("currentItem", this.pager.getCurrentItem());
    }

    protected void restoreLockingState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.baseProgressButtonEnabled = savedInstanceState.getBoolean("baseProgressButtonEnabled");
        this.progressButtonEnabled = savedInstanceState.getBoolean("progressButtonEnabled");
        this.savedCurrentItem = savedInstanceState.getInt("currentItem");
        this.pager.setPagingEnabled(savedInstanceState.getBoolean("nextEnabled"));
        this.pager.setNextPagingEnabled(savedInstanceState.getBoolean("nextPagingEnabled"));
        this.pager.setLockPage(savedInstanceState.getInt("lockPage"));
    }

    public AppIntroViewPager getPager() {
        return this.pager;
    }

    private void initController() {
        if (this.mController == null) {
            this.mController = new DefaultIndicatorController();
        }
        FrameLayout indicatorContainer = (FrameLayout)this.findViewById(R.id.indicator_container);
        indicatorContainer.addView(this.mController.newInstance((Context)this));
        this.mController.initialize(this.slidesNumber);
        if (this.selectedIndicatorColor != 1) {
            this.mController.setSelectedIndicatorColor(this.selectedIndicatorColor);
        }
        if (this.unselectedIndicatorColor != 1) {
            this.mController.setUnselectedIndicatorColor(this.unselectedIndicatorColor);
        }
    }

    public void addSlide(@NonNull Fragment fragment) {
        this.fragments.add(fragment);
        this.mPagerAdapter.notifyDataSetChanged();
    }

    @NonNull
    public List<Fragment> getSlides() {
        return this.mPagerAdapter.getFragments();
    }

    @Deprecated
    public void showDoneButton(boolean showDone) {
        this.setProgressButtonEnabled(showDone);
    }

    public void setProgressButtonEnabled(boolean progressButtonEnabled) {
        this.progressButtonEnabled = progressButtonEnabled;
        if (progressButtonEnabled) {
            if (this.pager.getCurrentItem() == this.slidesNumber - 1) {
                this.setButtonState(this.nextButton, false);
                this.setButtonState(this.doneButton, true);
            } else {
                this.setButtonState(this.nextButton, true);
                this.setButtonState(this.doneButton, false);
            }
        } else {
            this.setButtonState(this.nextButton, false);
            this.setButtonState(this.doneButton, false);
        }
    }

    public boolean isProgressButtonEnabled() {
        return this.progressButtonEnabled;
    }

    private void setButtonState(View button, boolean show) {
        if (show) {
            button.setVisibility(0);
        } else {
            button.setVisibility(4);
        }
    }

    public void setNavBarColor(String Color2) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().setNavigationBarColor(Color.parseColor((String)Color2));
        }
    }

    public void showStatusBar(boolean isVisible) {
        this.STATUS_BAR_VISIBLE = isVisible;
        if (this.STATUS_BAR_VISIBLE) {
            this.getWindow().clearFlags(1024);
        } else {
            this.getWindow().setFlags(1024, 1024);
        }
    }

    public void setBackgroundView(View view) {
        this.customBackgroundView = view;
        if (this.customBackgroundView != null) {
            this.backgroundFrame.addView(this.customBackgroundView);
        }
    }

    public void setVibrate(boolean vibrate) {
        this.isVibrateOn = vibrate;
    }

    public void setVibrateIntensity(int intensity) {
        this.vibrateIntensity = intensity;
    }

    public void setFadeAnimation() {
        this.pager.setPageTransformer(true, new ViewPageTransformer(ViewPageTransformer.TransformType.FADE));
    }

    public void setZoomAnimation() {
        this.pager.setPageTransformer(true, new ViewPageTransformer(ViewPageTransformer.TransformType.ZOOM));
    }

    public void setFlowAnimation() {
        this.pager.setPageTransformer(true, new ViewPageTransformer(ViewPageTransformer.TransformType.FLOW));
    }

    public void setSlideOverAnimation() {
        this.pager.setPageTransformer(true, new ViewPageTransformer(ViewPageTransformer.TransformType.SLIDE_OVER));
    }

    public void setDepthAnimation() {
        this.pager.setPageTransformer(true, new ViewPageTransformer(ViewPageTransformer.TransformType.DEPTH));
    }

    public void setCustomTransformer(@Nullable ViewPager.PageTransformer transformer) {
        this.pager.setPageTransformer(true, transformer);
    }

    public void setOffScreenPageLimit(int limit) {
        this.pager.setOffscreenPageLimit(limit);
    }

    public void setProgressIndicator() {
        this.mController = new ProgressIndicatorController();
    }

    public void setCustomIndicator(@NonNull IndicatorController controller) {
        this.mController = controller;
    }

    public abstract void init(@Nullable Bundle var1);

    public abstract void onDonePressed();

    public abstract void onNextPressed();

    public abstract void onSlideChanged();

    public boolean onKeyDown(int code, KeyEvent kevent) {
        if (code == 66 || code == 96 || code == 23) {
            ViewPager vp = (ViewPager)this.findViewById(R.id.view_pager);
            if (vp.getCurrentItem() == vp.getAdapter().getCount() - 1) {
                this.onDonePressed();
            } else {
                vp.setCurrentItem(vp.getCurrentItem() + 1);
            }
            return false;
        }
        return super.onKeyDown(code, kevent);
    }

    public void setIndicatorColor(int selectedIndicatorColor, int unselectedIndicatorColor) {
        this.selectedIndicatorColor = selectedIndicatorColor;
        this.unselectedIndicatorColor = unselectedIndicatorColor;
        if (this.mController != null) {
            if (selectedIndicatorColor != 1) {
                this.mController.setSelectedIndicatorColor(selectedIndicatorColor);
            }
            if (unselectedIndicatorColor != 1) {
                this.mController.setUnselectedIndicatorColor(unselectedIndicatorColor);
            }
        }
    }

    public void setNextPageSwipeLock(boolean lockEnable) {
        if (lockEnable) {
            this.baseProgressButtonEnabled = this.progressButtonEnabled;
            this.setProgressButtonEnabled(!lockEnable);
        } else {
            this.setProgressButtonEnabled(this.baseProgressButtonEnabled);
        }
        this.pager.setNextPagingEnabled(!lockEnable);
    }

    public void setSwipeLock(boolean lockEnable) {
        if (lockEnable) {
            this.baseProgressButtonEnabled = this.progressButtonEnabled;
        } else {
            this.setProgressButtonEnabled(this.baseProgressButtonEnabled);
        }
        this.pager.setPagingEnabled(!lockEnable);
    }

    public void setAnimationColors(@ColorInt ArrayList<Integer> colors) {
        this.transitionColors = colors;
    }

    public void askForPermissions(String[] permissions, int slidesNumber) {
        if (Build.VERSION.SDK_INT >= 23) {
            if (slidesNumber == 0) {
                Toast.makeText((Context)this.getBaseContext(), (CharSequence)"Invalid Slide Number", (int)0).show();
            } else {
                PermissionObject permission = new PermissionObject(permissions, slidesNumber);
                this.permissionsArray.add(permission);
                this.setSwipeLock(true);
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 1: {
                this.pager.setCurrentItem(this.pager.getCurrentItem() + 1);
                break;
            }
            default: {
                Log.e((String)TAG, (String)"Unexpected request code");
            }
        }
    }

    static enum TransformType {
        FLOW,
        DEPTH,
        ZOOM,
        SLIDE_OVER,
        FADE;

    }
}

