/*
 * Decompiled with CFR 0.152.
 */
package com.github.paolorotolo.appintro;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.github.paolorotolo.appintro.IndicatorController;
import com.github.paolorotolo.appintro.R;
import com.github.paolorotolo.appintro.ResourceUtils;
import java.util.ArrayList;
import java.util.List;

class DefaultIndicatorController
implements IndicatorController {
    public static final int DEFAULT_COLOR = 1;
    private Context mContext;
    private LinearLayout mDotLayout;
    private List<ImageView> mDots;
    private int mSlideCount;
    int selectedDotColor = 1;
    int unselectedDotColor = 1;
    int mCurrentposition;
    private static final int FIRST_PAGE_NUM = 0;

    DefaultIndicatorController() {
    }

    @Override
    public View newInstance(@NonNull Context context) {
        this.mContext = context;
        this.mDotLayout = (LinearLayout)View.inflate((Context)context, (int)R.layout.default_indicator, null);
        return this.mDotLayout;
    }

    @Override
    public void initialize(int slideCount) {
        this.mDots = new ArrayList<ImageView>();
        this.mSlideCount = slideCount;
        this.selectedDotColor = -1;
        this.unselectedDotColor = -1;
        for (int i = 0; i < slideCount; ++i) {
            ImageView dot = new ImageView(this.mContext);
            dot.setImageDrawable(ResourceUtils.getDrawable(this.mContext, R.drawable.indicator_dot_grey));
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            this.mDotLayout.addView((View)dot, (ViewGroup.LayoutParams)params);
            this.mDots.add(dot);
        }
        this.selectPosition(0);
    }

    @Override
    public void selectPosition(int index) {
        this.mCurrentposition = index;
        for (int i = 0; i < this.mSlideCount; ++i) {
            int drawableId = i == index ? R.drawable.indicator_dot_white : R.drawable.indicator_dot_grey;
            Drawable drawable2 = ResourceUtils.getDrawable(this.mContext, drawableId);
            if (this.selectedDotColor != 1 && i == index) {
                drawable2.mutate().setColorFilter(this.selectedDotColor, PorterDuff.Mode.SRC_IN);
            }
            if (this.unselectedDotColor != 1 && i != index) {
                drawable2.mutate().setColorFilter(this.unselectedDotColor, PorterDuff.Mode.SRC_IN);
            }
            this.mDots.get(i).setImageDrawable(drawable2);
        }
    }

    @Override
    public void setSelectedIndicatorColor(int color) {
        this.selectedDotColor = color;
        this.selectPosition(this.mCurrentposition);
    }

    @Override
    public void setUnselectedIndicatorColor(int color) {
        this.unselectedDotColor = color;
        this.selectPosition(this.mCurrentposition);
    }
}

