/*
 * Decompiled with CFR 0.152.
 */
package com.github.paolorotolo.appintro;

import android.content.Context;
import android.os.Bundle;
import android.os.Vibrator;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.view.ViewPager;
import android.view.KeyEvent;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.github.paolorotolo.appintro.DefaultIndicatorController;
import com.github.paolorotolo.appintro.FadePageTransformer;
import com.github.paolorotolo.appintro.IndicatorController;
import com.github.paolorotolo.appintro.PagerAdapter;
import com.github.paolorotolo.appintro.ProgressIndicatorController;
import com.github.paolorotolo.appintro.R;
import java.util.List;
import java.util.Vector;

public abstract class AppIntro2
extends FragmentActivity {
    private PagerAdapter mPagerAdapter;
    private ViewPager pager;
    private List<Fragment> fragments = new Vector<Fragment>();
    private List<ImageView> dots;
    private int slidesNumber;
    private Vibrator mVibrator;
    private IndicatorController mController;
    private boolean isVibrateOn = false;
    private int vibrateIntensity = 20;
    private boolean showDone = true;

    protected final void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.setContentView(R.layout.intro_layout2);
        final ImageView nextButton = (ImageView)this.findViewById(R.id.next);
        final ImageView doneButton = (ImageView)this.findViewById(R.id.done);
        this.mVibrator = (Vibrator)this.getSystemService("vibrator");
        nextButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(@NonNull View v) {
                if (AppIntro2.this.isVibrateOn) {
                    AppIntro2.this.mVibrator.vibrate((long)AppIntro2.this.vibrateIntensity);
                }
                AppIntro2.this.pager.setCurrentItem(AppIntro2.this.pager.getCurrentItem() + 1);
            }
        });
        doneButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(@NonNull View v) {
                if (AppIntro2.this.isVibrateOn) {
                    AppIntro2.this.mVibrator.vibrate((long)AppIntro2.this.vibrateIntensity);
                }
                AppIntro2.this.onDonePressed();
            }
        });
        this.mPagerAdapter = new PagerAdapter(super.getSupportFragmentManager(), this.fragments);
        this.pager = (ViewPager)this.findViewById(R.id.view_pager);
        this.pager.setAdapter((android.support.v4.view.PagerAdapter)this.mPagerAdapter);
        this.pager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                AppIntro2.this.mController.selectPosition(position);
                if (position == AppIntro2.this.slidesNumber - 1) {
                    nextButton.setVisibility(8);
                    if (AppIntro2.this.showDone) {
                        doneButton.setVisibility(0);
                    } else {
                        doneButton.setVisibility(4);
                    }
                } else {
                    doneButton.setVisibility(8);
                    nextButton.setVisibility(0);
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.init(savedInstanceState);
        this.slidesNumber = this.fragments.size();
        if (this.slidesNumber == 1) {
            nextButton.setVisibility(8);
            doneButton.setVisibility(0);
        }
        this.initController();
    }

    private void initController() {
        if (this.mController == null) {
            this.mController = new DefaultIndicatorController();
        }
        FrameLayout indicatorContainer = (FrameLayout)this.findViewById(R.id.indicator_container);
        indicatorContainer.addView(this.mController.newInstance((Context)this));
        this.mController.initialize(this.slidesNumber);
    }

    public void addSlide(@NonNull Fragment fragment) {
        this.fragments.add(fragment);
        this.mPagerAdapter.notifyDataSetChanged();
    }

    @NonNull
    public List<Fragment> getSlides() {
        return this.mPagerAdapter.getFragments();
    }

    public void showDoneButton(boolean showDone) {
        this.showDone = showDone;
        if (!showDone) {
            ImageView done = (ImageView)this.findViewById(R.id.done);
            done.setVisibility(8);
        }
    }

    public void setVibrate(boolean vibrate) {
        this.isVibrateOn = vibrate;
    }

    public void setVibrateIntensity(int intensity) {
        this.vibrateIntensity = intensity;
    }

    public void setFadeAnimation() {
        this.pager.setPageTransformer(true, (ViewPager.PageTransformer)new FadePageTransformer());
    }

    public void setCustomTransformer(@Nullable ViewPager.PageTransformer transformer) {
        this.pager.setPageTransformer(true, transformer);
    }

    public void setOffScreenPageLimit(int limit) {
        this.pager.setOffscreenPageLimit(limit);
    }

    public void setProgressIndicator() {
        this.mController = new ProgressIndicatorController();
    }

    public void setCustomIndicator(@NonNull IndicatorController controller) {
        this.mController = controller;
    }

    public abstract void init(@Nullable Bundle var1);

    public abstract void onDonePressed();

    public boolean onKeyDown(int code, KeyEvent kevent) {
        if (code == 66 || code == 96) {
            ViewPager vp = (ViewPager)this.findViewById(R.id.view_pager);
            if (vp.getCurrentItem() == vp.getAdapter().getCount() - 1) {
                this.onDonePressed();
            } else {
                vp.setCurrentItem(vp.getCurrentItem() + 1);
            }
            return false;
        }
        return super.onKeyDown(code, kevent);
    }
}

