/*
 * Decompiled with CFR 0.152.
 */
package panda.roid.image;

import android.graphics.Bitmap;
import java.io.IOException;
import java.io.OutputStream;
import panda.image.AbstractImageWrapper;
import panda.image.ImageWrapper;

public class AndroidImageWrapper
extends AbstractImageWrapper {
    private Bitmap image;

    public AndroidImageWrapper(Bitmap image) {
        this.image = image;
    }

    public AndroidImageWrapper(Bitmap image, String format) {
        this.image = image;
        this.format = format;
    }

    public AndroidImageWrapper(Bitmap image, String format, int quality) {
        this.image = image;
        this.format = format;
        this.quality = quality;
    }

    public Bitmap getImage() {
        return this.image;
    }

    public void setImage(Bitmap image) {
        this.image = image;
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    private Bitmap.CompressFormat getCompressFormat() {
        if ("png".equalsIgnoreCase(this.format)) {
            return Bitmap.CompressFormat.PNG;
        }
        return Bitmap.CompressFormat.JPEG;
    }

    public void write(OutputStream os) throws IOException {
        this.image.compress(this.getCompressFormat(), this.quality, os);
    }

    public ImageWrapper resize(int width, int height) {
        Bitmap bm = Bitmap.createScaledBitmap((Bitmap)this.image, (int)width, (int)height, (boolean)false);
        AndroidImageWrapper iw = new AndroidImageWrapper(bm, this.format, this.quality);
        return iw;
    }
}

