/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import io.codetail.animation.RevealAnimator;
import io.codetail.animation.SupportAnimator;
import io.codetail.animation.ViewAnimationUtils;

public class RevealLinearLayout
extends LinearLayout
implements RevealAnimator {
    private Path mRevealPath;
    private boolean mClipOutlines;
    private int mCenterX;
    private int mCenterY;
    private float mRadius;
    private View mTarget;
    private float mStartRadius;
    private float mEndRadius;
    private final Rect mTargetBounds = new Rect();

    public RevealLinearLayout(Context context) {
        this(context, null);
    }

    public RevealLinearLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RevealLinearLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs);
        this.mRevealPath = new Path();
    }

    @Override
    public void setTarget(View view) {
        this.mTarget = view;
        view.getHitRect(this.mTargetBounds);
    }

    @Override
    public void setCenter(int centerX, int centerY) {
        this.mCenterX = centerX;
        this.mCenterY = centerY;
    }

    @Override
    public void setClipOutlines(boolean clip) {
        this.mClipOutlines = clip;
    }

    @Override
    public void setRevealRadius(float radius) {
        this.mRadius = radius;
        this.invalidate(this.mTargetBounds);
    }

    @Override
    public float getRevealRadius() {
        return this.mRadius;
    }

    @Override
    public void setupStartValues() {
        this.mClipOutlines = false;
        this.mRadius = 0.0f;
    }

    @Override
    public void setRadius(float start, float end) {
        this.mStartRadius = start;
        this.mEndRadius = end;
    }

    @Override
    public Rect getTargetBounds() {
        return this.mTargetBounds;
    }

    @Override
    public SupportAnimator startReverseAnimation() {
        return ViewAnimationUtils.createCircularReveal(this.mTarget, this.mCenterX, this.mCenterY, this.mEndRadius, this.mStartRadius);
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        if (!this.mClipOutlines) {
            return super.drawChild(canvas, child, drawingTime);
        }
        if (this.mTarget == child) {
            int state = canvas.save();
            this.mRevealPath.reset();
            this.mRevealPath.addCircle((float)this.mCenterX, (float)this.mCenterY, this.mRadius, Path.Direction.CW);
            canvas.clipPath(this.mRevealPath);
            boolean isInvalided = super.drawChild(canvas, child, drawingTime);
            canvas.restoreToCount(state);
            return isInvalided;
        }
        return super.drawChild(canvas, child, drawingTime);
    }
}

