/*
 * Decompiled with CFR 0.152.
 */
package io.codetail.animation;

import android.view.animation.Interpolator;
import com.nineoldandroids.animation.Animator;
import io.codetail.animation.RevealAnimator;
import io.codetail.animation.SupportAnimator;
import java.lang.ref.WeakReference;

final class SupportAnimatorPreL
extends SupportAnimator {
    WeakReference<Animator> mAnimator;

    SupportAnimatorPreL(Animator animator, RevealAnimator target) {
        super(target);
        this.mAnimator = new WeakReference<Animator>(animator);
    }

    @Override
    public boolean isNativeAnimator() {
        return false;
    }

    @Override
    public Object get() {
        return this.mAnimator.get();
    }

    @Override
    public void start() {
        Animator a = (Animator)this.mAnimator.get();
        if (a != null) {
            a.start();
        }
    }

    @Override
    public void setDuration(int duration) {
        Animator a = (Animator)this.mAnimator.get();
        if (a != null) {
            a.setDuration((long)duration);
        }
    }

    @Override
    public void setInterpolator(Interpolator value) {
        Animator a = (Animator)this.mAnimator.get();
        if (a != null) {
            a.setInterpolator(value);
        }
    }

    @Override
    public void addListener(final SupportAnimator.AnimatorListener listener) {
        Animator a = (Animator)this.mAnimator.get();
        if (a == null) {
            return;
        }
        if (listener == null) {
            a.addListener(null);
            return;
        }
        a.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                listener.onAnimationStart();
            }

            public void onAnimationEnd(Animator animation) {
                listener.onAnimationEnd();
            }

            public void onAnimationCancel(Animator animation) {
                listener.onAnimationCancel();
            }

            public void onAnimationRepeat(Animator animation) {
                listener.onAnimationRepeat();
            }
        });
    }

    @Override
    public boolean isRunning() {
        Animator a = (Animator)this.mAnimator.get();
        return a != null && a.isRunning();
    }

    @Override
    public void cancel() {
        Animator a = (Animator)this.mAnimator.get();
        if (a != null) {
            a.cancel();
        }
    }

    @Override
    public void end() {
        Animator a = (Animator)this.mAnimator.get();
        if (a != null) {
            a.end();
        }
    }

    @Override
    public void setupStartValues() {
        Animator a = (Animator)this.mAnimator.get();
        if (a != null) {
            a.setupStartValues();
        }
    }

    @Override
    public void setupEndValues() {
        Animator a = (Animator)this.mAnimator.get();
        if (a != null) {
            a.setupEndValues();
        }
    }
}

